/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.WhispererAnimations;
import com.Polarice3.Goety.common.entities.ally.Whisperer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class WhispererModel<T extends Whisperer>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart whisperer;
    private final ModelPart head;

    public WhispererModel(ModelPart root) {
        this.root = root;
        this.whisperer = root.m_171324_("whisperer");
        this.head = this.whisperer.m_171324_("top_part").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition whisperer = partdefinition.m_171599_("whisperer", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition top_part = whisperer.m_171599_("top_part", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition head = top_part.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.0f));
        PartDefinition lower_jaw = head.m_171599_("lower_jaw", CubeListBuilder.m_171558_().m_171514_(25, 19).m_171488_(-5.5f, -6.0f, -10.0f, 11.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(32, 45).m_171488_(-5.5f, -1.0f, -10.0f, 11.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.5f));
        PartDefinition frill = lower_jaw.m_171599_("frill", CubeListBuilder.m_171558_().m_171514_(9, 0).m_171488_(-9.5f, -27.0f, -9.0f, 19.0f, 0.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)28.0f, (float)-4.5f));
        PartDefinition top_jaw = head.m_171599_("top_jaw", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-5.5f, -8.0f, -10.0f, 11.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(32, 45).m_171488_(-5.5f, -6.0f, -10.0f, 11.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.5f));
        PartDefinition flower = top_jaw.m_171599_("flower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)28.0f, (float)-4.5f));
        PartDefinition cube_r1 = flower.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(52, 56).m_171488_(-2.5f, -4.0f, 0.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-36.0f, (float)1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = flower.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(42, 56).m_171488_(-2.5f, -4.0f, 0.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-36.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = flower.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(50, 56).m_171488_(0.0f, -4.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-36.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition cube_r4 = flower.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(42, 56).m_171488_(0.0f, -4.0f, -2.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-36.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition body = top_part.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -28.0f, -1.5f, 9.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(85, 48).m_171488_(-3.5f, -28.0f, -0.5f, 7.0f, 14.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition right_arm = top_part.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-12.0f, (float)0.5f));
        PartDefinition upper_right = right_arm.m_171599_("upper_right", CubeListBuilder.m_171558_().m_171514_(61, 43).m_171488_(-5.0f, 11.5f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(90, -6).m_171488_(-1.0f, -0.5f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(102, -6).m_171488_(-4.0f, -0.5f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(77, 48).m_171488_(-5.0f, -0.5f, -2.0f, 4.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(93, 13).m_171480_().m_171488_(-5.0f, -0.5f, 2.0f, 4.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(51, 19).m_171488_(-5.0f, 0.5f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-0.5f, (float)0.0f));
        PartDefinition bottom_right = right_arm.m_171599_("bottom_right", CubeListBuilder.m_171558_().m_171514_(101, 13).m_171488_(-2.5f, 0.0f, -2.0f, 5.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(97, 26).m_171480_().m_171488_(-2.5f, 0.0f, 2.0f, 5.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(101, 31).m_171480_().m_171488_(-1.5f, 0.0f, -3.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(107, 20).m_171480_().m_171488_(1.5f, 0.0f, -3.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(61, 55).m_171480_().m_171488_(-2.5f, 1.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(61, 49).m_171480_().m_171488_(-2.5f, 10.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_arm = top_part.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-12.0f, (float)0.5f));
        PartDefinition upper_left = left_arm.m_171599_("upper_left", CubeListBuilder.m_171558_().m_171514_(61, 19).m_171488_(0.0f, 0.5f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(61, 25).m_171488_(0.0f, 11.5f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(66, -6).m_171488_(4.0f, -0.5f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(78, -6).m_171488_(1.0f, -0.5f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(77, 13).m_171488_(1.0f, -0.5f, -2.0f, 4.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(85, 13).m_171480_().m_171488_(1.0f, -0.5f, 2.0f, 4.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)-0.5f, (float)0.0f));
        PartDefinition bottom_left = left_arm.m_171599_("bottom_left", CubeListBuilder.m_171558_().m_171514_(77, 26).m_171488_(-2.5f, 0.0f, -2.0f, 5.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(87, 26).m_171488_(-2.5f, 0.0f, 2.0f, 5.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(77, 31).m_171488_(1.5f, 0.0f, -3.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(89, 31).m_171488_(-1.5f, 0.0f, -3.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(61, 31).m_171488_(-2.5f, 1.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(61, 37).m_171488_(-2.5f, 10.0f, -3.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = whisperer.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(13, 18).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)10.0f, (float)0.5f));
        PartDefinition right_foot = right_leg.m_171599_("right_foot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.5f, (float)14.3f, (float)-0.5f));
        PartDefinition cube_r5 = right_foot.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(21, 1).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)-1.5708f, (float)0.7854f));
        PartDefinition cube_r6 = right_foot.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(21, 2).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)-1.5708f, (float)-0.7854f));
        PartDefinition cube_r7 = right_foot.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(21, 3).m_171488_(-1.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)2.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = right_foot.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(21, 18).m_171488_(-1.0f, 0.0f, -1.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = whisperer.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(1, 18).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 14.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)10.0f, (float)0.5f));
        PartDefinition left_foot = left_leg.m_171599_("left_foot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.5f, (float)14.3f, (float)-0.5f));
        PartDefinition cube_r9 = left_foot.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(21, 19).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)-1.5708f, (float)0.7854f));
        PartDefinition cube_r10 = left_foot.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-1.0f, (float)0.5f, (float)0.0f, (float)-1.5708f, (float)-0.7854f));
        PartDefinition cube_r11 = left_foot.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(9, 19).m_171488_(-1.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)2.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = left_foot.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(9, 20).m_171488_(-1.0f, 0.0f, -1.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-1.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_() && !((Whisperer)entity).isSummoning()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        this.m_233381_(((Whisperer)entity).idleAnimationState, WhispererAnimations.IDLE, ageInTicks);
        this.m_233385_(((Whisperer)entity).walkAnimationState, WhispererAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
        this.m_233381_(((Whisperer)entity).attackAnimationState, WhispererAnimations.ATTACK, ageInTicks);
        this.m_233381_(((Whisperer)entity).summonAnimationState, WhispererAnimations.SUMMON, ageInTicks);
        this.m_233381_(((Whisperer)entity).summonPoisonAnimationState, WhispererAnimations.SUMMON_POISON, ageInTicks);
        this.m_233381_(((Whisperer)entity).summonThornsAnimationState, WhispererAnimations.SUMMON_THORN, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

