/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.entities.ally.illager.ITrainIllager;
import com.Polarice3.Goety.api.entities.ally.illager.IllagerType;
import com.Polarice3.Goety.common.blocks.entities.BarracksBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.config.MobsConfig;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class OminousPyreBlockEntity
extends BarracksBlockEntity {
    public OminousPyreBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.OMINOUS_PYRE.get(), p_155229_, p_155230_);
    }

    @Override
    public Predicate<Mob> trainingRequirements(Level level, BlockPos blockPos) {
        EntityType<? extends Mob> entityType = this.getTrainedMob(level, blockPos);
        if (entityType != null) {
            ITrainIllager illagerType = IllagerType.getIllagerFromType(level, blockPos, this.getRange(), entityType);
            return mob -> {
                if (!(mob instanceof AbstractIllagerServant)) return false;
                AbstractIllagerServant illager = (AbstractIllagerServant)mob;
                if (illagerType == null) return false;
                if (!illagerType.mobCanTrainTo((Mob)illager, level, blockPos, this.getRange())) return false;
                if (illager.getTrueOwner() == this.getTrueOwner()) return true;
                if (illager.getTrueOwner() != null) return false;
                return true;
            };
        }
        return mob -> false;
    }

    @Override
    public boolean autoMode() {
        return (Boolean)MobsConfig.IllagerServantAutoTrain.get();
    }

    @Override
    public void setVariant(Level level, BlockPos blockPos) {
        if (!IllagerType.getIllagerList().isEmpty()) {
            EntityType<? extends Mob> entityType = null;
            for (IllagerType illagerType : IllagerType.values()) {
                if (illagerType.getIllager() == null || !illagerType.getIllager().canSpawn(level, blockPos, this.getRange())) continue;
                entityType = illagerType.getIllager().getIllager(level, blockPos, this.getRange());
                break;
            }
            this.setEntityType(entityType);
        }
    }
}

