/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities.void_vault;

import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModUUIDUtil;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VoidVaultServerData {
    static final String SERVER_DATA_KEY = "server_data";
    public static Codec<VoidVaultServerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModUUIDUtil.CODEC_LINKED_SET.optionalFieldOf("rewarded_players", Set.of()).forGetter(data -> data.rewardedPlayers), (App)Codec.LONG.optionalFieldOf("state_updating_resumes_at", (Object)0L).forGetter(data -> data.stateUpdatingResumesAt), (App)ItemStack.f_41582_.listOf().optionalFieldOf("items_to_eject", List.of()).forGetter(data -> data.itemsToEject), (App)Codec.INT.optionalFieldOf("total_ejections_needed", (Object)0).forGetter(data -> data.totalEjectionsNeeded)).apply((Applicative)instance, VoidVaultServerData::new));
    private static final int MAX_STORED_REWARDED_PLAYERS = 128;
    private final Set<UUID> rewardedPlayers = new ObjectLinkedOpenHashSet();
    private long stateUpdatingResumesAt;
    private final List<ItemStack> itemsToEject = new ObjectArrayList();
    private long lastFailedUnlockTime;
    private int totalEjectionsNeeded;
    public boolean dirty;

    public VoidVaultServerData(Set<UUID> rewardedPlayers, long stateUpdatingResumesAt, List<ItemStack> itemsToEject, int totalEjectionsNeeded) {
        this.rewardedPlayers.addAll(rewardedPlayers);
        this.stateUpdatingResumesAt = stateUpdatingResumesAt;
        this.itemsToEject.addAll(itemsToEject);
        this.totalEjectionsNeeded = totalEjectionsNeeded;
    }

    public VoidVaultServerData() {
    }

    public void setLastFailedUnlockTime(long lastFailedUnlockTime) {
        this.lastFailedUnlockTime = lastFailedUnlockTime;
    }

    public long getLastFailedUnlockTime() {
        return this.lastFailedUnlockTime;
    }

    public Set<UUID> getRewardedPlayers() {
        return this.rewardedPlayers;
    }

    public boolean hasRewardedPlayer(Player player) {
        return this.rewardedPlayers.contains(player.m_20148_());
    }

    @VisibleForTesting
    public void markPlayerAsRewarded(Player player) {
        Iterator<UUID> iterator;
        this.rewardedPlayers.add(player.m_20148_());
        if (this.rewardedPlayers.size() > 128 && (iterator = this.rewardedPlayers.iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.markDirty();
    }

    public long getStateUpdatingResumeTime() {
        return this.stateUpdatingResumesAt;
    }

    public void setStateUpdatingResumeTime(long stateUpdatingResumesAt) {
        this.stateUpdatingResumesAt = stateUpdatingResumesAt;
        this.markDirty();
    }

    public List<ItemStack> getItemsToEject() {
        return this.itemsToEject;
    }

    public void finishEjecting() {
        this.totalEjectionsNeeded = 0;
        this.markDirty();
    }

    public void setItemsToEject(List<ItemStack> itemsToEject) {
        this.itemsToEject.clear();
        this.itemsToEject.addAll(itemsToEject);
        this.totalEjectionsNeeded = this.itemsToEject.size();
        this.markDirty();
    }

    public ItemStack getItemToDisplay() {
        return this.itemsToEject.isEmpty() ? ItemStack.f_41583_ : Objects.requireNonNullElse(this.itemsToEject.get(this.itemsToEject.size() - 1), ItemStack.f_41583_);
    }

    public ItemStack getItemToEject() {
        if (this.itemsToEject.isEmpty()) {
            return ItemStack.f_41583_;
        }
        this.markDirty();
        return Objects.requireNonNullElse(this.itemsToEject.remove(this.itemsToEject.size() - 1), ItemStack.f_41583_);
    }

    public void copyFrom(VoidVaultServerData data) {
        this.stateUpdatingResumesAt = data.getStateUpdatingResumeTime();
        this.itemsToEject.clear();
        this.itemsToEject.addAll(data.itemsToEject);
        this.rewardedPlayers.clear();
        this.rewardedPlayers.addAll(data.rewardedPlayers);
    }

    private void markDirty() {
        this.dirty = true;
    }

    public float getEjectSoundPitchModifier() {
        return this.totalEjectionsNeeded == 1 ? 1.0f : 1.0f - MathHelper.getLerpProgress(this.getItemsToEject().size(), 1.0f, this.totalEjectionsNeeded);
    }
}

