/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities.void_vault;

import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultConfig;
import com.Polarice3.Goety.common.blocks.entities.void_vault.VoidVaultServerData;
import com.Polarice3.Goety.utils.ModUUIDUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class VoidVaultSharedData {
    static final String SHARED_DATA_KEY = "shared_data";
    public static Codec<VoidVaultSharedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VoidVaultConfig.createOptionalCodec("display_item").forGetter(data -> data.displayItem), (App)ModUUIDUtil.CODEC_LINKED_SET.optionalFieldOf("connected_players", Set.of()).forGetter(data -> data.connectedPlayers), (App)Codec.DOUBLE.optionalFieldOf("connected_particles_range", (Object)VoidVaultConfig.DEFAULT.deactivationRange()).forGetter(data -> data.connectedParticlesRange)).apply((Applicative)instance, VoidVaultSharedData::new));
    private ItemStack displayItem = ItemStack.f_41583_;
    private Set<UUID> connectedPlayers = new ObjectLinkedOpenHashSet();
    private double connectedParticlesRange = VoidVaultConfig.DEFAULT.deactivationRange();
    public boolean dirty;

    VoidVaultSharedData(ItemStack displayItem, Set<UUID> connectedPlayers, double connectedParticlesRange) {
        this.displayItem = displayItem;
        this.connectedPlayers.addAll(connectedPlayers);
        this.connectedParticlesRange = connectedParticlesRange;
    }

    public VoidVaultSharedData() {
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public boolean hasDisplayItem() {
        return !this.displayItem.m_41619_();
    }

    public void setDisplayItem(ItemStack stack) {
        if (!ItemStack.m_41656_((ItemStack)this.displayItem, (ItemStack)stack)) {
            this.displayItem = stack.m_41777_();
            this.markDirty();
        }
    }

    public boolean hasConnectedPlayers() {
        return !this.connectedPlayers.isEmpty();
    }

    public Set<UUID> getConnectedPlayers() {
        return this.connectedPlayers;
    }

    public double getConnectedParticlesRange() {
        return this.connectedParticlesRange;
    }

    public void updateConnectedPlayers(ServerLevel world, BlockPos pos, VoidVaultServerData serverData, VoidVaultConfig config, double radius) {
        Set set = config.playerDetector().detect(world, config.entitySelector(), pos, radius, false).stream().filter(uuid -> !serverData.getRewardedPlayers().contains(uuid)).collect(Collectors.toSet());
        if (!this.connectedPlayers.equals(set)) {
            this.connectedPlayers = set;
            this.markDirty();
        }
    }

    private void markDirty() {
        this.dirty = true;
    }

    public void copyFrom(VoidVaultSharedData data) {
        this.displayItem = data.displayItem;
        this.connectedPlayers = data.connectedPlayers;
        this.connectedParticlesRange = data.connectedParticlesRange;
    }
}

