/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.capabilities.soulenergy;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.capabilities.soulenergy.SEProvider;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SEUpdatePacket {
    private final UUID PlayerUUID;
    private CompoundTag tag;

    public SEUpdatePacket(UUID uuid, CompoundTag tag) {
        this.PlayerUUID = uuid;
        this.tag = tag;
    }

    public SEUpdatePacket(Player player) {
        this.PlayerUUID = player.m_20148_();
        player.getCapability(SEProvider.CAPABILITY, null).ifPresent(soulEnergy -> {
            this.tag = SEHelper.save(new CompoundTag(), soulEnergy);
        });
    }

    public static void encode(SEUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.PlayerUUID);
        buffer.m_130079_(packet.tag);
    }

    public static SEUpdatePacket decode(FriendlyByteBuf buffer) {
        return new SEUpdatePacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void consume(SEUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (player = Goety.PROXY.getPlayer()) != null) {
                player.getCapability(SEProvider.CAPABILITY).ifPresent(soulEnergy -> SEHelper.load(packet.tag, soulEnergy));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

