/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.commands;

import com.Polarice3.Goety.common.capabilities.lichdom.ILichdom;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public class LichCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_LICH = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.lich.turnlich.failed"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_NOT_LICH = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.lich.delich.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lichdom").requires(p_198442_0_ -> p_198442_0_.m_6761_(2))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198445_0_ -> LichCommand.grantLichdom((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets")))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(p_198445_0_ -> LichCommand.revokeLichdom((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets")))))).then(Commands.m_82127_((String)"query").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_198435_0_ -> LichCommand.queryLich((CommandSourceStack)p_198435_0_.getSource(), EntityArgument.m_91474_((CommandContext)p_198435_0_, (String)"targets"))))));
    }

    private static int grantLichdom(CommandSourceStack pSource, Collection<ServerPlayer> targets) throws CommandSyntaxException {
        for (ServerPlayer player : targets) {
            ILichdom lichdom = LichdomHelper.getCapability((Player)player);
            boolean isLich = lichdom.getLichdom();
            if (!isLich) {
                lichdom.setLichdom(true);
                lichdom.setNightVision(true);
                LichdomHelper.sendLichUpdatePacket((Player)player);
                pSource.m_288197_(() -> Component.m_237110_((String)"commands.lich.turnlich.success", (Object[])new Object[]{player.m_5446_()}), false);
                continue;
            }
            throw ERROR_ALREADY_LICH.create();
        }
        return 0;
    }

    private static int revokeLichdom(CommandSourceStack pSource, Collection<ServerPlayer> targets) throws CommandSyntaxException {
        for (ServerPlayer player : targets) {
            ILichdom lichdom = LichdomHelper.getCapability((Player)player);
            boolean isLich = lichdom.getLichdom();
            if (isLich) {
                lichdom.setLichdom(false);
                lichdom.setNightVision(false);
                if (player.m_21023_(MobEffects.f_19611_)) {
                    player.m_21195_(MobEffects.f_19611_);
                }
                LichdomHelper.sendLichUpdatePacket((Player)player);
                pSource.m_288197_(() -> Component.m_237110_((String)"commands.lich.delich.success", (Object[])new Object[]{player.m_5446_()}), false);
                continue;
            }
            throw ERROR_ALREADY_NOT_LICH.create();
        }
        return 0;
    }

    private static int queryLich(CommandSourceStack pSource, ServerPlayer pPlayer) {
        ILichdom lichdom = LichdomHelper.getCapability((Player)pPlayer);
        boolean isLich = lichdom.getLichdom();
        if (isLich) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.lich.query.true", (Object[])new Object[]{pPlayer.m_5446_()}), false);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.lich.query.false", (Object[])new Object[]{pPlayer.m_5446_()}), false);
        }
        return 0;
    }
}

