/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.spider;

import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.mixin.MobAccessor;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;

public abstract class AbstractSpiderServant
extends Spider
implements PlayerRideable,
IServant,
OwnableEntity,
ICustomAttributes {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(AbstractSpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(AbstractSpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> HOSTILE = SynchedEntityData.m_135353_(AbstractSpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> NATURAL = SynchedEntityData.m_135353_(AbstractSpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> SUMMONED_FLAGS = SynchedEntityData.m_135353_(AbstractSpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> UPGRADE_FLAGS = SynchedEntityData.m_135353_(AbstractSpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final NearestAttackableTargetGoal<Player> targetGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    public boolean limitedLifespan;
    public int limitedLifeTicks;
    @Nullable
    private LivingEntity priorityTarget;
    public LivingEntity commandPosEntity;
    public BlockPos commandPos;
    public BlockPos boundPos;
    public String boundDim = Level.f_46428_.m_135782_().toString();
    public int commandTick;
    public int killChance;
    public int noHealTime;
    public long ticketTime = 0L;

    public AbstractSpiderServant(EntityType<? extends Spider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.checkHostility();
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, new Owned.OwnerHurtByTargetGoal<AbstractSpiderServant>(this));
        this.f_21346_.m_25352_(2, new Owned.OwnerHurtTargetGoal<AbstractSpiderServant>(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.followGoal();
        this.targetSelectGoal();
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, new Summoned.FollowOwnerGoal<AbstractSpiderServant>(this, 1.0, 10.0f, 2.0f));
    }

    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this));
    }

    @Override
    public void setConfigurableAttributes() {
    }

    public void m_6043_() {
        if (this.isHostile()) {
            super.m_6043_();
        }
    }

    public boolean m_20177_(Player p_20178_) {
        if (p_20178_ == this.getMasterOwner()) {
            return false;
        }
        return super.m_20177_(p_20178_);
    }

    @Override
    public void checkHostility() {
        if (!this.f_19853_.f_46443_) {
            IOwned owned;
            LivingEntity livingEntity;
            if (this.getTrueOwner() instanceof Enemy) {
                this.setHostile(true);
            }
            if ((livingEntity = this.getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).isHostile()) {
                this.setHostile(true);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.ownedTick();
        this.servantTick();
    }

    @Override
    public long getTicketTime() {
        return this.ticketTime;
    }

    @Override
    public void setTicketTime(long ticketTime) {
        this.ticketTime = ticketTime;
    }

    @Override
    public long decreaseTicketTime() {
        return --this.ticketTime;
    }

    @Override
    public boolean burnSunTick() {
        return this.m_21527_();
    }

    protected void m_7562_() {
        float f;
        if (this.isHostile() && (f = this.m_213856_()) > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.getTrueOwner() != null) {
            boolean flag;
            int i;
            float f = (float)this.m_21133_(Attributes.f_22281_);
            float f1 = (float)this.m_21133_(Attributes.f_22282_);
            if (entity instanceof LivingEntity) {
                f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
                f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
            }
            if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                entity.m_20254_(i * 4);
            }
            if (flag = entity.m_6469_(ModDamageSource.summonAttack((LivingEntity)this, this.getTrueOwner()), f)) {
                if (f1 > 0.0f && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
                this.m_19970_((LivingEntity)this, entity);
                this.m_21335_(entity);
            }
            return flag;
        }
        return super.m_7327_(entity);
    }

    public void m_21424_(Player player, ItemStack axe, ItemStack shield) {
        if (!axe.m_41619_() && !shield.m_41619_() && axe.m_41720_() instanceof AxeItem && shield.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)player, (byte)30);
            }
        }
    }

    @Nullable
    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.getTrueOwner() != null && (livingentity = this.getTrueOwner()) != null && livingentity != this && !this.areOwnedByEachOther(livingentity) && livingentity.m_5647_() != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean areOwnedByEachOther(LivingEntity livingEntity) {
        if (livingEntity instanceof IOwned) {
            IOwned owned = (IOwned)livingEntity;
            return owned.getTrueOwner() == this && this.getTrueOwner() == livingEntity;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7307_(Entity entityIn) {
        if (this.getTrueOwner() == null) return super.m_7307_(entityIn);
        LivingEntity trueOwner = this.getTrueOwner();
        if (trueOwner.m_7307_(entityIn)) return true;
        if (entityIn.m_7307_((Entity)trueOwner)) return true;
        if (entityIn == trueOwner) return true;
        if (entityIn instanceof IOwned) {
            IOwned owned = (IOwned)entityIn;
            if (MobUtil.ownerStack(this, owned)) return true;
        }
        if (entityIn instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entityIn;
            if (ownable.m_269323_() == trueOwner) return true;
        }
        if (!(trueOwner instanceof Player)) return false;
        Player player = (Player)trueOwner;
        if (!(entityIn instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entityIn;
        if (SEHelper.getAllyEntities(player).contains(livingEntity)) return true;
        if (!SEHelper.getAllyEntityTypes(player).contains(livingEntity.m_6095_())) return false;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(HOSTILE, (Object)false);
        this.f_19804_.m_135372_(NATURAL, (Object)false);
        this.f_19804_.m_135372_(SUMMONED_FLAGS, (Object)0);
        this.f_19804_.m_135372_(UPGRADE_FLAGS, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readOwnedData(compound);
        this.readServantData(compound);
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.saveOwnedData(compound);
        this.saveServantData(compound);
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(SUMMONED_FLAGS);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(SUMMONED_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(SUMMONED_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    @Override
    public boolean isWandering() {
        return this.getFlag(1);
    }

    @Override
    public void setWandering(boolean wandering) {
        this.setFlags(1, wandering);
    }

    @Override
    public boolean isStaying() {
        return this.getFlag(2) && !this.isCommanded() && !this.m_20160_();
    }

    @Override
    public void setStaying(boolean staying) {
        this.setFlags(2, staying);
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    @Override
    public boolean isUpgraded() {
        return ((Byte)this.f_19804_.m_135370_(UPGRADE_FLAGS) & 4) != 0;
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        byte b0 = (Byte)this.f_19804_.m_135370_(UPGRADE_FLAGS);
        if (upgraded) {
            this.f_19804_.m_135381_(UPGRADE_FLAGS, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(UPGRADE_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public void upgrade() {
        this.setUpgraded(true);
    }

    public void downgrade() {
        this.setUpgraded(false);
    }

    @Override
    public void setCommandPos(BlockPos blockPos, boolean removeEntity) {
        if (removeEntity) {
            this.commandPosEntity = null;
        }
        this.commandPos = blockPos;
        this.setCommandTick(MathHelper.secondsToTicks(10));
    }

    @Override
    public BlockPos getCommandPos() {
        return this.commandPos;
    }

    @Override
    public void setCommandPosEntity(@Nullable LivingEntity living) {
        this.commandPosEntity = living;
        if (living != null) {
            this.setCommandPos(living.m_20183_(), false);
        }
    }

    @Override
    @Nullable
    public LivingEntity getCommandPosEntity() {
        return this.commandPosEntity;
    }

    @Override
    public int getCommandTick() {
        return this.commandTick;
    }

    @Override
    public void setCommandTick(int commandTick) {
        this.commandTick = commandTick;
    }

    @Override
    public boolean isCommanded() {
        return this.commandPos != null;
    }

    @Override
    public BlockPos getBoundPos() {
        return this.boundPos;
    }

    @Override
    public void setBoundPos(BlockPos blockPos) {
        this.boundPos = blockPos;
        this.setBoundDim(this.f_19853_.m_46472_());
    }

    @Override
    public Vec3 vec3BoundPos() {
        return Vec3.m_82539_((Vec3i)this.boundPos);
    }

    @Override
    public String getBoundDim() {
        return this.boundDim;
    }

    @Override
    public void setBoundDim(String string) {
        this.boundDim = string;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.isGuardingArea()) {
            if (target != null) {
                if (target.m_20238_(this.vec3BoundPos()) <= (double)Mth.m_144944_((int)GUARDING_RANGE)) {
                    this.overrideSetTarget(target);
                }
            } else {
                this.overrideSetTarget(null);
            }
        } else {
            this.overrideSetTarget(target);
        }
    }

    @Override
    public void overrideSetTarget(@Nullable LivingEntity target) {
        super.m_6710_(target);
    }

    @Override
    @Nullable
    public LivingEntity getPriorityTarget() {
        return this.priorityTarget;
    }

    @Override
    public void setPriorityTarget(@Nullable LivingEntity priorityTarget) {
        this.overrideSetTarget(priorityTarget);
        this.priorityTarget = priorityTarget;
    }

    @Deprecated
    public void normalSetTarget(@Nullable LivingEntity target) {
        this.overrideSetTarget(target);
    }

    public void dropEquipment(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.m_21519_(equipmentSlot) > 0.0f) {
            this.m_19983_(stack);
        }
    }

    public boolean isMoving() {
        return !(this.f_267362_.m_267731_() < 0.01f);
    }

    @Override
    public int getNoHealTime() {
        return this.noHealTime;
    }

    @Override
    public void setNoHealTime(int time) {
        this.noHealTime = time;
    }

    @Override
    public int getKillChance() {
        return this.killChance;
    }

    @Override
    public void setKillChance(int killChance) {
        this.killChance = killChance;
    }

    public void warnKill(Player player) {
        this.killChance = 60;
        player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.tryKill", (Object[])new Object[]{this.m_5446_()}), true);
    }

    @Override
    public void tryKill(Player player) {
        this.m_6074_();
    }

    @Override
    public void setHasLifespan(boolean lifespan) {
        this.limitedLifespan = lifespan;
    }

    @Override
    public boolean hasLifespan() {
        return this.limitedLifespan;
    }

    @Override
    public void setLifespan(int lifespan) {
        this.limitedLifeTicks = lifespan;
    }

    @Override
    public int getLifespan() {
        return this.limitedLifeTicks;
    }

    @Override
    public void convertNewEquipment(Entity entity) {
        this.m_213945_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
    }

    @Override
    @Nullable
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        return this.m_6095_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomsource = pLevel.m_213780_();
        AttributeInstance instance = this.m_21051_(Attributes.f_22277_);
        if (instance != null) {
            instance.m_22125_(new AttributeModifier("Random spawn bonus", randomsource.m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        }
        this.m_21559_(randomsource.m_188501_() < 0.05f);
        MobAccessor mobAccessor = (MobAccessor)((Object)this);
        mobAccessor.setSpawnType(pReason);
        this.checkHostility();
        if (pReason != MobSpawnType.MOB_SUMMONED && this.getTrueOwner() == null) {
            this.setNatural(true);
        }
        this.setWandering(this.getTrueOwner() == null);
        this.setStaying(false);
        return pSpawnData;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Summoned summoned;
        Entity entity;
        if (((Boolean)MobsConfig.ServantsMasterImmune.get()).booleanValue() && (entity = source.m_7639_()) instanceof Summoned && !(summoned = (Summoned)entity).isHostile() && !this.isHostile() && this.getTrueOwner() != null && summoned.getTrueOwner() == this.getTrueOwner()) {
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (flag) {
            this.noHealTime = MathHelper.secondsToTicks((Integer)MobsConfig.ServantHealHalt.get());
        }
        return flag;
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.f_19853_.f_46443_ && this.m_8077_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getTrueOwner() instanceof ServerPlayer) {
            this.getTrueOwner().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(pCause);
    }

    @Override
    @Nullable
    public LivingEntity getTrueOwner() {
        LivingEntity living;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        int id = this.getOwnerClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getOwnerClientId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    @Override
    @Nullable
    public LivingEntity getMasterOwner() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof IOwned) {
            IOwned owned = (IOwned)livingEntity;
            return owned.getTrueOwner();
        }
        return this.getTrueOwner();
    }

    @Nullable
    public UUID m_21805_() {
        return this.getOwnerId();
    }

    @Nullable
    public LivingEntity m_269323_() {
        return this.getTrueOwner();
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    @Override
    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    @Override
    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    @Override
    public void setHostile(boolean hostile) {
        this.f_19804_.m_135381_(HOSTILE, (Object)hostile);
        this.addTargetGoal();
    }

    public void addTargetGoal() {
        this.f_21346_.m_25352_(2, this.targetGoal);
    }

    @Override
    public boolean isHostile() {
        return (Boolean)this.f_19804_.m_135370_(HOSTILE);
    }

    @Override
    public void setNatural(boolean natural) {
        this.f_19804_.m_135381_(NATURAL, (Object)natural);
    }

    @Override
    public boolean isNatural() {
        return (Boolean)this.f_19804_.m_135370_(NATURAL);
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_() != GoetyEffects.GOLD_TOUCHED.get() && super.m_7301_(pPotioneffect);
    }

    public int m_213860_() {
        if (this.isHostile()) {
            this.f_21364_ = this.xpReward();
            return super.m_213860_();
        }
        return 0;
    }

    public int xpReward() {
        return 5;
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.f_19853_.f_46443_ && p_21294_ != this.getTrueOwner()) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        if (!this.f_19853_.f_46443_ && p_20971_ != this.getTrueOwner()) {
            super.m_7324_(p_20971_);
        }
    }

    public boolean m_7337_(Entity p_20303_) {
        if (p_20303_ != this.getTrueOwner()) {
            return super.m_7337_(p_20303_);
        }
        return false;
    }

    public boolean m_6935_(Player p_33036_) {
        return this.isHostile();
    }

    protected boolean m_8028_() {
        return this.isHostile();
    }

    public boolean m_6785_(double p_27519_) {
        return this.isHostile();
    }

    public boolean isFood(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        return item.m_41472_() && p_30440_.getFoodProperties((LivingEntity)this).m_38746_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        FoodProperties foodProperties;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && this.isFood(itemstack) && this.m_21223_() < this.m_21233_() && (foodProperties = itemstack.getFoodProperties((LivingEntity)this)) != null) {
            this.m_5634_(foodProperties.m_38744_());
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            this.m_5584_(this.f_19853_, itemstack);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            pPlayer.m_6674_(pHand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }
}

