/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.skeleton;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.neutral.DrownedNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class SkeletonWolf
extends AnimalSummon {
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(SkeletonWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(SkeletonWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HOWLING = SynchedEntityData.m_135353_(SkeletonWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private int howlingCool;
    public boolean isSitting;
    public AnimationState howlAnimationState = new AnimationState();

    public SkeletonWolf(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new HowlGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f){

            public boolean m_8036_() {
                return super.m_8036_() && !SkeletonWolf.this.isHowling() && !SkeletonWolf.this.isStaying();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !SkeletonWolf.this.isHowling() && !SkeletonWolf.this.isStaying();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<SkeletonWolf>(this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(6, new Summoned.NaturalAttackGoal<Turtle>(this, Turtle.class, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SkeletonWolfHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.SkeletonWolfArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SkeletonWolfDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SkeletonWolfHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.SkeletonWolfArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SkeletonWolfDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_HOWLING, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("HowlingCool")) {
            this.howlingCool = compound.m_128451_("HowlingCool");
        }
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
        if (compound.m_128441_("Sitting")) {
            this.isSitting = compound.m_128471_("Sitting");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("HowlingCool", this.howlingCool);
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        compound.m_128379_("Sitting", this.isSitting);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void setIsInterested(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)p_30445_);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    public void setIsHowling(boolean p_30445_) {
        this.f_19804_.m_135381_(DATA_HOWLING, (Object)p_30445_);
    }

    public boolean isHowling() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOWLING);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    protected void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_((SoundEvent)ModSounds.SKELETON_WOLF_STEP.get(), 0.15f, 1.0f);
    }

    public void m_8032_() {
        if (!this.isHowling()) {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7515_() {
        if (this.m_5912_()) {
            return (SoundEvent)ModSounds.SKELETON_WOLF_GROWL.get();
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.getTrueOwner() != null && this.m_21223_() < this.m_21233_() / 2.0f ? (SoundEvent)ModSounds.SKELETON_WOLF_WHINE.get() : (SoundEvent)ModSounds.SKELETON_WOLF_PANT.get();
        }
        return (SoundEvent)ModSounds.SKELETON_WOLF_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_30424_) {
        return (SoundEvent)ModSounds.SKELETON_WOLF_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKELETON_WOLF_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public boolean m_6162_() {
        return false;
    }

    @Override
    public void m_6863_(boolean p_146756_) {
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && !this.isHowling() && this.isWet && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.m_20071_()) {
                this.isWet = true;
                if (this.isShaking && !this.f_19853_.f_46443_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_((SoundEvent)ModSounds.SKELETON_WOLF_SHAKE.get(), this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_223710_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
            if (!this.f_19853_.f_46443_) {
                if (this.howlingCool > 0) {
                    --this.howlingCool;
                }
                if (this.isStaying()) {
                    this.isSitting = true;
                    this.f_19853_.m_7605_((Entity)this, (byte)9);
                } else {
                    this.isSitting = false;
                    this.f_19853_.m_7605_((Entity)this, (byte)10);
                }
                if (this.m_5448_() != null) {
                    this.m_21561_(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                } else {
                    this.m_21561_(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void m_6667_(DamageSource p_30384_) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.m_6667_(p_30384_);
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float p_30447_) {
        return Math.min(0.5f + Mth.m_14179_((float)p_30447_, (float)this.shakeAnimO, (float)this.shakeAnim) / 2.0f * 0.5f, 1.0f);
    }

    public float getBodyRollAngle(float p_30433_, float p_30434_) {
        float f = (Mth.m_14179_((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim) + p_30434_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float p_30449_) {
        return Mth.m_14179_((float)p_30449_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    protected float m_6431_(Pose p_30409_, EntityDimensions p_30410_) {
        return p_30410_.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.isStaying() ? 20 : super.m_8132_();
    }

    @Override
    public void m_7822_(byte p_30379_) {
        if (p_30379_ == 4) {
            this.howlAnimationState.m_216982_(this.f_19797_);
        } else if (p_30379_ == 5) {
            this.howlAnimationState.m_216973_();
        } else if (p_30379_ == 6) {
            this.m_21561_(true);
        } else if (p_30379_ == 7) {
            this.m_21561_(false);
        } else if (p_30379_ == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (p_30379_ == 9) {
            this.isSitting = true;
        } else if (p_30379_ == 10) {
            this.isSitting = false;
        } else if (p_30379_ == 56) {
            this.cancelShake();
        } else {
            super.m_7822_(p_30379_);
        }
    }

    public float getTailAngle() {
        return (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI;
    }

    @Override
    public boolean isFood(ItemStack p_30440_) {
        return p_30440_.m_204117_(Tags.Items.BONES);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (this.isFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(1.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                this.m_5584_(this.f_19853_, itemstack);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(pHand);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeColor dyecolor;
                DyeItem dyeitem = (DyeItem)item;
                if (this.getTrueOwner() == pPlayer && (dyecolor = dyeitem.m_41089_()) != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static class HowlGoal
    extends Goal {
        private final SkeletonWolf wolf;
        private int howlTime;

        public HowlGoal(SkeletonWolf p_25063_) {
            this.wolf = p_25063_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.wolf.m_5448_() != null && this.wolf.m_5448_().m_6084_() && this.wolf.howlingCool <= 0 && this.wolf.m_217043_().m_188499_();
        }

        public boolean m_8045_() {
            return this.howlTime > 0;
        }

        public void m_8056_() {
            this.wolf.setIsHowling(true);
            this.wolf.m_21573_().m_26573_();
            this.wolf.m_21566_().m_24988_(0.0f, 0.0f);
            this.howlTime = MathHelper.secondsToTicks(3.25f);
            this.wolf.m_5496_((SoundEvent)ModSounds.SKELETON_WOLF_HOWL.get(), 1.0f, 1.0f);
            this.wolf.f_19853_.m_7605_((Entity)this.wolf, (byte)4);
        }

        public void m_8041_() {
            this.wolf.setIsHowling(false);
            this.wolf.f_19853_.m_7605_((Entity)this.wolf, (byte)5);
            this.wolf.howlingCool = 100;
        }

        public void m_8037_() {
            --this.howlTime;
            this.wolf.m_21573_().m_26573_();
            this.wolf.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.howlTime == MathHelper.secondsToTicks(3)) {
                for (LivingEntity livingEntity : this.wolf.f_19853_.m_45976_(LivingEntity.class, this.wolf.m_20191_().m_82400_(8.0))) {
                    if (livingEntity == this.wolf) continue;
                    boolean flag = false;
                    if (this.wolf.isHostile() && livingEntity instanceof AbstractSkeleton) {
                        flag = true;
                    }
                    if ((livingEntity instanceof AbstractSkeletonServant || livingEntity instanceof SkeletonWolf || livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.SKELETON_WOLF_BUFF)) && !(livingEntity instanceof DrownedNecromancer) && MobUtil.areAllies((Entity)this.wolf, (Entity)livingEntity)) {
                        flag = true;
                    }
                    if (!flag) continue;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, MathHelper.secondsToTicks(5)));
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class BegGoal
    extends Goal {
        private final SkeletonWolf wolf;
        private final float lookDistance;
        private int lookTime;

        public BegGoal(SkeletonWolf p_25063_, float p_25064_) {
            this.wolf = p_25063_;
            this.lookDistance = p_25064_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.wolf.getTrueOwner() != null && this.playerHoldingInteresting(this.wolf.getTrueOwner());
        }

        public boolean m_8045_() {
            if (this.wolf.getTrueOwner() == null || !this.wolf.getTrueOwner().m_6084_()) {
                return false;
            }
            if (this.wolf.m_20280_((Entity)this.wolf.getTrueOwner()) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0 && this.playerHoldingInteresting(this.wolf.getTrueOwner());
        }

        public void m_8056_() {
            this.wolf.setIsInterested(true);
            this.lookTime = this.m_183277_(40 + this.wolf.m_217043_().m_188503_(40));
        }

        public void m_8041_() {
            this.wolf.setIsInterested(false);
        }

        public void m_8037_() {
            this.wolf.m_21563_().m_24950_(this.wolf.getTrueOwner().m_20185_(), this.wolf.getTrueOwner().m_20188_(), this.wolf.getTrueOwner().m_20189_(), 10.0f, (float)this.wolf.m_8132_());
            --this.lookTime;
        }

        private boolean playerHoldingInteresting(LivingEntity p_25067_) {
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack = p_25067_.m_21120_(interactionhand);
                if (!this.wolf.isFood(itemstack)) continue;
                return true;
            }
            return false;
        }
    }
}

