/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ally.spider.SpiderServant;
import com.Polarice3.Goety.common.entities.projectiles.WebShot;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WebSpider
extends Spider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> WEB_SHOOTING = SynchedEntityData.m_135353_(WebSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(WebSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static AttributeModifier SHOOT_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("b255663a-e3e3-4660-9ce2-1c76c5f98e72"), "Shooting speed penalty", -1.0, AttributeModifier.Operation.ADDITION);
    public static String IDLE = "idle";
    public static String SHOOT = "shoot";
    public boolean isFleeing;
    public boolean stopMoving;
    public int shootAnim;
    public AnimationState shootAnimationState = new AnimationState();

    public WebSpider(EntityType<? extends Spider> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new WebShootGoal<WebSpider>(this, 0.75, 60, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f){

            public boolean m_8036_() {
                return super.m_8036_() && !WebSpider.this.isWebShooting() && WebSpider.this.m_5448_() != null && WebSpider.this.m_5448_().m_21023_((MobEffect)GoetyEffects.TANGLED.get());
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SpiderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new SpiderTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new SpiderTargetGoal<IronGolem>(this, IronGolem.class));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return SpiderServant.setCustomAttributes().m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WebSpiderServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WebSpiderServantHealth.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WebSpiderServantDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.WebSpiderServantHealth.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WEB_SHOOTING, (Object)false);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, SHOOT)) {
            return 1;
        }
        return 0;
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.shootAnimationState.m_216973_();
                    break;
                }
                case 1: {
                    this.shootAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
    }

    public void setWebShooting(boolean webShooting) {
        this.f_19804_.m_135381_(WEB_SHOOTING, (Object)webShooting);
    }

    public boolean isWebShooting() {
        return (Boolean)this.f_19804_.m_135370_(WEB_SHOOTING);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null) {
                if (!this.isWebShooting()) {
                    this.stopMoving = false;
                    if (!this.m_5448_().m_21023_((MobEffect)GoetyEffects.TANGLED.get())) {
                        if (this.m_20270_((Entity)this.m_5448_()) <= 5.0f) {
                            this.isFleeing = true;
                            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this, (int)7, (int)5, (Vec3)this.m_5448_().m_20182_());
                            if (vec3 != null) {
                                this.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.25);
                            }
                        } else {
                            this.isFleeing = false;
                        }
                    } else {
                        this.isFleeing = false;
                        this.m_33819_(false);
                    }
                } else {
                    this.isFleeing = false;
                }
            } else {
                this.isFleeing = false;
                this.stopMoving = false;
            }
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            if (this.stopMoving) {
                if (modifiableattributeinstance != null) {
                    modifiableattributeinstance.m_22130_(SHOOT_SPEED_MODIFIER);
                    modifiableattributeinstance.m_22118_(SHOOT_SPEED_MODIFIER);
                }
            } else if (modifiableattributeinstance != null && modifiableattributeinstance.m_22109_(SHOOT_SPEED_MODIFIER)) {
                modifiableattributeinstance.m_22130_(SHOOT_SPEED_MODIFIER);
            }
            if (this.shootAnim > 0) {
                --this.shootAnim;
            } else {
                this.setAnimationState(IDLE);
            }
        }
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        WebShot snowball = new WebShot((LivingEntity)this, this.f_19853_);
        Vec3 vec3 = p_33317_.m_20184_();
        double d0 = p_33317_.m_20185_() + vec3.f_82479_ - this.m_20185_();
        double d1 = p_33317_.m_20188_() - (double)1.1f - this.m_20186_();
        double d2 = p_33317_.m_20189_() + vec3.f_82481_ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        snowball.m_146926_(snowball.m_146909_() - -20.0f);
        snowball.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        this.m_5496_((SoundEvent)ModSounds.SPIDER_SPIT.get(), 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)snowball);
    }

    public static class WebShootGoal<T extends WebSpider>
    extends Goal {
        private final T mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private final int attackInterval;
        private final float attackRadius;

        public WebShootGoal(T mob, double speed, int attackInterval, float attackRadius) {
            this.mob = mob;
            this.speedModifier = speed;
            this.attackInterval = attackInterval;
            this.attackRadius = attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && !((WebSpider)((Object)this.mob)).isFleeing) {
                this.target = livingentity;
                return !livingentity.m_21023_((MobEffect)GoetyEffects.TANGLED.get()) && this.mob.m_20270_((Entity)livingentity) > 4.0f;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21573_().m_26573_();
            ((WebSpider)((Object)this.mob)).setWebShooting(true);
        }

        public void m_8041_() {
            this.target = null;
            this.attackTime = -1;
            ((WebSpider)((Object)this.mob)).stopMoving = false;
            ((WebSpider)((Object)this.mob)).setWebShooting(false);
            ((WebSpider)((Object)this.mob)).setAnimationState(IDLE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
                if (this.mob.m_20270_((Entity)this.target) <= this.attackRadius) {
                    this.mob.m_21573_().m_26573_();
                    if (!((WebSpider)((Object)this.mob)).stopMoving) {
                        this.mob.m_5496_((SoundEvent)ModSounds.SPIDER_CALL.get(), ((WebSpider)this.mob).m_6121_(), this.mob.m_6100_());
                    }
                    ((WebSpider)((Object)this.mob)).stopMoving = true;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                    ((WebSpider)((Object)this.mob)).stopMoving = false;
                }
                MobUtil.instaLook(this.mob, (Entity)this.target);
                --this.attackTime;
                if (this.attackTime == this.attackInterval - MathHelper.secondsToTicks(0.75f)) {
                    if (!flag) {
                        return;
                    }
                    ((WebSpider)((Object)this.mob)).setAnimationState(SHOOT);
                    ((WebSpider)((Object)this.mob)).shootAnim = MathHelper.secondsToTicks(0.56f) + 5;
                } else if (this.attackTime == this.attackInterval - MathHelper.secondsToTicks(1.11f)) {
                    float f = (float)Math.sqrt(d0) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    ((WebSpider)((Object)this.mob)).m_6504_(this.target, f1);
                } else if (this.attackTime <= 0) {
                    this.attackTime = this.attackInterval;
                }
            }
        }
    }

    static class SpiderAttackGoal
    extends MeleeAttackGoal {
        public WebSpider webSpider;

        public SpiderAttackGoal(WebSpider p_33822_) {
            super((PathfinderMob)p_33822_, 1.5, true);
            this.webSpider = p_33822_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_() && !this.webSpider.isWebShooting() && this.f_25540_.m_5448_() != null && this.f_25540_.m_5448_().m_21023_((MobEffect)GoetyEffects.TANGLED.get());
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 4.0f + p_33825_.m_20205_();
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(Spider p_33832_, Class<T> p_33833_) {
            super((Mob)p_33832_, p_33833_, true);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f >= 0.5f ? false : super.m_8036_();
        }
    }
}

