/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.hostile.illagers.Trampler;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Piker
extends HuntingIllagerEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Piker.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int attackTick;
    public boolean aggressiveMode;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public Piker(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new PikerAttackGoal());
    }

    @Override
    public void extraGoals() {
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.PikerHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.PikerDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.PikerArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.PikerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.PikerDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.PikerArmor.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_271165_;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            if (!this.isMeleeAttacking()) {
                this.attackAnimationState.m_216973_();
                if (!this.isMoving()) {
                    this.walkAnimationState.m_216973_();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                } else {
                    this.idleAnimationState.m_216973_();
                    this.walkAnimationState.m_216982_(this.f_19797_);
                }
            } else {
                this.idleAnimationState.m_216973_();
                this.walkAnimationState.m_216973_();
            }
        }
        if (this.isMeleeAttacking()) {
            ++this.attackTick;
        }
        if (this.attackTick > 20) {
            this.setMeleeAttacking(false);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null) {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            }
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setFlag(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PIKER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PIKER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.PIKER_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.PIKER_STEP.get(), 1.0f, 1.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData spawnGroupData = super.m_6518_(accessor, instance, spawnType, groupData, compoundTag);
        if (spawnType == MobSpawnType.EVENT && accessor.m_6018_().f_46441_.m_188501_() <= 0.25f && !this.m_20159_()) {
            Trampler trampler = new Trampler((EntityType<? extends Raider>)((EntityType)ModEntityType.TRAMPLER.get()), (Level)accessor.m_6018_());
            trampler.m_6518_(accessor, accessor.m_6018_().m_6436_(this.m_20183_()), MobSpawnType.EVENT, null, null);
            trampler.m_146884_(this.m_20182_());
            accessor.m_6018_().m_7967_((Entity)trampler);
            this.m_20329_((Entity)trampler);
        }
        return spawnGroupData;
    }

    public boolean m_7327_(Entity p_21372_) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (p_21372_ instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)p_21372_).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            p_21372_.m_20254_(i * 4);
        }
        if (flag = p_21372_.m_6469_(p_21372_.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && p_21372_ instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)p_21372_;
                living.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            }
            this.m_19970_((LivingEntity)this, p_21372_);
            this.m_21335_(p_21372_);
        }
        return flag;
    }

    protected double getAttackReachSqr(LivingEntity enemy) {
        if (this.m_20202_() instanceof Ravager) {
            float f = this.m_20202_().m_20205_() - 0.1f;
            return f * 2.0f * f * 2.0f + enemy.m_20205_();
        }
        return this.m_20205_() * 5.0f * this.m_20205_() * 5.0f + enemy.m_20205_();
    }

    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        return (distToEnemySqr <= this.getAttackReachSqr(enemy) || this.m_20191_().m_82381_(enemy.m_20191_())) && this.m_142582_((Entity)enemy);
    }

    public boolean m_21531_() {
        return false;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.stopAllAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.aggressiveMode = true;
        } else if (p_21375_ == 7) {
            this.aggressiveMode = false;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.PIKER_CELEBRATE.get();
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Piker.this.m_5448_() != null && Piker.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return Piker.this.attackTick < 20;
        }

        public void m_8056_() {
            Piker.this.setMeleeAttacking(true);
            Piker.this.f_19853_.m_7605_((Entity)Piker.this, (byte)4);
        }

        public void m_8041_() {
            Piker.this.setMeleeAttacking(false);
        }

        public void m_8037_() {
            if (Piker.this.m_5448_() != null && Piker.this.m_5448_().m_6084_()) {
                LivingEntity livingentity = Piker.this.m_5448_();
                double d0 = Piker.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                MobUtil.instaLook((Mob)Piker.this, (Entity)livingentity);
                if (Piker.this.attackTick == 1) {
                    Piker.this.m_5496_((SoundEvent)ModSounds.PIKER_SWING.get(), Piker.this.m_6121_(), Piker.this.m_6100_());
                }
                if (Piker.this.attackTick == 8 && Piker.this.targetClose(livingentity, d0) && Piker.this.m_7327_((Entity)livingentity)) {
                    Piker.this.m_5496_((SoundEvent)ModSounds.PIKER_PIKE.get(), Piker.this.m_6121_(), Piker.this.m_6100_());
                    for (Entity entity : MeleeGoal.getTargets(Piker.this.f_19853_, (LivingEntity)Piker.this, 3.0)) {
                        LivingEntity living;
                        if (!(entity instanceof LivingEntity) || !Piker.this.m_142582_((Entity)(living = (LivingEntity)entity)) || MobUtil.areAllies((Entity)Piker.this, (Entity)living) || living == livingentity || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !Piker.this.m_6779_(livingentity)) continue;
                        Piker.this.m_7327_((Entity)living);
                    }
                }
            }
        }

        public static List<Entity> getTargets(Level level, LivingEntity pSource, double pRange) {
            ArrayList<Entity> list = new ArrayList<Entity>();
            Vec3 lookVec = pSource.m_20252_(1.0f);
            double[] lookRange = new double[]{lookVec.m_7096_() * pRange, lookVec.m_7098_() * pRange, lookVec.m_7094_() * pRange};
            List possibleList = level.m_45933_((Entity)pSource, pSource.m_20191_().m_82363_(lookRange[0], lookRange[1], lookRange[2]));
            for (Entity hit : possibleList) {
                if (!hit.m_6087_() || hit == pSource || !EntitySelector.f_20406_.and(EntitySelector.f_20403_).test(hit)) continue;
                list.add(hit);
            }
            return list;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class PikerAttackGoal
    extends MeleeAttackGoal {
        private int delayCounter;
        private static final float SPEED = 1.0f;

        public PikerAttackGoal() {
            super((PathfinderMob)Piker.this, 1.0, true);
        }

        public boolean m_8036_() {
            return Piker.this.m_5448_() != null && Piker.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            Piker.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = Piker.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            Piker.this.f_21365_.m_24960_((Entity)livingentity, 30.0f, 30.0f);
            double d0 = Piker.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            if (--this.delayCounter <= 0 && !Piker.this.targetClose(livingentity, d0)) {
                this.delayCounter = 10;
                Piker.this.m_21573_().m_5624_((Entity)livingentity, 1.0);
            }
            this.m_6739_(livingentity, Piker.this.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (Piker.this.targetClose(enemy, distToEnemySqr) && !Piker.this.isMeleeAttacking()) {
                Piker.this.setMeleeAttacking(true);
            }
        }

        public void m_8041_() {
            Piker.this.m_21573_().m_26573_();
            if (Piker.this.m_5448_() == null) {
                Piker.this.m_21561_(false);
            }
        }
    }
}

