/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.api.magic.IBreathingSpell;
import com.Polarice3.Goety.api.magic.IChargingSpell;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ai.SurroundGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.common.magic.spells.ArrowRainSpell;
import com.Polarice3.Goety.common.magic.spells.BulwarkSpell;
import com.Polarice3.Goety.common.magic.spells.FangSpell;
import com.Polarice3.Goety.common.magic.spells.FireBreathSpell;
import com.Polarice3.Goety.common.magic.spells.IronHideSpell;
import com.Polarice3.Goety.common.magic.spells.SoulHealSpell;
import com.Polarice3.Goety.common.magic.spells.VexSpell;
import com.Polarice3.Goety.common.magic.spells.abyss.BouncyBubbleSpell;
import com.Polarice3.Goety.common.magic.spells.frost.FrostBreathSpell;
import com.Polarice3.Goety.common.magic.spells.frost.IceGolemSpell;
import com.Polarice3.Goety.common.magic.spells.frost.IceSpikeSpell;
import com.Polarice3.Goety.common.magic.spells.frost.IceStormSpell;
import com.Polarice3.Goety.common.magic.spells.geomancy.EruptionSpell;
import com.Polarice3.Goety.common.magic.spells.geomancy.ScatterSpell;
import com.Polarice3.Goety.common.magic.spells.storm.ElectroOrbSpell;
import com.Polarice3.Goety.common.magic.spells.storm.ThunderboltSpell;
import com.Polarice3.Goety.common.magic.spells.wild.HuntingSpell;
import com.Polarice3.Goety.common.magic.spells.wild.MaulingSpell;
import com.Polarice3.Goety.common.magic.spells.wind.CycloneSpell;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import oshi.util.tuples.Pair;

public class Sorcerer
extends HuntingIllagerEntity {
    protected static final EntityDataAccessor<Byte> IS_CASTING_SPELL = SynchedEntityData.m_135353_(Sorcerer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(Sorcerer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(Sorcerer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(Sorcerer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int castingTime;
    protected int[] spellCoolDown = new int[SorcererSpell.values().length + 1];
    public int coolDown = 0;
    public boolean hasSpawned;
    public static int MIN_LEVEL = 1;
    public static int MAX_LEVEL = 5;

    public Sorcerer(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new SpellGoal());
        this.f_21345_.m_25352_(3, new SurroundGoal<Sorcerer>(this, 1.0, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SorcererHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.SorcererArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SorcererDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SorcererHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.SorcererArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SorcererDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CASTING_SPELL, (Object)0);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(LEVEL, (Object)1);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("SorcererLevel")) {
            boolean heal = !pCompound.m_128471_("HasSpawned");
            this.setSorcererLevel(pCompound.m_128451_("SorcererLevel"), heal);
        } else if (pCompound.m_128441_("Level")) {
            boolean heal = !pCompound.m_128471_("HasSpawned");
            this.setSorcererLevel(pCompound.m_128451_("Level"), heal);
        }
        this.castingTime = pCompound.m_128451_("SorcererSpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SorcererLevel", this.getSorcererLevel());
        pCompound.m_128405_("SorcererSpellTicks", this.castingTime);
        pCompound.m_128379_("HasSpawned", this.hasSpawned);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isShoot()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        if (this.isCharging()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        if (this.isCastingSpell2()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    @Override
    public boolean m_33736_() {
        return false;
    }

    public boolean isCastingSpell2() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(IS_CASTING_SPELL) > 0;
        }
        return this.castingTime > 0;
    }

    public void setIsCastingSpell(int id) {
        this.f_19804_.m_135381_(IS_CASTING_SPELL, (Object)((byte)id));
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isShoot() {
        return (Boolean)this.f_19804_.m_135370_(SHOOT);
    }

    public void setShoot(boolean shoot) {
        this.f_19804_.m_135381_(SHOOT, (Object)shoot);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        SpawnGroupData data = super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        if (p_37858_ != MobSpawnType.STRUCTURE) {
            this.setSorcererLevel(1 + p_37856_.m_213780_().m_188503_(1 + (int)p_37857_.m_19056_()), true);
        }
        return data;
    }

    public void m_5634_(float amount) {
        if (this.getSorcererLevel() >= 2) {
            amount *= 1.5f;
        }
        super.m_5634_(amount);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.castingTime > 0) {
            --this.castingTime;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasSpawned) {
            this.hasSpawned = true;
        }
        if (!this.f_19853_.f_46443_) {
            for (SorcererSpell spell : SorcererSpell.values()) {
                if (this.spellCoolDown[spell.trueId] <= 0) continue;
                int n = spell.trueId;
                this.spellCoolDown[n] = this.spellCoolDown[n] - 1;
            }
            if (this.coolDown > 0) {
                --this.coolDown;
            }
        }
    }

    protected int m_33738_() {
        return this.castingTime;
    }

    public int getSorcererLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public void setSorcererLevel(int level, boolean heal) {
        int i = Mth.m_14045_((int)level, (int)1, (int)5);
        this.f_19804_.m_135381_(LEVEL, (Object)i);
        if (((Boolean)MobsConfig.SorcererHPIncrease.get()).booleanValue()) {
            AttributeInstance health = this.m_21051_(Attributes.f_22276_);
            if (health != null && i > 1) {
                float increase = (float)(i - 1) * 1.25f;
                health.m_22100_((Double)AttributesConfig.SorcererHealth.get() * (double)increase);
            }
            if (heal) {
                this.m_21153_(this.m_21233_());
            }
        }
        this.f_21364_ = i * 8;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SORCERER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SORCERER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SORCERER_HURT.get();
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModSounds.CAST_SPELL.get();
    }

    public void m_7895_(int pWave, boolean p_37845_) {
        Raid raid = this.m_37885_();
        if (raid != null) {
            if (pWave >= raid.m_37724_(Difficulty.EASY)) {
                this.setSorcererLevel(this.getSorcererLevel() + 1, true);
            } else if (pWave >= raid.m_37724_(Difficulty.NORMAL)) {
                this.setSorcererLevel(this.getSorcererLevel() + 2, true);
            } else if (pWave > raid.m_37724_(Difficulty.HARD)) {
                this.setSorcererLevel(5, true);
            }
        }
    }

    @Override
    public void upgradeAssault(int sePercent) {
        if (sePercent >= 75) {
            this.setSorcererLevel(this.getSorcererLevel() + 3, true);
        } else if (sePercent >= 50) {
            this.setSorcererLevel(this.getSorcererLevel() + 2, true);
        } else if (sePercent >= 25) {
            this.setSorcererLevel(this.getSorcererLevel() + 1, true);
        }
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.SORCERER_AMBIENT.get();
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setCharging(true);
        } else if (p_21375_ == 5) {
            this.setCharging(false);
        } else if (p_21375_ == 6) {
            this.setShoot(true);
        } else if (p_21375_ == 7) {
            this.setShoot(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    protected static enum SorcererSpell {
        FLAMES(new FireBreathSpell(), SorcererSpell.nextID(), 1, 3),
        IRON_HIDE(new IronHideSpell(), SorcererSpell.nextID(), 1, 5, true),
        SUMMON_HOUND(new HuntingSpell(), SorcererSpell.nextID(), 1, 1),
        HEAL(new SoulHealSpell(), SorcererSpell.nextID(), 1, 5),
        FROST(new FrostBreathSpell(), SorcererSpell.nextID(), 2, 3),
        SUMMON_BEAR(new MaulingSpell(), SorcererSpell.nextID(), 2, 3, true),
        FANGS(new FangSpell(), SorcererSpell.nextID(), 2, 5, true),
        SUMMON_ICE_GOLEM(new IceGolemSpell(), SorcererSpell.nextID(), 3, 5, true),
        ICE_SPIKE(new IceSpikeSpell(), SorcererSpell.nextID(), 3, 5, true),
        THUNDERBOLT(new ThunderboltSpell(), SorcererSpell.nextID(), 3, 5, true, (Pair<ItemStack, Integer>)new Pair((Object)new ItemStack((ItemLike)ModItems.STORM_STAFF.get()), (Object)4)),
        SCATTER(new ScatterSpell(), SorcererSpell.nextID(), 3, 5, true),
        ICE_STORM(new IceStormSpell(), SorcererSpell.nextID(), 4, 5, true),
        BULWARK(new BulwarkSpell(), SorcererSpell.nextID(), 4, 5),
        ELECTRO(new ElectroOrbSpell(), SorcererSpell.nextID(), 4, 5, true),
        BOUNCY_BUBBLE(new BouncyBubbleSpell(), SorcererSpell.nextID(), 4, 5),
        ARROW_RAIN(new ArrowRainSpell(), SorcererSpell.nextID(), 5, 5),
        VEX(new VexSpell(), SorcererSpell.nextID(), 5, 5),
        CYCLONE(new CycloneSpell(), SorcererSpell.nextID(), 5, 5),
        ERUPTION(new EruptionSpell(), SorcererSpell.nextID(), 5, 5);

        final Spell spell;
        private static int id;
        final int trueId;
        final int minLevel;
        final int maxLevel;
        final boolean levelIncrease;
        final Pair<ItemStack, Integer> upgradeStaff;

        public static int nextID() {
            return id++;
        }

        private SorcererSpell(Spell spell, int id, int minLevel, int maxLevel) {
            this(spell, id, minLevel, maxLevel, false, (Pair<ItemStack, Integer>)new Pair((Object)ItemStack.f_41583_, (Object)0));
        }

        private SorcererSpell(Spell spell, int id, int minLevel, int maxLevel, boolean levelIncrease) {
            this(spell, id, minLevel, maxLevel, levelIncrease, (Pair<ItemStack, Integer>)new Pair((Object)ItemStack.f_41583_, (Object)0));
        }

        private SorcererSpell(Spell spell, int id, int minLevel, int maxLevel, boolean levelIncrease, Pair<ItemStack, Integer> upgradeStaff) {
            this.spell = spell;
            this.trueId = id;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.levelIncrease = levelIncrease;
            this.upgradeStaff = upgradeStaff;
        }

        public Spell getSpell() {
            return this.spell;
        }

        public boolean throwingSpell() {
            return this == ICE_SPIKE || this == THUNDERBOLT || this == ELECTRO || this == CYCLONE;
        }

        static {
            id = 0;
        }
    }

    class CastingSpellGoal
    extends Goal {
        private CastingSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Sorcerer.this.m_33738_() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            Sorcerer.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            Sorcerer.this.setIsCastingSpell(0);
            Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)5);
            Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)7);
            Sorcerer.this.coolDown = 20;
        }

        public void m_8037_() {
            if (Sorcerer.this.m_5448_() != null) {
                MobUtil.instaLook((Mob)Sorcerer.this, (Entity)Sorcerer.this.m_5448_());
            }
            Sorcerer.this.m_21573_().m_26573_();
            Sorcerer.this.m_21566_().m_24988_(0.0f, 0.0f);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class SpellGoal
    extends SorcererUseSpellGoal {
        public SorcererSpell spell;
        public int chargeTicks;

        SpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            ArrayList<SorcererSpell> spells = new ArrayList<SorcererSpell>();
            for (SorcererSpell spell1 : SorcererSpell.values()) {
                if (Sorcerer.this.getSorcererLevel() < spell1.minLevel || Sorcerer.this.getSorcererLevel() > spell1.maxLevel || !spell1.getSpell().conditionsMet(Sorcerer.this.f_19853_, (LivingEntity)Sorcerer.this) || Sorcerer.this.spellCoolDown[spell1.trueId] > 0) continue;
                if (spell1.getSpell() instanceof SummonSpell && !Sorcerer.this.m_21023_((MobEffect)GoetyEffects.SUMMON_DOWN.get())) {
                    spells.add(spell1);
                    continue;
                }
                if (spell1.getSpell() instanceof SummonSpell) continue;
                spells.add(spell1);
            }
            this.spell = !spells.isEmpty() ? (SorcererSpell)((Object)spells.get(Sorcerer.this.f_19796_.m_188503_(spells.size()))) : null;
            if (this.spell != null && this.spell.getSpell() instanceof IChargingSpell) {
                this.chargeTicks = 20;
            }
            return this.spell != null && super.m_8036_();
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.spell.getSpell() instanceof IChargingSpell) {
                if (!this.spell.getSpell().conditionsMet(Sorcerer.this.f_19853_, (LivingEntity)Sorcerer.this)) {
                    this.cancelSpell();
                }
                --this.chargeTicks;
                if (this.chargeTicks <= 0) {
                    Spell spell1 = this.spell.getSpell();
                    SpellStat spellStat = WandUtil.getStats((LivingEntity)Sorcerer.this, spell1);
                    if (this.spell.levelIncrease) {
                        spellStat.setPotency(Sorcerer.this.getSorcererLevel() - this.spell.minLevel);
                    }
                    spell1.mobSpellResult((LivingEntity)Sorcerer.this, Sorcerer.this.getSorcererLevel() >= (Integer)this.spell.upgradeStaff.getB() ? (ItemStack)this.spell.upgradeStaff.getA() : ItemStack.f_41583_, spellStat);
                    Spell spell = this.spell.getSpell();
                    if (spell instanceof IBreathingSpell) {
                        IBreathingSpell breathingSpell = (IBreathingSpell)((Object)spell);
                        if (Sorcerer.this.m_5448_() != null) {
                            MobUtil.instaLook((Mob)Sorcerer.this, (Entity)Sorcerer.this.m_5448_());
                        }
                        breathingSpell.showWandBreath((LivingEntity)Sorcerer.this, WandUtil.getStats((LivingEntity)Sorcerer.this, breathingSpell));
                    }
                }
                Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)4);
            } else {
                Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)5);
                if (this.spell.throwingSpell()) {
                    Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)6);
                } else {
                    Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)7);
                }
            }
            this.spell.getSpell().useParticle(Sorcerer.this.f_19853_, (LivingEntity)Sorcerer.this, ItemStack.f_41583_);
        }

        public void cancelSpell() {
            this.attackWarmupDelay = 0;
            Sorcerer.this.castingTime = 0;
            Sorcerer.this.setIsCastingSpell(0);
            Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)5);
            Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)7);
            Sorcerer.this.coolDown = 20;
        }

        @Override
        protected void performSpellCasting() {
            if (Sorcerer.this.m_5448_() != null) {
                Spell spell1 = this.spell.getSpell();
                SpellStat spellStat = WandUtil.getStats((LivingEntity)Sorcerer.this, spell1);
                if (this.spell.levelIncrease) {
                    spellStat.setPotency(spellStat.getPotency() + (Sorcerer.this.getSorcererLevel() - this.spell.minLevel));
                }
                if (this.spell.throwingSpell()) {
                    Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)6);
                } else {
                    Sorcerer.this.f_19853_.m_7605_((Entity)Sorcerer.this, (byte)7);
                }
                spell1.mobSpellResult((LivingEntity)Sorcerer.this, Sorcerer.this.getSorcererLevel() >= (Integer)this.spell.upgradeStaff.getB() ? (ItemStack)this.spell.upgradeStaff.getA() : ItemStack.f_41583_, spellStat);
            }
        }

        @Override
        protected int getCastWarmupTime() {
            Spell spell = this.spell.getSpell();
            if (spell instanceof IChargingSpell) {
                IChargingSpell chargingSpell = (IChargingSpell)((Object)spell);
                return chargingSpell.shotsNumber((LivingEntity)Sorcerer.this, ItemStack.f_41583_);
            }
            return this.spell.getSpell().defaultCastDuration() + 5;
        }

        @Override
        protected int getCastingTime() {
            Spell spell = this.spell.getSpell();
            if (spell instanceof IChargingSpell) {
                IChargingSpell chargingSpell = (IChargingSpell)((Object)spell);
                return chargingSpell.shotsNumber((LivingEntity)Sorcerer.this, ItemStack.f_41583_);
            }
            return this.spell.getSpell().defaultCastDuration() + 5;
        }

        @Override
        protected int getCastingInterval() {
            Spell spell = this.spell.getSpell();
            if (spell instanceof IChargingSpell) {
                IChargingSpell chargingSpell = (IChargingSpell)((Object)spell);
                return chargingSpell.defaultSpellCooldown() * 2;
            }
            return this.spell.getSpell().defaultSpellCooldown();
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return this.spell.getSpell().CastingSound((LivingEntity)Sorcerer.this);
        }

        @Override
        protected SorcererSpell getSpell() {
            return this.spell;
        }
    }

    protected abstract class SorcererUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;

        protected SorcererUseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Sorcerer.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                return !Sorcerer.this.isCastingSpell2() && Sorcerer.this.m_142582_((Entity)livingentity) && Sorcerer.this.coolDown <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Sorcerer.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            Sorcerer.this.castingTime = this.getCastingTime();
            Sorcerer.this.spellCoolDown[this.getSpell().trueId] = this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                Sorcerer.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
            Sorcerer.this.setIsCastingSpell(this.getSpell().trueId);
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
            }
        }

        public boolean m_183429_() {
            return true;
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract SorcererSpell getSpell();
    }
}

