/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.scores.Team;

public class Owned
extends PathfinderMob
implements IOwned,
OwnableEntity,
ICustomAttributes {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> HOSTILE = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> NATURAL = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final NearestAttackableTargetGoal<Player> targetGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    public boolean limitedLifespan;
    public int limitedLifeTicks;

    protected Owned(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.checkHostility();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.ownerHurtGoals();
    }

    public void ownerHurtGoals() {
        this.f_21346_.m_25352_(1, new OwnerHurtByTargetGoal<Owned>(this));
        this.f_21346_.m_25352_(2, new OwnerHurtTargetGoal<Owned>(this));
    }

    @Override
    public void setConfigurableAttributes() {
    }

    public boolean m_20177_(Player p_20178_) {
        if (p_20178_ == this.getMasterOwner()) {
            return false;
        }
        return super.m_20177_(p_20178_);
    }

    public void m_8107_() {
        this.m_21203_();
        if (this.isHostile()) {
            this.updateNoActionTime();
        }
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.ownedTick();
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public boolean m_21532_() {
        return super.m_21532_() || this.getTrueOwner() != null;
    }

    public boolean m_7327_(Entity entity) {
        if (this.getTrueOwner() != null) {
            boolean flag;
            int i;
            float f = (float)this.m_21133_(Attributes.f_22281_);
            float f1 = (float)this.m_21133_(Attributes.f_22282_);
            if (entity instanceof LivingEntity) {
                f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
                f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
            }
            if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                entity.m_20254_(i * 4);
            }
            if (flag = this.doHurtTarget(f, entity)) {
                if (f1 > 0.0f && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
                this.m_19970_((LivingEntity)this, entity);
                this.m_21335_(entity);
            }
            return flag;
        }
        return super.m_7327_(entity);
    }

    public boolean doHurtTarget(float amount, Entity target) {
        return target.m_6469_(ModDamageSource.summonAttack((LivingEntity)this, this.getTrueOwner()), amount);
    }

    public void m_21424_(Player player, ItemStack axe, ItemStack shield) {
        if (!axe.m_41619_() && !shield.m_41619_() && axe.m_41720_() instanceof AxeItem && shield.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)player, (byte)30);
            }
        }
    }

    @Nullable
    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.getTrueOwner() != null && (livingentity = this.getTrueOwner()) != null && livingentity != this && !this.areOwnedByEachOther(livingentity) && livingentity.m_5647_() != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean areOwnedByEachOther(LivingEntity livingEntity) {
        if (livingEntity instanceof IOwned) {
            IOwned owned = (IOwned)livingEntity;
            return owned.getTrueOwner() == this && this.getTrueOwner() == livingEntity;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7307_(Entity entityIn) {
        if (this.getTrueOwner() == null) return super.m_7307_(entityIn);
        LivingEntity trueOwner = this.getTrueOwner();
        if (trueOwner.m_7307_(entityIn)) return true;
        if (entityIn.m_7307_((Entity)trueOwner)) return true;
        if (entityIn == trueOwner) return true;
        if (entityIn instanceof IOwned) {
            IOwned owned = (IOwned)entityIn;
            if (MobUtil.ownerStack(this, owned)) return true;
        }
        if (entityIn instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entityIn;
            if (ownable.m_269323_() == trueOwner) return true;
        }
        if (!(trueOwner instanceof Player)) return false;
        Player player = (Player)trueOwner;
        if (!(entityIn instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entityIn;
        if (SEHelper.getAllyEntities(player).contains(livingEntity)) return true;
        if (!SEHelper.getAllyEntityTypes(player).contains(livingEntity.m_6095_())) return false;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(HOSTILE, (Object)false);
        this.f_19804_.m_135372_(NATURAL, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readOwnedData(compound);
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.saveOwnedData(compound);
    }

    @Override
    public void setHasLifespan(boolean lifespan) {
        this.limitedLifespan = lifespan;
    }

    @Override
    public boolean hasLifespan() {
        return this.limitedLifespan;
    }

    @Override
    public void setLifespan(int lifespan) {
        this.limitedLifeTicks = lifespan;
    }

    @Override
    public int getLifespan() {
        return this.limitedLifeTicks;
    }

    @Override
    public void convertNewEquipment(Entity entity) {
        this.m_213945_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
    }

    @Override
    @Nullable
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        return this.m_6095_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.checkHostility();
        if (pReason != MobSpawnType.MOB_SUMMONED && this.getTrueOwner() == null) {
            this.setNatural(true);
        }
        if (this.getTrueOwner() instanceof Player) {
            this.m_21530_();
        }
        return pSpawnData;
    }

    @Override
    @Nullable
    public LivingEntity getTrueOwner() {
        LivingEntity living;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(this.f_19853_, uuid);
        }
        int id = this.getOwnerClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getOwnerClientId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    @Override
    @Nullable
    public LivingEntity getMasterOwner() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof IOwned) {
            IOwned owned = (IOwned)livingEntity;
            return owned.getTrueOwner();
        }
        return this.getTrueOwner();
    }

    @Nullable
    public UUID m_21805_() {
        return this.getOwnerId();
    }

    @Nullable
    public LivingEntity m_269323_() {
        return this.getTrueOwner();
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    @Override
    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    @Override
    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    @Override
    public void setHostile(boolean hostile) {
        this.f_19804_.m_135381_(HOSTILE, (Object)hostile);
        this.addTargetGoal();
    }

    public void addTargetGoal() {
        this.f_21346_.m_25352_(2, this.targetGoal);
    }

    @Override
    public boolean isHostile() {
        return (Boolean)this.f_19804_.m_135370_(HOSTILE);
    }

    @Override
    public void setNatural(boolean natural) {
        this.f_19804_.m_135381_(NATURAL, (Object)natural);
    }

    @Override
    public boolean isNatural() {
        return (Boolean)this.f_19804_.m_135370_(NATURAL);
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        if (this.getTrueOwner() != null) {
            return pPotioneffect.m_19544_() != GoetyEffects.GOLD_TOUCHED.get() && super.m_7301_(pPotioneffect);
        }
        return super.m_7301_(pPotioneffect);
    }

    public int m_213860_() {
        if (this.isHostile()) {
            this.f_21364_ = this.xpReward();
        }
        return super.m_213860_();
    }

    public int xpReward() {
        return 5;
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.f_19853_.f_46443_ && p_21294_ != this.getTrueOwner()) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        if (!this.f_19853_.f_46443_ && p_20971_ != this.getTrueOwner()) {
            super.m_7324_(p_20971_);
        }
    }

    public boolean m_7337_(Entity p_20303_) {
        if (p_20303_ != this.getTrueOwner()) {
            return super.m_7337_(p_20303_);
        }
        return false;
    }

    protected boolean m_8028_() {
        return this.isHostile();
    }

    public boolean m_6785_(double p_27519_) {
        return this.isHostile();
    }

    public static boolean checkHostileSpawnRules(EntityType<? extends Owned> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Owned.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends Owned> pType, LevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && Owned.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkDayMonsterSpawnRules(EntityType<? extends Owned> pType, LevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_45517_(LightLayer.BLOCK, pPos) <= 8 && Owned.checkAnyLightMonsterSpawnRules(pType, pLevel, pReason, pPos, pRandom);
    }

    public boolean m_20160_() {
        IAutoRideable rideable;
        Owned owned = this;
        if (owned instanceof IAutoRideable && (rideable = (IAutoRideable)((Object)owned)).isAutonomous()) {
            return false;
        }
        return super.m_20160_();
    }

    public static class OwnerHurtByTargetGoal<T extends Mob>
    extends TargetGoal {
        private final T owned;
        private LivingEntity attacker;
        private int timestamp;

        public OwnerHurtByTargetGoal(T summonedEntity) {
            super(summonedEntity, false);
            this.owned = summonedEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = ((IOwned)this.owned).getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            this.attacker = livingentity.m_21188_();
            int i = livingentity.m_21213_();
            return i != this.timestamp && this.m_26150_(this.attacker, TargetingConditions.f_26872_) && this.attacker != ((IOwned)this.owned).getTrueOwner();
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.attacker);
            LivingEntity livingentity = ((IOwned)this.owned).getTrueOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public static class OwnerHurtTargetGoal<T extends Mob>
    extends TargetGoal {
        private final T owned;
        private LivingEntity attacker;
        private int timestamp;

        public OwnerHurtTargetGoal(T summonedEntity) {
            super(summonedEntity, false);
            this.owned = summonedEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = ((IOwned)this.owned).getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            this.attacker = livingentity.m_21214_();
            int i = livingentity.m_21215_();
            return i != this.timestamp && this.m_26150_(this.attacker, TargetingConditions.f_26872_) && this.attacker != ((IOwned)this.owned).getTrueOwner();
        }

        public void m_8056_() {
            this.owned.m_6710_(this.attacker);
            LivingEntity livingentity = ((IOwned)this.owned).getTrueOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }
}

