/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TotemicWall
extends AbstractMonolith {
    public TotemicWall(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.canSpawn((Level)pLevel.m_6018_())) {
            this.m_5496_((SoundEvent)ModSounds.WALL_SPAWN.get(), 2.0f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.WALL_ERUPT.get(), 1.0f, 1.0f);
            ServerLevel serverLevel = pLevel.m_6018_();
            for (int i = 0; i < serverLevel.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Level)serverLevel);
            }
        }
        return pSpawnData;
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50069_.m_49966_();
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268490_)) {
            this.m_216990_((SoundEvent)ModSounds.WALL_HIT.get());
        }
        return pSource.m_269533_(DamageTypeTags.f_268738_);
    }

    @Override
    public int getAgeSpeed() {
        return 5;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.isEmerging()) {
            if (!this.isActivate()) {
                this.setActivate(true);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.f_19797_ >= MathHelper.secondsToTicks(this.getLifeSpan())) {
                    this.setAge(this.getAge() - this.getAgeSpeed());
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                }
                if (this.getAge() <= 0) {
                    this.m_146870_();
                }
            }
            if (this.f_19797_ == MathHelper.secondsToTicks(this.getLifeSpan())) {
                this.m_5496_((SoundEvent)ModSounds.WALL_DISAPPEAR.get(), 2.0f, 1.0f);
            }
        }
    }
}

