/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.BlossomThorn;
import com.Polarice3.Goety.common.entities.projectiles.SpellThrowableProjectile;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class BlossomBall
extends SpellThrowableProjectile {
    public double radius = 3.0;
    public int duration = 0;

    public BlossomBall(EntityType<? extends SpellThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public BlossomBall(LivingEntity pOwner, Level p_37464_) {
        super((EntityType<? extends SpellThrowableProjectile>)((EntityType)ModEntityType.BLOSSOM_BALL.get()), pOwner, p_37464_);
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128347_("Radius", this.getRadius());
        pCompound.m_128405_("Duration", this.getDuration());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Radius")) {
            this.setRadius(pCompound.m_128459_("Radius"));
        }
        if (pCompound.m_128441_("Duration")) {
            this.setDuration(pCompound.m_128451_("Duration"));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
    }

    public void explode(HitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            this.m_5496_((SoundEvent)ModSounds.QUICK_GROWING_VINE_BURROW.get(), 2.0f, 0.75f);
            if (this.getOwner() != null) {
                Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
                if (pResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)pResult;
                    BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    if (BlockFinder.canBeReplaced(this.f_19853_, blockpos)) {
                        vec3 = Vec3.m_82512_((Vec3i)blockpos);
                    }
                } else if (pResult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)pResult;
                    Entity entity1 = entityHitResult.m_82443_();
                    vec3 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
                }
                BlossomThorn blossomThorn0 = new BlossomThorn(this.f_19853_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 30, this.getOwner());
                MobUtil.moveDownToGround(blossomThorn0);
                blossomThorn0.setDuration(this.getDuration());
                blossomThorn0.setExtraDamage(this.getExtraDamage());
                this.f_19853_.m_7967_((Entity)blossomThorn0);
                List<Vec3> circlePoints = BlockFinder.buildBlockCircle(this.getRadius());
                for (Vec3 point : circlePoints) {
                    Vec3 vec31 = vec3.m_82549_(point);
                    BlossomThorn blossomThorn = new BlossomThorn(this.f_19853_, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 30, this.getOwner());
                    MobUtil.moveDownToGround(blossomThorn);
                    blossomThorn.setDuration(this.getDuration());
                    blossomThorn.setExtraDamage(this.getExtraDamage());
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BLOSSOM_THORN_INDICATOR.get()), blossomThorn.m_20182_().f_82479_, blossomThorn.m_20182_().f_82480_ + (double)0.1f, blossomThorn.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    blossomThorn.m_20225_(true);
                    this.f_19853_.m_7967_((Entity)blossomThorn);
                }
            }
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.explode(pResult);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (this.getOwner() != null) {
                float baseDamage = ((Double)SpellConfig.BlossomDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                if (target.m_6469_(this.m_269291_().m_269374_((Entity)this.getOwner()), baseDamage + this.getExtraDamage())) {
                    MobEffect effect = MobEffects.f_19614_;
                    if (CuriosFinder.hasWildRobe(this.getOwner())) {
                        effect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                    }
                    target.m_147207_(new MobEffectInstance(effect, 140 + MathHelper.secondsToTicks(this.duration)), (Entity)this);
                }
            }
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            if (pEntity == this.getOwner()) {
                return false;
            }
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

