/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.GroundProjectile;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class Hellfire
extends GroundProjectile {
    public static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(Hellfire.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public boolean isDying;

    public Hellfire(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
        this.m_146922_(0.0f);
        this.lifeTicks = MathHelper.secondsToTicks(7);
    }

    public Hellfire(Level world, double pPosX, double pPosY, double pPosZ, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.HELLFIRE.get()), world);
        this.setOwner(owner);
        this.m_6034_(pPosX, pPosY, pPosZ);
    }

    public Hellfire(Level world, BlockPos blockPos, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.HELLFIRE.get()), world);
        this.setOwner(owner);
        this.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public Hellfire(Level world, Vec3 vector3d, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.HELLFIRE.get()), world);
        this.setOwner(owner);
        this.m_6034_(vector3d.m_7096_(), vector3d.m_7098_(), vector3d.m_7094_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public boolean isDying() {
        return this.isDying;
    }

    public void setDying(boolean dying) {
        this.isDying = dying;
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Dying")) {
            this.setDying(pCompound.m_128471_("Dying"));
        }
        if (pCompound.m_128441_("ExtraDamage")) {
            this.setExtraDamage(pCompound.m_128457_("ExtraDamage"));
        }
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Dying", this.isDying());
        pCompound.m_128350_("ExtraDamage", this.getExtraDamage());
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.lifeTicks <= 26) {
                --this.lifeTicks;
            }
            this.f_19853_.m_7106_((ParticleOptions)new MagicSmokeParticle.Option(13597190, 11616000, 10 + this.f_19853_.m_213780_().m_188503_(10), 0.2f), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            if (this.f_19853_.f_46441_.m_188503_(24) == 0) {
                this.f_19853_.m_7785_((double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + this.f_19853_.f_46441_.m_188501_(), this.f_19853_.f_46441_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            if (!this.m_20068_()) {
                MobUtil.moveDownToGround(this);
            }
            if (this.lifeTicks > 13) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())) {
                    this.dealDamageTo(livingentity);
                }
            }
            --this.lifeTicks;
            if (this.lifeTicks <= 26) {
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            }
            if (this.lifeTicks < 0) {
                this.m_146870_();
            }
            if (this.m_20077_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
                this.m_146870_();
            }
        }
    }

    public void dealDamageTo(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        float damage = 2.0f;
        damage += this.getExtraDamage();
        if (target.m_6084_() && !target.m_20147_()) {
            if (owner == null) {
                if (target.m_6469_(ModDamageSource.getDamageSource(this.f_19853_, ModDamageSource.HELLFIRE, new EntityType[0]), damage) && !target.m_5825_()) {
                    target.f_19802_ = 15;
                }
            } else {
                if (target == owner) {
                    return;
                }
                if (owner instanceof Mob) {
                    IOwned owned;
                    Mob mobOwner = (Mob)owner;
                    if (mobOwner instanceof Enemy && target instanceof Enemy && mobOwner.m_5448_() != target) {
                        return;
                    }
                    if (mobOwner instanceof IOwned && (owned = (IOwned)mobOwner).getTrueOwner() != null && MobUtil.areAllies((Entity)owned.getTrueOwner(), (Entity)target)) {
                        return;
                    }
                }
                if (MobUtil.areAllies((Entity)owner, (Entity)target)) {
                    return;
                }
                if (target.m_6469_(ModDamageSource.hellfire(this, (Entity)this.getOwner()), damage) && !target.m_5825_()) {
                    target.f_19802_ = 15;
                }
            }
        }
    }

    @Override
    public float getAnimationProgress(float pPartialTicks) {
        if (this.lifeTicks <= 24) {
            int i = this.lifeTicks;
            return Math.max(1.0f - (24.0f - (float)i) / 24.0f, 0.0f);
        }
        return 1.0f;
    }

    @Override
    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 6 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, this.m_5720_(), 1.0f, 1.0f, false);
        }
        if (pId == 7 && !this.isDying()) {
            this.lifeTicks = 26;
            this.setDying(true);
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

