/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellHurtingProjectile;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class IceStorm
extends SpellHurtingProjectile {
    private static final EntityDataAccessor<Float> ID_SIZE = SynchedEntityData.m_135353_(IceStorm.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int duration = 0;
    public int range = 0;

    public IceStorm(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
        this.f_19794_ = true;
    }

    public IceStorm(double p_36818_, double p_36819_, double p_36820_, double p_36821_, double p_36822_, double p_36823_, Level p_36824_) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityType.ICE_STORM.get()), p_36818_, p_36819_, p_36820_, p_36821_, p_36822_, p_36823_, p_36824_);
        this.f_19794_ = true;
    }

    public IceStorm(LivingEntity p_36827_, double p_36828_, double p_36829_, double p_36830_, Level p_36831_) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityType.ICE_STORM.get()), p_36827_, p_36828_, p_36829_, p_36830_, p_36831_);
        this.f_19794_ = true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (ID_SIZE.equals(p_33134_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33134_);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Size", this.getSize());
        pCompound.m_128405_("Duration", this.getDuration());
        pCompound.m_128405_("Range", this.getRange());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Size")) {
            this.setSize(pCompound.m_128457_("Size"));
        }
        if (pCompound.m_128441_("Duration")) {
            this.setDuration(pCompound.m_128451_("Duration"));
        }
        if (pCompound.m_128441_("Range")) {
            this.setRange(pCompound.m_128451_("Range"));
        }
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = this.getSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        float f = (entitydimensions.f_20377_ + 0.2f * i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public void setSize(float p_33109_) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Float.valueOf(Mth.m_14036_((float)p_33109_, (float)0.0f, (float)64.0f)));
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(ID_SIZE)).floatValue();
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    protected float m_6884_() {
        return 0.68f + Math.min(this.boltSpeed, 0.32f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (!this.f_19853_.f_46443_) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.addAuraParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() - 0.5 + (double)(this.getSize() / 4.0f), this.m_20189_(), this.getSize() / 4.0f + 0.5f);
                ServerParticleUtil.addAuraParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + 1.0 + (double)(this.getSize() / 4.0f), this.m_20189_(), this.getSize() / 4.0f + 0.5f);
                ServerParticleUtil.addAuraParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + 0.5 + (double)(this.getSize() / 4.0f), this.m_20189_(), this.getSize() / 2.0f + 1.0f);
            }
            this.setSize(this.getSize() + 0.05f);
            if (this.f_19797_ >= MathHelper.secondsToTicks(5) + this.getRange() * 10) {
                this.m_146870_();
            }
            float baseDamage = ((Double)SpellConfig.IceStormDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            for (Entity entity : this.f_19853_.m_6443_(Entity.class, this.m_20191_().m_82400_(1.0), EntitySelector.f_20406_)) {
                LivingEntity livingEntity = MobUtil.getLivingTarget(entity);
                if (livingEntity == null) continue;
                if (owner != null) {
                    if (MobUtil.areAllies(owner, (Entity)livingEntity) || livingEntity == owner || !livingEntity.m_6469_(ModDamageSource.indirectFreeze((Entity)this, owner), baseDamage + this.getExtraDamage())) continue;
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(1 + this.getDuration())));
                    continue;
                }
                if (!livingEntity.m_6469_(ModDamageSource.indirectFreeze((Entity)this, (Entity)this), baseDamage + this.getExtraDamage())) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(1 + this.getDuration())));
            }
        }
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_175821_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Override
    protected boolean m_5603_(Entity p_36842_) {
        return super.m_5603_(p_36842_) && !p_36842_.f_19794_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

