/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.MagmaCubeServant;
import com.Polarice3.Goety.common.entities.projectiles.Pyroclast;
import com.Polarice3.Goety.common.entities.projectiles.SpellThrowableProjectile;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MagmaBomb
extends SpellThrowableProjectile {
    public float explosionPower = 3.0f;
    public int duration = 0;
    public int defaultDuration = 0;

    public MagmaBomb(EntityType<? extends SpellThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public MagmaBomb(double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        super((EntityType<? extends SpellThrowableProjectile>)((EntityType)ModEntityType.MAGMA_BOMB.get()), p_37457_, p_37458_, p_37459_, p_37460_);
    }

    public MagmaBomb(LivingEntity pOwner, Level p_37464_) {
        super((EntityType<? extends SpellThrowableProjectile>)((EntityType)ModEntityType.MAGMA_BOMB.get()), pOwner, p_37464_);
    }

    public void setExplosionPower(float pExplosionPower) {
        this.explosionPower = pExplosionPower;
    }

    public float getExplosionPower() {
        return this.explosionPower;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDefaultDuration(int duration) {
        this.defaultDuration = duration;
    }

    public int getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExplosionPower", this.getExplosionPower());
        pCompound.m_128405_("Duration", this.getDuration());
        pCompound.m_128405_("DefaultDuration", this.getDefaultDuration());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ExplosionPower", 99)) {
            this.setExplosionPower(pCompound.m_128457_("ExplosionPower"));
        }
        if (pCompound.m_128441_("Duration")) {
            this.setDuration(pCompound.m_128451_("Duration"));
        }
        if (pCompound.m_128441_("DefaultDuration")) {
            this.setDefaultDuration(pCompound.m_128451_("DefaultDuration"));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
        this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.BIG_FIRE.get(), d0 + this.f_19853_.f_46441_.m_188500_() / 2.0, d1 + 0.5, d2 + this.f_19853_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
    }

    public void explode(HitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            int i1;
            EntityHitResult entityHitResult;
            Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
            if (pResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)pResult;
                BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                if (BlockFinder.canBeReplaced(this.f_19853_, blockpos)) {
                    vec3 = Vec3.m_82512_((Vec3i)blockpos);
                }
            } else if (pResult instanceof EntityHitResult) {
                entityHitResult = (EntityHitResult)pResult;
                Entity entity1 = entityHitResult.m_82443_();
                vec3 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
            }
            MobUtil.explosionDamage(this.f_19853_, (Entity)(this.getOwner() != null ? this.getOwner() : this), this.m_269291_().m_269036_((Entity)this, (Entity)this.getOwner()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.explosionPower, 0.0f);
            entityHitResult = this.f_19853_;
            if (entityHitResult instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entityHitResult;
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ModParticleTypes.BIG_FIRE.get(), (Entity)this);
                ColorUtil colorUtil = new ColorUtil(14523414);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, this.explosionPower + 1.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround((Entity)this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_FIRE_GROUND.get(), vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.0, 0.0, this.explosionPower);
                DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)8021604).m_252839_()), 1.0f);
                DustCloudParticleOption cloudParticleOptions2 = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)15508116).m_252839_()), 1.0f);
                for (int i = 0; i < 2; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, this.explosionPower / 2.0f);
                }
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions2, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, this.explosionPower / 2.0f);
            }
            this.m_5496_(SoundEvents.f_11913_, 4.0f, 1.0f);
            int i = this.isStaff() ? 3 : 2;
            for (i1 = 0; i1 < i; ++i1) {
                MagmaCubeServant magmaCube = (MagmaCubeServant)((EntityType)ModEntityType.MAGMA_CUBE_SERVANT.get()).m_20615_(this.f_19853_);
                if (magmaCube == null) continue;
                if (this.getOwner() != null) {
                    magmaCube.setTrueOwner(this.getOwner());
                } else {
                    magmaCube.setHostile(true);
                }
                magmaCube.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                magmaCube.setSize(2, true);
                if (i1 == 2) {
                    magmaCube.setSize(4, true);
                }
                magmaCube.m_20219_(this.m_20182_());
                int i2 = this.getDefaultDuration() == 0 ? MobUtil.getSummonLifespan(this.f_19853_) : this.getDefaultDuration();
                magmaCube.setLimitedLife(i2 * (this.getDuration() + 1));
                this.f_19853_.m_7967_((Entity)magmaCube);
            }
            if (this.isStaff()) {
                for (i1 = 0; i1 < 4; ++i1) {
                    Pyroclast pyroclast = new Pyroclast(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), this.f_19853_);
                    if (this.getOwner() != null) {
                        pyroclast.m_5602_((Entity)this.getOwner());
                    } else {
                        pyroclast.m_5602_((Entity)this);
                    }
                    pyroclast.setExplosionPower(this.getExplosionPower() / 2.0f);
                    pyroclast.setPotency((int)this.getExtraDamage());
                    pyroclast.setFlaming(0);
                    MobUtil.shootUp((Projectile)pyroclast, (Entity)this, MobUtil.ceilingVelocity((Entity)this, 0.75f));
                }
            }
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.explode(pResult);
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.getOwner() != null) {
            Mob mob;
            if (pEntity == this.getOwner()) {
                return false;
            }
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

