/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.BrewUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;

public class BrewEffectCloud
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(BrewEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(BrewEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.m_135353_(BrewEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.m_135353_(BrewEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private final List<MobEffectInstance> effects = Lists.newArrayList();
    private final List<BrewEffectInstance> brewEffects = Lists.newArrayList();
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean fixedColor;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public BrewEffectCloud(EntityType<? extends BrewEffectCloud> p_19704_, Level p_19705_) {
        super(p_19704_, p_19705_);
        this.f_19794_ = true;
        this.setRadius(3.0f);
    }

    public BrewEffectCloud(Level p_19707_, double p_19708_, double p_19709_, double p_19710_) {
        this((EntityType<? extends BrewEffectCloud>)((EntityType)ModEntityType.BREW_EFFECT_CLOUD.get()), p_19707_);
        this.m_6034_(p_19708_, p_19709_, p_19710_);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_COLOR, (Object)0);
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(DATA_WAITING, (Object)false);
        this.m_20088_().m_135372_(DATA_PARTICLE, (Object)ParticleTypes.f_123811_);
    }

    public void setRadius(float p_19713_) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)p_19713_, (float)0.0f, (float)32.0f)));
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    private void updateColor() {
        this.m_20088_().m_135381_(DATA_COLOR, (Object)BrewUtils.getColor(this.effects, this.brewEffects));
    }

    public void addEffect(MobEffectInstance p_19717_) {
        this.effects.add(p_19717_);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public void addBrewEffect(BrewEffectInstance p_19717_) {
        this.brewEffects.add(p_19717_);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    public void setFixedColor(int p_19715_) {
        this.fixedColor = true;
        this.m_20088_().m_135381_(DATA_COLOR, (Object)p_19715_);
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.m_20088_().m_135370_(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions p_19725_) {
        this.m_20088_().m_135381_(DATA_PARTICLE, (Object)p_19725_);
    }

    protected void setWaiting(boolean p_19731_) {
        this.m_20088_().m_135381_(DATA_WAITING, (Object)p_19731_);
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_19735_) {
        this.duration = p_19735_;
    }

    public void m_8119_() {
        block20: {
            float f;
            block21: {
                boolean flag1;
                boolean flag;
                block19: {
                    float f1;
                    int i;
                    super.m_8119_();
                    flag = this.isWaiting();
                    f = this.getRadius();
                    if (!this.f_19853_.f_46443_) break block19;
                    if (flag && this.f_19796_.m_188499_()) {
                        return;
                    }
                    ParticleOptions particleoptions = this.getParticle();
                    if (flag) {
                        i = 2;
                        f1 = 0.2f;
                    } else {
                        i = Mth.m_14167_((float)((float)Math.PI * f * f));
                        f1 = f;
                    }
                    for (int j = 0; j < i; ++j) {
                        double d7;
                        double d6;
                        double d5;
                        float f2 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        float f3 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f1;
                        double d0 = this.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
                        double d2 = this.m_20186_();
                        double d4 = this.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
                        if (particleoptions.m_6012_() != ParticleTypes.f_123811_) {
                            if (flag) {
                                d5 = 0.0;
                                d6 = 0.0;
                                d7 = 0.0;
                            } else {
                                d5 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                                d6 = 0.01f;
                                d7 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                            }
                        } else {
                            int k = flag && this.f_19796_.m_188499_() ? 0xFFFFFF : this.getColor();
                            d5 = (float)(k >> 16 & 0xFF) / 255.0f;
                            d6 = (float)(k >> 8 & 0xFF) / 255.0f;
                            d7 = (float)(k & 0xFF) / 255.0f;
                        }
                        this.f_19853_.m_7107_(particleoptions, d0, d2, d4, d5, d6, d7);
                    }
                    break block20;
                }
                if (this.f_19797_ >= this.waitTime + this.duration) {
                    this.m_146870_();
                    return;
                }
                boolean bl = flag1 = this.f_19797_ < this.waitTime;
                if (flag != flag1) {
                    this.setWaiting(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if ((f += this.radiusPerTick) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.f_19797_ % 5 != 0) break block20;
                this.victims.entrySet().removeIf(p_146784_ -> this.f_19797_ >= (Integer)p_146784_.getValue());
                if (!this.effects.isEmpty() || !this.brewEffects.isEmpty()) break block21;
                this.victims.clear();
                break block20;
            }
            List list1 = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_());
            if (list1.isEmpty()) break block20;
            for (LivingEntity livingentity : list1) {
                double d1;
                double d8;
                double d3;
                if (this.victims.containsKey(livingentity) || !livingentity.m_5801_() || !((d3 = (d8 = livingentity.m_20185_() - this.m_20185_()) * d8 + (d1 = livingentity.m_20189_() - this.m_20189_()) * d1) <= (double)(f * f))) continue;
                this.victims.put((Entity)livingentity, this.f_19797_ + this.reapplicationDelay);
                for (MobEffectInstance mobEffectInstance : this.effects) {
                    if (mobEffectInstance.m_19544_().m_8093_()) {
                        mobEffectInstance.m_19544_().m_19461_((Entity)this, (Entity)this.getOwner(), livingentity, mobEffectInstance.m_19564_(), 0.5);
                        continue;
                    }
                    livingentity.m_7292_(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_267696_(p_267926_ -> p_267926_ / 4), mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_()));
                }
                for (BrewEffectInstance brewEffectInstance : this.brewEffects) {
                    if (!brewEffectInstance.getEffect().canLinger()) continue;
                    brewEffectInstance.getEffect().applyInstantenousEffect(this, (Entity)this.getOwner(), livingentity, brewEffectInstance.getAmplifier(), 0.5);
                }
                if (this.radiusOnUse != 0.0f) {
                    if ((f += this.radiusOnUse) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.m_146870_();
                return;
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float p_19733_) {
        this.radiusOnUse = p_19733_;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float p_19739_) {
        this.radiusPerTick = p_19739_;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int p_146786_) {
        this.durationOnUse = p_146786_;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int p_19741_) {
        this.waitTime = p_19741_;
    }

    public void setOwner(@Nullable LivingEntity p_19719_) {
        this.owner = p_19719_;
        this.ownerUUID = p_19719_ == null ? null : p_19719_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag p_19727_) {
        int i;
        ListTag listtag;
        this.f_19797_ = p_19727_.m_128451_("Age");
        this.duration = p_19727_.m_128451_("Duration");
        this.waitTime = p_19727_.m_128451_("WaitTime");
        this.reapplicationDelay = p_19727_.m_128451_("ReapplicationDelay");
        this.durationOnUse = p_19727_.m_128451_("DurationOnUse");
        this.radiusOnUse = p_19727_.m_128457_("RadiusOnUse");
        this.radiusPerTick = p_19727_.m_128457_("RadiusPerTick");
        this.setRadius(p_19727_.m_128457_("Radius"));
        if (p_19727_.m_128403_("Owner")) {
            this.ownerUUID = p_19727_.m_128342_("Owner");
        }
        if (p_19727_.m_128425_("Particle", 8)) {
            try {
                this.setParticle(ParticleArgument.m_247456_((StringReader)new StringReader(p_19727_.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (p_19727_.m_128425_("Color", 99)) {
            this.setFixedColor(p_19727_.m_128451_("Color"));
        }
        if (p_19727_.m_128425_("Effects", 9)) {
            listtag = p_19727_.m_128437_("Effects", 10);
            this.effects.clear();
            for (i = 0; i < listtag.size(); ++i) {
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)listtag.m_128728_(i));
                if (mobeffectinstance == null) continue;
                this.addEffect(mobeffectinstance);
            }
        }
        if (p_19727_.m_128425_("BrewEffects", 9)) {
            listtag = p_19727_.m_128437_("BrewEffects", 10);
            this.brewEffects.clear();
            for (i = 0; i < listtag.size(); ++i) {
                BrewEffectInstance brewInstances = BrewEffectInstance.load(listtag.m_128728_(i));
                if (brewInstances == null) continue;
                this.addBrewEffect(brewInstances);
            }
        }
    }

    protected void m_7380_(CompoundTag p_19737_) {
        ListTag listtag;
        p_19737_.m_128405_("Age", this.f_19797_);
        p_19737_.m_128405_("Duration", this.duration);
        p_19737_.m_128405_("WaitTime", this.waitTime);
        p_19737_.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        p_19737_.m_128405_("DurationOnUse", this.durationOnUse);
        p_19737_.m_128350_("RadiusOnUse", this.radiusOnUse);
        p_19737_.m_128350_("RadiusPerTick", this.radiusPerTick);
        p_19737_.m_128350_("Radius", this.getRadius());
        p_19737_.m_128359_("Particle", this.getParticle().m_5942_());
        if (this.ownerUUID != null) {
            p_19737_.m_128362_("Owner", this.ownerUUID);
        }
        if (this.fixedColor) {
            p_19737_.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_19737_.m_128365_("Effects", (Tag)listtag);
        }
        if (!this.brewEffects.isEmpty()) {
            listtag = new ListTag();
            for (BrewEffectInstance brewEffectInstance : this.brewEffects) {
                listtag.add((Object)brewEffectInstance.save(new CompoundTag()));
            }
            p_19737_.m_128365_("BrewEffects", (Tag)listtag);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

