/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class SummonCircleVariant
extends Entity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(SummonCircleVariant.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(SummonCircleVariant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/summon_earth/1.png"));
        map.put(1, Goety.location("textures/entity/summon_earth/2.png"));
        map.put(2, Goety.location("textures/entity/summon_earth/3.png"));
        map.put(3, Goety.location("textures/entity/summon_earth/4.png"));
        map.put(4, Goety.location("textures/entity/summon_earth/5.png"));
        map.put(5, Goety.location("textures/entity/summon_earth/6.png"));
        map.put(6, Goety.location("textures/entity/summon_earth/7.png"));
        map.put(7, Goety.location("textures/entity/summon_earth/8.png"));
        map.put(8, Goety.location("textures/entity/summon_earth/9.png"));
        map.put(9, Goety.location("textures/entity/summon_earth/10.png"));
    });
    public Entity entity;
    public int lifeSpan = 20;

    public SummonCircleVariant(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public SummonCircleVariant(Level pLevel, Vec3 pPos, Entity pEntity, LivingEntity pOwner) {
        this((EntityType)ModEntityType.SUMMON_FIERY.get(), pLevel);
        this.m_6034_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_);
        this.entity = pEntity;
        this.setTrueOwner(pOwner);
    }

    public SummonCircleVariant(Level pLevel, BlockPos pPos, Entity pEntity, LivingEntity pOwner) {
        this((EntityType)ModEntityType.SUMMON_FIERY.get(), pLevel);
        this.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
        this.entity = pEntity;
        this.setTrueOwner(pOwner);
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        Entity entity = EntityType.m_20645_((CompoundTag)pCompound, (Level)this.f_19853_, p_58740_ -> p_58740_);
        if (entity != null) {
            this.entity = entity;
        }
        if (pCompound.m_128403_("Owner")) {
            this.setOwnerId(pCompound.m_128342_("Owner"));
        }
        this.lifeSpan = pCompound.m_128451_("lifeSpan");
        this.setAnimation(pCompound.m_128451_("Animation"));
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.entity != null) {
            this.entity.m_20223_(pCompound);
        }
        if (this.getOwnerId() != null) {
            pCompound.m_128362_("Owner", this.getOwnerId());
        }
        pCompound.m_128405_("lifeSpan", this.lifeSpan);
        pCompound.m_128405_("Animation", this.getAnimation());
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getAnimation(), TEXTURE_BY_TYPE.get(0));
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setTrueOwner(LivingEntity livingEntity) {
        this.setOwnerId(livingEntity.m_20148_());
    }

    public void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public int getLifeSpan() {
        if (this.lifeSpan == 0) {
            return 20;
        }
        return this.lifeSpan;
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        int frame = this.lifeSpan / TEXTURE_BY_TYPE.size();
        if (this.f_19797_ > frame && this.f_19797_ % frame == 0 && this.getAnimation() < 9) {
            this.setAnimation(this.getAnimation() + 1);
        }
        if (!this.m_20068_()) {
            MobUtil.moveDownToGround(this);
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.f_19797_ == this.getLifeSpan() && this.entity != null) {
                this.entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Entity entity = this.entity;
                if (entity instanceof TamableAnimal) {
                    TamableAnimal tamableAnimal = (TamableAnimal)entity;
                    if (this.getOwnerId() != null) {
                        tamableAnimal.m_21816_(this.getOwnerId());
                    }
                }
                if ((entity = this.entity) instanceof IOwned) {
                    IOwned owned = (IOwned)entity;
                    if (this.getTrueOwner() != null) {
                        owned.setTrueOwner(this.getTrueOwner());
                    }
                }
                if ((entity = this.entity) instanceof Mob) {
                    Mob mob1;
                    LivingEntity livingEntity;
                    Mob mob = (Mob)entity;
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverWorld, (DifficultyInstance)this.f_19853_.m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                    if (this.getTrueOwner() != null && (livingEntity = this.getTrueOwner()) instanceof Mob && (mob1 = (Mob)livingEntity).m_5448_() != null) {
                        mob.m_6710_(mob1.m_5448_());
                    }
                }
                serverWorld.m_7967_(this.entity);
            }
            if (this.f_19797_ < this.getLifeSpan()) {
                double d0 = this.m_20185_() + this.f_19796_.m_188500_();
                double d1 = this.m_20186_();
                double d2 = this.m_20189_() + this.f_19796_.m_188500_();
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0, 0.0, 0.0, 0.0, 0.5);
            }
        }
        if (this.f_19797_ >= this.getLifeSpan()) {
            this.m_146870_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

