/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.common.entities.util.CastSpellTrap;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningBoltPacket;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SpellExplosion;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class TridentStorm
extends CastSpellTrap {
    public boolean instant;
    public int warmUp = MathHelper.secondsToTicks(2);
    public int tickTime;
    public int delay;
    public AnimationState mainAnimationState = new AnimationState();

    public TridentStorm(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.delay = worldIn.m_213780_().m_188503_(61);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Instant", this.instant);
        compound.m_128405_("WarmUp", this.warmUp);
        compound.m_128405_("TickTime", this.tickTime);
        compound.m_128405_("Delay", this.delay);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Instant")) {
            this.instant = compound.m_128471_("Instant");
        }
        if (compound.m_128441_("WarmUp")) {
            this.warmUp = compound.m_128451_("WarmUp");
        }
        if (compound.m_128441_("TickTime")) {
            this.tickTime = compound.m_128451_("TickTime");
        }
        if (compound.m_128441_("Delay")) {
            this.delay = compound.m_128451_("Delay");
        }
    }

    public void setWarmUp(int warmUp) {
        this.warmUp = warmUp;
    }

    public int getWarmUp() {
        return this.warmUp;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.tickTime;
        if (!this.f_19853_.f_46443_) {
            int time;
            int n = time = this.instant ? 0 : this.getWarmUp();
            if (this.tickTime >= time + this.delay && !this.isActivated()) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.setActivated(true);
            }
            if (this.tickTime == time + this.delay + 5) {
                LivingEntity livingEntity3;
                float damage = ((Double)SpellConfig.TridentStormDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                float radius = 2.0f;
                ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
                AABB aabb = EntityType.f_20487_.m_20585_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
                for (Entity entity : this.f_19853_.m_45976_(Entity.class, aabb.m_82377_(0.0, 16.0, 0.0))) {
                    LivingEntity livingEntity2 = MobUtil.getLivingTarget(entity);
                    if (livingEntity2 == null) continue;
                    if (this.m_269323_() != null) {
                        if (livingEntity2 == this.m_269323_() || MobUtil.areAllies((Entity)this.m_269323_(), (Entity)livingEntity2)) continue;
                        targets.add(livingEntity2);
                        continue;
                    }
                    targets.add(livingEntity2);
                }
                if (!targets.isEmpty()) {
                    for (LivingEntity livingEntity3 : targets) {
                        livingEntity3.m_6469_(this.m_269291_().m_269525_((Entity)this, (Entity)this.m_269323_()), 8.0f + this.getExtraDamage());
                    }
                }
                new SpellExplosion(this.f_19853_, this, ModDamageSource.lightning(this, (Entity)this.m_269323_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), radius, damage + this.getExtraDamage());
                livingEntity3 = this.f_19853_;
                if (livingEntity3 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)livingEntity3;
                    ColorUtil colorUtil = ColorUtil.WHITE;
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, radius, 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                ModNetwork.sendToALL(new SLightningBoltPacket(this.m_20182_().m_82520_(0.0, 250.0, 0.0), this.m_20182_(), 5));
                for (int i = 0; i < 16; ++i) {
                    Vec3 vec3 = this.m_20182_();
                    Vec3 vec31 = vec3.m_82520_(this.f_19796_.m_188500_(), 1.0, this.f_19796_.m_188500_());
                    ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 2));
                }
            }
            if (this.tickTime >= time + MathHelper.secondsToTicks(2) + this.delay) {
                this.m_146870_();
            }
        }
    }

    public void m_7822_(byte p_36935_) {
        super.m_7822_(p_36935_);
        if (p_36935_ == 4) {
            this.setActivated(true);
            this.mainAnimationState.m_216977_(this.f_19797_);
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.TRIDENT_STORM_EXPLODE.get(), this.m_5720_(), 2.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

