/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.events;

import com.Polarice3.Goety.api.entities.IGolem;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.SnapWartsBlock;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.illager.AllyIrk;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.world.structures.ModStructureTags;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.NoKnockBackDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServantUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goety", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RobeEvents {
    @SubscribeEvent
    public static void LivingEffects(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity != null && !livingEntity.f_19853_.f_46443_) {
            if (((Boolean)MobsConfig.CompatMinionHeal.get()).booleanValue() && livingEntity instanceof OwnableEntity) {
                Player owner;
                OwnableEntity ownable = (OwnableEntity)livingEntity;
                if (!(livingEntity instanceof IServant) && ownable.m_21805_() != null && (owner = livingEntity.f_19853_.m_46003_(ownable.m_21805_())) != null && MiscCapHelper.getNoHealTime(livingEntity) <= 0) {
                    ServantUtil.healServant(owner, livingEntity);
                }
            }
            if (!(!((Boolean)MobsConfig.NecroSetDebuff.get()).booleanValue() && !((Boolean)MobsConfig.NamelessSetDebuff.get()).booleanValue() || MobUtil.getOwner((Entity)livingEntity) == null || livingEntity.m_6336_() == MobType.f_21641_ || livingEntity instanceof AbstractGolem || livingEntity instanceof IGolem || livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.NECRO_NO_DEBUFF))) {
                boolean flag = false;
                int amp = 0;
                if (((Boolean)MobsConfig.NecroSetDebuff.get()).booleanValue() && (CuriosFinder.hasNecroCrown(MobUtil.getOwner((Entity)livingEntity)) || CuriosFinder.hasNecroCape(MobUtil.getOwner((Entity)livingEntity)))) {
                    if (CuriosFinder.hasNecroSet(MobUtil.getOwner((Entity)livingEntity))) {
                        amp += 2;
                    }
                    flag = true;
                }
                if (((Boolean)MobsConfig.NamelessSetDebuff.get()).booleanValue() && (CuriosFinder.hasNamelessCrown(MobUtil.getOwner((Entity)livingEntity)) || CuriosFinder.hasNamelessCrown(MobUtil.getOwner((Entity)livingEntity)))) {
                    if (CuriosFinder.hasNamelessSet(MobUtil.getOwner((Entity)livingEntity))) {
                        amp += 2;
                    }
                    flag = true;
                }
                if (flag) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1 + amp));
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 20, 2 + amp));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBreakingBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (CuriosFinder.hasWarlockRobe((LivingEntity)player) && event.getState().m_60713_((Block)ModBlocks.SNAP_WARTS.get()) && (Integer)event.getState().m_61143_((Property)SnapWartsBlock.AGE) >= 2 && !player.f_19853_.f_46443_ && !player.m_150110_().f_35937_ && player.m_217043_().m_188501_() <= 0.25f) {
            Block.m_49881_((BlockState)event.getState(), (Level)player.f_19853_, (BlockPos)event.getPos(), null, (Entity)player, (ItemStack)player.m_21211_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void HurtEvent(LivingHurtEvent event) {
        Player player;
        float resistance;
        LivingEntity victim = event.getEntity();
        if (CuriosFinder.hasFrostRobes(victim) && (ModDamageSource.freezeAttacks(event.getSource()) || event.getSource().m_269533_(DamageTypeTags.f_268419_))) {
            resistance = 1.0f - (float)((Integer)ItemConfig.FrostRobeResistance.get()).intValue() / 100.0f;
            event.setAmount(event.getAmount() * resistance);
        }
        if (CuriosFinder.hasAbyssRobes(victim) && event.getSource().m_269533_(DamageTypeTags.f_268581_)) {
            if (victim.m_20146_() <= 0) {
                victim.m_20301_(20);
            }
            event.setAmount(event.getAmount() * 0.5f);
        }
        if (CuriosFinder.hasNetherRobe(victim)) {
            resistance = 1.0f - (float)((Integer)ItemConfig.NetherRobeResistance.get()).intValue() / 100.0f;
            if (resistance <= 0.0f) {
                event.setCanceled(true);
            } else {
                if (event.getSource().m_269533_(DamageTypeTags.f_268745_) || ModDamageSource.isMagicFire(event.getSource())) {
                    event.setAmount(event.getAmount() * resistance);
                }
                if (ModDamageSource.hellfireAttacks(event.getSource())) {
                    resistance = Math.max(0.75f, resistance);
                    event.setAmount(event.getAmount() * resistance);
                }
            }
        }
        if (CuriosFinder.hasCurio(victim, (Item)ModItems.GRAND_TURBAN.get()) && victim instanceof Player && SEHelper.getSoulsAmount(player = (Player)victim, (Integer)ItemConfig.ItemsRepairAmount.get())) {
            int irks = victim.f_19853_.m_45976_(AllyIrk.class, victim.m_20191_().m_82400_(32.0)).size();
            if ((victim.f_19853_.f_46441_.m_188499_() || victim.m_21223_() <= victim.m_21233_() / 2.0f) && irks < 16) {
                AllyIrk irk = new AllyIrk((EntityType<? extends AllyIrk>)((EntityType)ModEntityType.ALLY_IRK.get()), victim.f_19853_);
                irk.m_6034_(victim.m_20185_(), victim.m_20186_(), victim.m_20189_());
                irk.setLimitedLife(MobUtil.getSummonLifespan(victim.f_19853_));
                irk.setTrueOwner(victim);
                if (victim.f_19853_.m_7967_((Entity)irk)) {
                    SEHelper.decreaseSouls(player, (Integer)ItemConfig.ItemsRepairAmount.get());
                }
            }
        }
        if (CuriosFinder.hasCurio(victim, (Item)ModItems.GRAND_ROBE.get()) && MobUtil.isSpellCasting(victim)) {
            event.setAmount(event.getAmount() / 2.0f);
        }
        float damage = event.getAmount();
        if (CuriosFinder.hasUnholyHat(victim)) {
            if (victim.f_19853_.m_46472_() == Level.f_46429_) {
                damage /= 2.0f;
            }
            if (!event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
                damage = Math.min(damage, ((Double)AttributesConfig.ApostleDamageCap.get()).floatValue());
            }
            event.setAmount(damage);
        }
        if (CuriosFinder.hasUnholyRobe(victim)) {
            float resistance2 = 1.0f - (float)((Integer)ItemConfig.NetherRobeResistance.get()).intValue() / 100.0f;
            if (ModDamageSource.hellfireAttacks(event.getSource())) {
                resistance2 = Math.max(0.75f, resistance2);
                damage *= resistance2;
            }
            event.setAmount(damage);
        }
        if (CuriosFinder.hasCurio(victim, (Item)ModItems.STORM_ROBE.get())) {
            if (ModDamageSource.shockAttacks(event.getSource()) || event.getSource().m_276093_(DamageTypes.f_268450_)) {
                float resistance3 = 1.0f - (float)((Integer)ItemConfig.StormRobeResistance.get()).intValue() / 100.0f;
                event.setAmount(event.getAmount() * resistance3);
            }
            if (event.getSource().m_276093_(DamageTypes.f_268450_)) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300));
            }
        }
        if (!(!CuriosFinder.hasWitchRobe(victim) && !CuriosFinder.hasWarlockRobe(victim) || !event.getSource().m_269533_(DamageTypeTags.f_268731_) || LichdomHelper.isLich((Entity)victim) && ((Boolean)MainConfig.LichMagicResist.get()).booleanValue())) {
            float resistance4 = 1.0f - (float)((Integer)ItemConfig.WitchRobeResistance.get()).intValue() / 100.0f;
            if (CuriosFinder.hasWarlockRobe(victim)) {
                resistance4 = 1.0f - (float)((Integer)ItemConfig.WarlockRobeResistance.get()).intValue() / 100.0f;
            }
            event.setAmount(event.getAmount() * resistance4);
        }
    }

    @SubscribeEvent
    public static void AttackEvent(LivingAttackEvent event) {
        LivingEntity victim = event.getEntity();
        Entity source = event.getSource().m_7639_();
        Entity direct = event.getSource().m_7640_();
        if (!event.getEntity().f_19853_.f_46443_) {
            if (event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                NoKnockBackDamageSource damageSource;
                LivingEntity source1 = null;
                Entity direct1 = direct;
                if (source instanceof LivingEntity) {
                    LivingEntity living1;
                    source1 = living1 = (LivingEntity)source;
                } else if (MobUtil.getOwner(source) != null) {
                    source1 = MobUtil.getOwner(source);
                }
                DamageSource damageSource2 = event.getSource();
                if (damageSource2 instanceof NoKnockBackDamageSource) {
                    damageSource = (NoKnockBackDamageSource)damageSource2;
                    Entity entity = damageSource.getOwner();
                    if (entity instanceof LivingEntity) {
                        LivingEntity living1;
                        source1 = living1 = (LivingEntity)entity;
                    } else if (MobUtil.getOwner(damageSource.getOwner()) != null) {
                        source1 = MobUtil.getOwner(damageSource.getOwner());
                    }
                    direct1 = damageSource.m_7640_();
                }
                if (CuriosFinder.hasNetherRobe(source1) && (victim.m_6673_(event.getSource()) || victim.m_21023_(MobEffects.f_19607_))) {
                    damageSource = ModDamageSource.magicFireBreath(direct1, (Entity)source1);
                    if (CuriosFinder.hasUnholyRobe(source1)) {
                        damageSource = ModDamageSource.hellfire(direct1, (Entity)source1);
                    }
                    victim.m_6469_((DamageSource)damageSource, event.getAmount());
                    event.setCanceled(true);
                }
            }
            if (event.getAmount() > 0.0f && (Integer)ItemConfig.VoidRobeTeleportChance.get() > 0 && CuriosFinder.hasVoidRobe(victim) && !victim.m_6673_(event.getSource()) && EntitySelector.f_20406_.test(victim)) {
                double d2;
                double d1;
                double d0;
                float chance = (float)((Integer)ItemConfig.VoidRobeTeleportChance.get()).intValue() / 100.0f;
                if (victim.m_217043_().m_188501_() <= chance && MobUtil.teleport(victim, d0 = victim.m_20185_() + (victim.m_217043_().m_188500_() - 0.5) * 64.0, d1 = victim.m_20186_(), d2 = victim.m_20189_() + (victim.m_217043_().m_188500_() - 0.5) * 64.0) && ((Boolean)ItemConfig.VoidRobeTeleportDamageCancel.get()).booleanValue()) {
                    event.setCanceled(true);
                }
            }
        }
        if (source instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)source;
            if (CuriosFinder.neutralNetherSet(victim) && magmaCube.m_21188_() != victim) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void TargetEvents(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity target = event.getOriginalTarget();
        if (attacker instanceof Mob) {
            Mob mobAttacker = (Mob)attacker;
            if (target != null && target instanceof Player) {
                if (MobUtil.isWitchType((Entity)mobAttacker) && CuriosFinder.isWitchFriendly(target)) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
                if (CuriosFinder.neutralNecroSet(target) || CuriosFinder.neutralNamelessSet(target)) {
                    boolean undead = CuriosFinder.validNecroUndead((LivingEntity)mobAttacker);
                    Level level = target.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (((Boolean)MobsConfig.HostileCryptUndead.get()).booleanValue() && BlockFinder.findStructure(serverLevel, target.m_20183_(), ModStructureTags.NECRO_HOSTILE) && !CuriosFinder.neutralNamelessSet(target)) {
                            undead = false;
                        }
                    }
                    if (undead || CuriosFinder.neutralNamelessSet(target) && CuriosFinder.validNamelessUndead((LivingEntity)mobAttacker)) {
                        if (mobAttacker.m_21188_() != target) {
                            if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                                event.setNewTarget(null);
                            } else {
                                event.setCanceled(true);
                            }
                        } else {
                            mobAttacker.m_6703_(target);
                        }
                    }
                }
                if (CuriosFinder.neutralAbyssSet(target) && CuriosFinder.validAbyssMob((LivingEntity)mobAttacker)) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
                if (CuriosFinder.neutralFrostSet(target) && CuriosFinder.validFrostMob((LivingEntity)mobAttacker)) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
                if (CuriosFinder.neutralNetherSet(target) && CuriosFinder.validNetherMob((LivingEntity)mobAttacker)) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
                if ((CuriosFinder.hasUnholyRobe(target) || CuriosFinder.hasUnholyHat(target)) && (mobAttacker instanceof Ghast || mobAttacker instanceof Blaze || mobAttacker instanceof MagmaCube)) {
                    if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                        event.setNewTarget(null);
                    } else {
                        event.setCanceled(true);
                    }
                }
                if (CuriosFinder.neutralVoidSet(target) && CuriosFinder.validVoidMob((LivingEntity)mobAttacker)) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
                if (CuriosFinder.neutralWildSet(target) && CuriosFinder.validWildMob((LivingEntity)mobAttacker)) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
                if (CuriosFinder.hasWarlockRobe(event.getOriginalTarget()) && mobAttacker.m_6336_() == MobType.f_21642_) {
                    if (mobAttacker.m_21188_() != target) {
                        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET) {
                            event.setNewTarget(null);
                        } else {
                            event.setCanceled(true);
                        }
                    } else {
                        mobAttacker.m_6703_(target);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void VisibilityEvent(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.getLookingEntity() instanceof LivingEntity && entity instanceof Player && entity.m_20145_() && CuriosFinder.hasCurio(entity, (Item)ModItems.ILLUSION_ROBE.get())) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public static void OnLivingFall(LivingFallEvent event) {
        if (CuriosFinder.hasWindyRobes(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void PotionApplicationEvents(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == GoetyEffects.FREEZING.get() && CuriosFinder.hasFrostRobes(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == GoetyEffects.BURN_HEX.get() && (CuriosFinder.hasUnholyHat(event.getEntity()) || CuriosFinder.hasUnholyRobe(event.getEntity()))) {
            event.setResult(Event.Result.DENY);
        }
        if ((event.getEffectInstance().m_19544_() == MobEffects.f_19614_ || event.getEffectInstance().m_19544_() == GoetyEffects.ACID_VENOM.get()) && CuriosFinder.hasWildRobe(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == GoetyEffects.VOID_TOUCHED.get() && CuriosFinder.hasVoidRobe(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEffectInstance().m_19544_() == MobEffects.f_19610_ && CuriosFinder.hasIllusionRobe(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }
}

