/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.inventory;

import com.Polarice3.Goety.common.inventory.ModSaveInventory;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.utils.CuriosFinder;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;

public class WitchRobeInventory
extends SimpleContainer
implements MenuProvider {
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int brewTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    private int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> WitchRobeInventory.this.brewTime;
                case 1 -> WitchRobeInventory.this.fuel;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    WitchRobeInventory.this.brewTime = pValue;
                    break;
                }
                case 1: {
                    WitchRobeInventory.this.fuel = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int inventoryNum;
    private int increaseSpeed;
    private double rest;
    private LivingEntity livingEntity;

    public WitchRobeInventory(CompoundTag nbt) {
        super(new ItemStack[0]);
        this.load(nbt);
    }

    public WitchRobeInventory() {
        super(new ItemStack[0]);
    }

    public int getInventoryNum() {
        return this.inventoryNum;
    }

    public void setInventoryNum(int inventoryNum) {
        this.inventoryNum = inventoryNum;
        this.m_6596_();
    }

    public int getIncreaseSpeed() {
        return this.increaseSpeed;
    }

    public void setIncreaseSpeed(int increaseSpeed) {
        this.increaseSpeed = increaseSpeed;
        this.m_6596_();
    }

    public double getRest() {
        return this.rest;
    }

    public void setRest(double newrest) {
        this.rest = newrest;
        this.m_6596_();
    }

    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    public void setLivingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.m_6596_();
    }

    public void tick() {
        Level level;
        double x = (double)(this.increaseSpeed * 720) / 100.0;
        int time = (int)Math.floor(1.0 + x + this.rest);
        this.setRest(1.0 + x + this.rest - (double)time);
        if (this.getLivingEntity() != null && CuriosFinder.hasWitchHat(this.getLivingEntity()) && this.fuel < 20 && (level = this.getLivingEntity().f_19853_).m_46462_() && !level.m_46471_() && level.m_45527_(this.getLivingEntity().m_20183_()) && this.getLivingEntity().f_19797_ % 100 == 0 && level.f_46441_.m_188501_() <= 0.25f) {
            ++this.fuel;
            this.m_6596_();
        }
        for (int a = 0; a < time; ++a) {
            ItemStack itemstack = (ItemStack)this.items.get(4);
            if (this.fuel <= 0 && itemstack.m_41753_() && !itemstack.m_41619_()) {
                this.fuel = 20;
                itemstack.m_41774_(1);
                this.m_6596_();
            }
            boolean flag = this.isBrewable();
            boolean flag1 = this.brewTime > 0;
            ItemStack itemstack1 = (ItemStack)this.items.get(3);
            if (flag1) {
                boolean flag2;
                --this.brewTime;
                boolean bl = flag2 = this.brewTime == 0;
                if (flag2 && flag) {
                    this.doBrew();
                    this.m_6596_();
                } else if (!flag) {
                    this.brewTime = 0;
                    this.m_6596_();
                } else if (this.ingredient != itemstack1.m_41720_()) {
                    this.brewTime = 0;
                    this.m_6596_();
                }
            } else if (flag && this.fuel > 0) {
                --this.fuel;
                this.brewTime = 400;
                this.ingredient = itemstack1.m_41720_();
                this.m_6596_();
            }
            boolean[] aboolean = this.getPotionBits();
            if (Arrays.equals(aboolean, this.lastPotionCount)) continue;
            this.lastPotionCount = aboolean;
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    public boolean isBrewable() {
        ItemStack itemstack = (ItemStack)this.items.get(3);
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(this.items, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = (ItemStack)this.items.get(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    private void doBrew() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.items)) {
            return;
        }
        ItemStack itemstack = (ItemStack)this.items.get(3);
        BrewingRecipeRegistry.brewPotions(this.items, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
        ForgeEventFactory.onPotionBrewed(this.items);
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                itemstack = itemstack1;
            }
        } else {
            itemstack.m_41774_(1);
        }
        this.playSound(SoundEvents.f_11772_);
        this.items.set(3, (Object)itemstack);
    }

    public static boolean isAirOrEmpty(ItemStack itemStack) {
        return itemStack.m_41619_() || itemStack.m_150930_(Items.f_41852_);
    }

    public boolean inputEmpty() {
        return WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(0)) || WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(1)) || WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(2));
    }

    public boolean isWaterOrEmpty() {
        boolean[] flag = new boolean[]{false, false, false};
        if (!this.inputEmpty()) {
            flag[0] = PotionUtils.m_43579_((ItemStack)((ItemStack)this.items.get(0))) == Potions.f_43599_ || WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(0));
            flag[1] = PotionUtils.m_43579_((ItemStack)((ItemStack)this.items.get(1))) == Potions.f_43599_ || WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(1));
            flag[2] = PotionUtils.m_43579_((ItemStack)((ItemStack)this.items.get(2))) == Potions.f_43599_ || WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(2));
        }
        return flag[0] && flag[1] && flag[2];
    }

    public boolean needsFuel() {
        return this.fuel <= 5;
    }

    public void addFuel(ItemStack itemStack) {
        if (this.m_7013_(4, itemStack) && ((ItemStack)this.items.get(4)).m_41613_() != 64) {
            if (((ItemStack)this.items.get(4)).m_41619_()) {
                ItemStack newItem = itemStack.m_41777_();
                newItem.m_41764_(1);
                this.items.set(4, (Object)newItem);
            } else {
                ((ItemStack)this.items.get(4)).m_41769_(1);
            }
            itemStack.m_41774_(1);
            this.playSound(SoundEvents.f_11874_);
            this.m_6596_();
        }
    }

    public void autoAddWaterBottles(ItemStack itemStack) {
        if (itemStack.m_150930_(Items.f_42590_) && this.inputEmpty()) {
            this.addBottles(itemStack, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
            this.playSound(SoundEvents.f_11770_);
        }
    }

    public boolean sameItem(ItemStack first, ItemStack second) {
        return !second.m_41619_() && first.m_150930_(second.m_41720_());
    }

    public void addBottlesOrCatalyst(ItemStack itemStack) {
        if (this.m_7013_(3, itemStack) && (WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(3)) || this.sameItem(itemStack, (ItemStack)this.items.get(3)) && ((ItemStack)this.items.get(3)).m_41613_() < 64)) {
            this.items.set(3, (Object)itemStack.m_41777_());
            itemStack.m_41774_(1);
            this.playSound(SoundEvents.f_11675_);
            this.m_6596_();
        } else if (this.m_7013_(0, itemStack) || this.m_7013_(1, itemStack) || this.m_7013_(2, itemStack)) {
            this.addBottles(itemStack, itemStack.m_41777_());
        }
    }

    public void addBottles(ItemStack input, ItemStack newStack) {
        for (int i = 0; i < 3; ++i) {
            if (!WitchRobeInventory.isAirOrEmpty((ItemStack)this.items.get(i)) || input.m_41613_() <= 0) continue;
            this.items.set(i, (Object)newStack);
            input.m_41774_(1);
            this.playSound(SoundEvents.f_11675_);
            this.m_6596_();
        }
    }

    public void extractPotions() {
        for (int i = 0; i < 3; ++i) {
            LivingEntity livingEntity;
            if (((ItemStack)this.items.get(i)).m_41619_() || !((livingEntity = this.getLivingEntity()) instanceof Player)) continue;
            Player player = (Player)livingEntity;
            if (player.m_150109_().m_36054_((ItemStack)this.items.get(i))) {
                this.playSound(SoundEvents.f_12019_);
            } else {
                BlockPos blockPos = this.getLivingEntity().m_20183_();
                ItemEntity itemEntity = new ItemEntity(this.getLivingEntity().f_19853_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)this.items.get(i));
                this.getLivingEntity().f_19853_.m_7967_((Entity)itemEntity);
                this.playSound(SoundEvents.f_12016_);
            }
            ((ItemStack)this.items.get(i)).m_41774_(1);
        }
        this.m_6596_();
    }

    public void playSound(SoundEvent soundEvent) {
        if (this.getLivingEntity() != null) {
            LivingEntity livingEntity;
            this.getLivingEntity().m_216990_(soundEvent);
            if (!this.getLivingEntity().f_19853_.f_46443_ && (livingEntity = this.getLivingEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ModNetwork.sendTo((Player)serverPlayer, new SPlayPlayerSoundPacket(soundEvent, 1.0f, 1.0f));
            }
        }
    }

    public void load(CompoundTag p_230337_2_) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.items);
        this.brewTime = p_230337_2_.m_128448_("BrewTime");
        this.fuel = p_230337_2_.m_128445_("Fuel");
        this.inventoryNum = p_230337_2_.m_128451_("InventoryNum");
        this.increaseSpeed = p_230337_2_.m_128451_("increaseSpeed");
        this.rest = p_230337_2_.m_128459_("rest");
    }

    public CompoundTag save(CompoundTag pCompound) {
        pCompound.m_128376_("BrewTime", (short)this.brewTime);
        ContainerHelper.m_18973_((CompoundTag)pCompound, this.items);
        pCompound.m_128344_("Fuel", (byte)this.fuel);
        pCompound.m_128405_("InventoryNum", this.inventoryNum);
        pCompound.m_128405_("increaseSpeed", this.increaseSpeed);
        pCompound.m_128347_("rest", this.rest);
        return pCompound;
    }

    public void m_6596_() {
        ModSaveInventory.getInstance().m_77762_();
    }

    public ItemStack m_8020_(int pIndex) {
        return pIndex >= 0 && pIndex < this.items.size() ? (ItemStack)this.items.get(pIndex) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        if (pIndex >= 0 && pIndex < this.items.size()) {
            this.items.set(pIndex, (Object)pStack);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)pStack);
        }
        Item item = pStack.m_41720_();
        if (pIndex == 4) {
            return item == Items.f_42593_;
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)pStack) && this.m_8020_(pIndex).m_41619_();
    }

    public void m_6211_() {
        this.items.clear();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"item.goety.witch_robe.brew");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pId, Inventory pPlayer, Player p_createMenu_3_) {
        return new BrewingStandMenu(pId, pPlayer, (Container)this, this.dataAccess);
    }
}

