/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.brew;

import com.Polarice3.Goety.common.entities.projectiles.ThrownBrew;
import com.Polarice3.Goety.common.items.brew.BrewItem;
import com.Polarice3.Goety.common.items.brew.ThrowableBrewItem;
import com.Polarice3.Goety.common.items.capability.WitchStaffItemCapability;
import com.Polarice3.Goety.common.items.handler.WitchStaffItemHandler;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class WitchStaff
extends Item {
    public WitchStaff(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (WitchStaff.getThrowBrew(itemstack) != null) {
            if (!worldIn.f_46443_) {
                ThrownBrew thrownBrew = new ThrownBrew(worldIn, (LivingEntity)playerIn);
                thrownBrew.m_37446_(itemstack);
                float velocity = 0.5f + BrewUtils.getVelocity(itemstack);
                thrownBrew.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, velocity, 1.0f);
                if (worldIn.m_7967_((Entity)thrownBrew)) {
                    SEHelper.addCooldown(playerIn, this, MathHelper.secondsToTicks(1));
                }
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!playerIn.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
        }
        if (WitchStaff.getDrinkBrew(itemstack) != null) {
            playerIn.m_6672_(handIn);
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        super.m_5922_(stack, worldIn, entityLiving);
        if (WitchStaff.getDrinkBrew(stack) != null) {
            WitchStaff.getDrinkBrew(stack).m_5922_(WitchStaff.getBrew(stack), worldIn, entityLiving);
        }
        return stack;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        if (WitchStaff.getDrinkBrew(stack) != null) {
            return WitchStaff.getDrinkBrew(stack).m_8105_(WitchStaff.getBrew(stack));
        }
        return 0;
    }

    public static ItemStack getBrew(ItemStack itemstack) {
        WitchStaffItemHandler handler = WitchStaffItemHandler.get(itemstack);
        return handler.getSlot();
    }

    public static BrewItem getDrinkBrew(ItemStack itemStack) {
        Item item;
        if (WitchStaff.getBrew(itemStack) != null && !WitchStaff.getBrew(itemStack).m_41619_() && (item = WitchStaff.getBrew(itemStack).m_41720_()) instanceof BrewItem) {
            BrewItem brewItem = (BrewItem)item;
            return brewItem;
        }
        return null;
    }

    public static ThrowableBrewItem getThrowBrew(ItemStack itemStack) {
        Item item;
        if (WitchStaff.getBrew(itemStack) != null && !WitchStaff.getBrew(itemStack).m_41619_() && (item = WitchStaff.getBrew(itemStack).m_41720_()) instanceof ThrowableBrewItem) {
            ThrowableBrewItem brewItem = (ThrowableBrewItem)item;
            return brewItem;
        }
        return null;
    }

    public static IItemHandler getItemHandler(ItemStack itemStack) {
        return (IItemHandler)itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalArgumentException("Expected an item handler for the Brew item, but " + itemStack + " does not expose an item handler."));
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt;
        IItemHandler iitemHandler = WitchStaff.getItemHandler(stack);
        CompoundTag compoundTag = nbt = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
        if (iitemHandler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
            nbt.m_128365_("cap", (Tag)itemHandler.serializeNBT());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_(null);
        } else {
            IItemHandler iitemHandler = WitchStaff.getItemHandler(stack);
            if (iitemHandler instanceof ItemStackHandler) {
                ItemStackHandler itemHandler = (ItemStackHandler)iitemHandler;
                itemHandler.deserializeNBT(nbt.m_128469_("cap"));
            }
            stack.m_41751_(nbt);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return new WitchStaffItemCapability(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && slotChanged;
    }
}

