/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.items.ItemBase;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.utils.EntityFinder;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TransferScroll
extends ItemBase {
    public static final String TAG_ENTITY = "Servant";

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LivingEntity livingEntity;
        if (!worldIn.f_46443_ && stack.m_41783_() != null && ((livingEntity = TransferScroll.getSummon(stack.m_41783_())) == null || livingEntity.m_21224_())) {
            stack.m_41783_().m_128473_(TAG_ENTITY);
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity) {
            IOwned owned;
            LivingEntity target = (LivingEntity)entity;
            if (stack.m_41720_() == this && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == player && !TransferScroll.hasSummon(stack)) {
                CompoundTag compoundTag = new CompoundTag();
                if (stack.m_41782_()) {
                    compoundTag = stack.m_41783_();
                }
                TransferScroll.setSummon(compoundTag, target);
                stack.m_41751_(compoundTag);
                player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
            }
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == this && TransferScroll.hasSummon(itemstack)) {
            LivingEntity summon = TransferScroll.getSummon(itemstack);
            if (itemstack.m_41783_() != null && summon instanceof IOwned) {
                IOwned owned = (IOwned)summon;
                if (owned.getTrueOwner() == player) {
                    if (player.m_6144_() || player.m_6047_()) {
                        itemstack.m_41783_().m_128473_(TAG_ENTITY);
                    }
                } else if (RitualRequirements.canSummon(level, player, summon.m_6095_())) {
                    owned.setTrueOwner((LivingEntity)player);
                    player.m_5496_(SoundEvents.f_12326_, 1.0f, 1.0f);
                    if (!level.f_46443_) {
                        ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_12326_, 1.0f, 1.0f));
                    }
                    itemstack.m_41774_(1);
                }
                return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static boolean hasSummon(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && stack.m_41783_().m_128441_(TAG_ENTITY);
    }

    public static void setSummon(CompoundTag compoundTag, LivingEntity livingEntity) {
        if (compoundTag != null && livingEntity != null) {
            compoundTag.m_128362_(TAG_ENTITY, livingEntity.m_20148_());
        }
    }

    public static LivingEntity getSummon(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return TransferScroll.getSummon(stack.m_41783_());
        }
        return null;
    }

    public static LivingEntity getSummon(CompoundTag compoundTag) {
        boolean flag = compoundTag.m_128441_(TAG_ENTITY);
        if (flag) {
            UUID uuid = compoundTag.m_128342_(TAG_ENTITY);
            return EntityFinder.getLivingEntityByUuiD(uuid);
        }
        return null;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        TransferScroll.addTransferText(stack, tooltip);
    }

    public static void addTransferText(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (!TransferScroll.hasSummon(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.noServant"));
            } else {
                LivingEntity livingEntity = TransferScroll.getSummon(stack.m_41783_());
                if (livingEntity != null) {
                    IOwned owned;
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.servant").m_130946_(" ").m_7220_(livingEntity.m_7770_() != null ? livingEntity.m_7770_() : livingEntity.m_5446_()).m_130940_(ChatFormatting.GREEN));
                    if (livingEntity instanceof IOwned && (owned = (IOwned)livingEntity).getMasterOwner() != null) {
                        tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.owner").m_130946_(" ").m_7220_(owned.getMasterOwner().m_7770_() != null ? owned.getMasterOwner().m_7770_() : owned.getMasterOwner().m_5446_()).m_130940_(ChatFormatting.GREEN));
                    }
                }
            }
        }
    }
}

