/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.revive;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.CairnNecromancerServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.NecromancerServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.StrayServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.WitherNecromancerServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.WitherSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.DrownedServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractCairnNecromancer;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.AbstractWitherNecromancer;
import com.Polarice3.Goety.common.entities.neutral.DrownedNecromancer;
import com.Polarice3.Goety.common.items.revive.ReviveServantItem;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.Objects;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class SoulJar
extends ReviveServantItem {
    public static final String TAG_CAIRN = "Cairn";
    public static final String TAG_DROWNED = "Drowned";
    public static final String TAG_WITHER = "Wither";

    public SoulJar() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).setNoRepair().m_41487_(1));
    }

    public boolean m_41475_() {
        return SoulJar.isWither(this.m_7968_());
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        AbstractNecromancer livingEntity;
        if (!worldIn.f_46443_ && (livingEntity = SoulJar.getNecromancer(stack, worldIn)) != null) {
            if (livingEntity instanceof AbstractCairnNecromancer) {
                if (!SoulJar.isCairn(stack)) {
                    SoulJar.setCairn(stack);
                }
            } else if (livingEntity instanceof DrownedNecromancer) {
                if (!SoulJar.isDrowned(stack)) {
                    SoulJar.setDrowned(stack);
                }
            } else if (livingEntity instanceof AbstractWitherNecromancer && !SoulJar.isWither(stack)) {
                SoulJar.setWither(stack);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Object entity;
        Level level = player.m_20193_();
        if (SoulJar.getSummon(stack, level) != null) {
            entity = SoulJar.getSummon(stack, level);
        } else {
            entity = new NecromancerServant((EntityType<? extends AbstractNecromancer>)((EntityType)ModEntityType.NECROMANCER_SERVANT.get()), level);
            if (SoulJar.isCairn(stack)) {
                entity = new CairnNecromancerServant((EntityType<? extends AbstractCairnNecromancer>)((EntityType)ModEntityType.CAIRN_NECROMANCER_SERVANT.get()), level);
            } else if (SoulJar.isDrowned(stack)) {
                entity = new DrownedNecromancer((EntityType<? extends AbstractNecromancer>)((EntityType)ModEntityType.DROWNED_NECROMANCER_SERVANT.get()), level);
            } else if (SoulJar.isWither(stack)) {
                entity = new WitherNecromancerServant((EntityType<? extends AbstractNecromancer>)((EntityType)ModEntityType.WITHER_NECROMANCER_SERVANT.get()), level);
            }
            IOwned owned = (IOwned)entity;
            owned.setTrueOwner((LivingEntity)player);
        }
        if (entity instanceof AbstractNecromancer) {
            boolean flag;
            AbstractNecromancer necromancer = (AbstractNecromancer)entity;
            if (necromancer instanceof DrownedNecromancer || SoulJar.isDrowned(stack)) {
                flag = target instanceof DrownedServant || target instanceof Drowned;
            } else if (necromancer instanceof AbstractWitherNecromancer || SoulJar.isWither(stack)) {
                flag = target instanceof WitherSkeletonServant || target instanceof WitherSkeleton;
            } else if (necromancer instanceof AbstractCairnNecromancer || SoulJar.isCairn(stack)) {
                flag = target instanceof StrayServant || target instanceof Stray;
            } else {
                boolean bl = flag = target instanceof SkeletonServant || target instanceof Skeleton;
            }
            if (flag && necromancer.getTrueOwner() == player && RitualRequirements.canSummon(level, player, (EntityType)ModEntityType.NECROMANCER_SERVANT.get())) {
                necromancer.m_21153_(necromancer.m_21233_());
                necromancer.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                necromancer.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_20182_());
                if (level.m_7967_((Entity)necromancer)) {
                    necromancer.m_21373_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 8; ++i) {
                            ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_235898_, (Entity)necromancer);
                            ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123759_, (Entity)necromancer);
                        }
                    }
                    necromancer.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f);
                    if (necromancer instanceof DrownedNecromancer) {
                        necromancer.m_5496_((SoundEvent)ModSounds.DROWNED_NECROMANCER_AMBIENT.get(), 2.0f, 0.5f);
                    } else {
                        necromancer.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 2.0f, 0.5f);
                    }
                    target.m_146870_();
                    player.m_6674_(hand);
                    SEHelper.addCooldown(player, this, MathHelper.secondsToTicks(30));
                    stack.m_41774_(1);
                }
            }
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public static boolean isCairn(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return stack.m_41720_() instanceof SoulJar && compoundtag != null && compoundtag.m_128441_(TAG_CAIRN);
    }

    public static void setCairn(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128379_(TAG_CAIRN, true);
    }

    public static boolean isDrowned(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return stack.m_41720_() instanceof SoulJar && compoundtag != null && compoundtag.m_128441_(TAG_DROWNED);
    }

    public static void setDrowned(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128379_(TAG_DROWNED, true);
    }

    public static boolean isWither(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return stack.m_41720_() instanceof SoulJar && compoundtag != null && compoundtag.m_128441_(TAG_WITHER);
    }

    public static void setWither(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128379_(TAG_WITHER, true);
    }

    public static void setNecromancer(AbstractNecromancer necromancer, ItemStack stack) {
        necromancer.m_8127_();
        necromancer.m_20153_();
        CompoundTag entityTag = new CompoundTag();
        ResourceLocation typesKey = ForgeRegistries.ENTITY_TYPES.getKey((Object)necromancer.m_6095_());
        if (typesKey != null) {
            entityTag.m_128359_("entity", typesKey.toString());
            if (necromancer.m_8077_()) {
                entityTag.m_128359_("name", Objects.requireNonNull(necromancer.m_7770_()).getString());
            }
            necromancer.m_20223_(entityTag);
            CompoundTag itemNBT = stack.m_41784_();
            itemNBT.m_128365_("entity", (Tag)entityTag);
        }
    }

    public static AbstractNecromancer getNecromancer(ItemStack stack, Level level) {
        CompoundTag entityTag;
        EntityType entityType;
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag != null && (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation((entityTag = itemTag.m_128469_("entity")).m_128461_("entity")))) != null) {
            Entity entity = entityType.m_20615_(level);
            if (level instanceof ServerLevel && entity != null) {
                entity.m_20258_(entityTag);
            }
            if (entity instanceof AbstractNecromancer) {
                AbstractNecromancer necromancer = (AbstractNecromancer)entity;
                return necromancer;
            }
        }
        return null;
    }
}

