/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.BreathingSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FireBreathSpell
extends BreathingSpell {
    public float damage = ((Double)SpellConfig.FireBreathDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();

    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(8).setBurning(1);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FireBreathCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.FireBreathChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.FireBreathDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FireBreathCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.FIRE_BREATH_START.get();
    }

    @Override
    public SoundEvent loopSound(LivingEntity caster) {
        return (SoundEvent)ModSounds.FIRE_BREATH.get();
    }

    @Override
    public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123762_, (Entity)caster);
        }
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        Mob mob;
        if (caster instanceof Mob && (mob = (Mob)caster).m_5448_() != null) {
            int range = spellStat.getRange();
            if (WandUtil.enchantedFocus(caster)) {
                range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            }
            return mob.m_142582_((Entity)mob.m_5448_()) && (double)mob.m_20270_((Entity)mob.m_5448_()) <= (double)range + 4.0;
        }
        return super.conditionsMet(worldIn, caster, spellStat);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float potency = spellStat.getPotency();
        int burning = spellStat.getBurning();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        float damage = this.damage + potency;
        if (!worldIn.f_46443_) {
            if (CuriosFinder.hasCurio(caster, (Item)ModItems.RING_OF_THE_DRAGON.get())) {
                damage *= 2.0f;
                if (((Boolean)SpellConfig.DragonFireGriefing.get()).booleanValue()) {
                    float flameRange = (float)range * ((float)Math.PI / 180);
                    for (int i = 0; i < 3; ++i) {
                        Vec3 cast = caster.m_20154_().m_82541_().m_82496_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange).m_82524_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange);
                        BlockHitResult hitResult = worldIn.m_45547_(new ClipContext(caster.m_146892_(), caster.m_146892_().m_82549_(cast.m_82490_(10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
                        if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
                        Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
                        BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
                        if (!worldIn.m_8055_(blockPos).m_60795_() && (!BlockFinder.canBeReplaced((Level)worldIn, blockPos) || !worldIn.m_6425_(blockPos).m_76178_() || !Blocks.f_50083_.m_49966_().m_60710_((LevelReader)worldIn, blockPos))) continue;
                        worldIn.m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)worldIn, (BlockPos)blockPos));
                    }
                }
            }
            for (Entity target : this.getBreathTarget(caster, range)) {
                if (target == null) continue;
                DamageSource damageSource = ModDamageSource.fireBreath((Entity)caster, (Entity)caster);
                if (CuriosFinder.hasNetherRobe(caster)) {
                    damageSource = ModDamageSource.magicFireBreath((Entity)caster, (Entity)caster);
                }
                if (!target.m_6469_(damageSource, damage)) continue;
                target.m_20254_(5 * burning);
            }
        }
    }

    @Override
    public void showWandBreath(LivingEntity entityLiving, SpellStat spellStat) {
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(entityLiving)) {
            range = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
        }
        if (!CuriosFinder.hasCurio(entityLiving, (Item)ModItems.RING_OF_THE_DRAGON.get())) {
            this.dragonBreathAttack((ParticleOptions)ModParticleTypes.SMALL_DRAGON_FLAME.get(), entityLiving, 10, (double)range / 10.0 * 0.5, 1.0);
        } else {
            this.dragonBreathAttack((ParticleOptions)ModParticleTypes.DRAGON_FLAME.get(), entityLiving, (double)range / 10.0 * 0.5);
        }
    }
}

