/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.Volcano;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EruptionSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(1).setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.EruptionCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.EruptionDuration.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.EruptionCoolDown.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int radius = (int)spellStat.getRadius();
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        int burning = spellStat.getBurning();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            burning += WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        LivingEntity target = this.getTarget(caster, range);
        BlockPos blockPos = caster.m_20183_();
        if (target != null) {
            blockPos = target.m_20183_();
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            blockPos = blockHitResult.m_82425_().m_7494_();
        }
        Volcano volcano = (Volcano)((EntityType)ModEntityType.VOLCANO.get()).m_20615_((Level)worldIn);
        if (volcano != null) {
            volcano.setTrueOwner(caster);
            volcano.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            volcano.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
            volcano.setExplosionPower(volcano.getExplosionPower() + (float)radius / 2.0f);
            volcano.setLifeSpan(6 * duration);
            volcano.setPotency(potency);
            volcano.setFlaming(burning);
            worldIn.m_7967_((Entity)volcano);
        }
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                blockPos = blockPos.m_7918_(-4 + worldIn.f_46441_.m_188503_(8), 0, -4 + worldIn.f_46441_.m_188503_(8));
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
                Volcano volcano2 = new Volcano((EntityType<? extends Owned>)((EntityType)ModEntityType.VOLCANO.get()), (Level)worldIn);
                volcano2.setTrueOwner(caster);
                volcano2.m_6034_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                volcano2.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                volcano2.setExplosionPower(volcano2.getExplosionPower() + (float)radius / 2.0f);
                volcano2.setLifeSpan(6 * duration);
                volcano2.setPotency(potency);
                volcano2.setFlaming(burning);
                worldIn.m_7967_((Entity)volcano2);
            }
        }
    }
}

