/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellPoses;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FlyingSpell
extends EverChargeSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FlyingCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.FlyingChargeUp.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WIND.get();
    }

    @Override
    public SoundEvent loopSound(LivingEntity caster) {
        return (SoundEvent)ModSounds.FLIGHT.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel.ArmPose getPose(LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        return SpellPoses.FLIGHT_POSE;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        double power = 0.5;
        if (this.rightStaff(staff)) {
            power = 1.0;
        }
        int potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            potency = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        caster.f_19864_ = true;
        if (!worldIn.f_46443_) {
            caster.m_6853_(false);
        }
        Vec3 vector3d = caster.m_20154_();
        double d0 = power + (double)(potency / 2);
        caster.m_20334_(vector3d.f_82479_ * d0, vector3d.f_82480_ * d0, vector3d.f_82481_ * d0);
        caster.f_19812_ = true;
        caster.f_19789_ = 0.0f;
        for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123796_, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

