/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.audio.LoopSoundPlayer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SPlayFollowSoundPacket {
    private final SoundEvent soundEvent;
    private final int entity;
    private final float volume;
    private final float pitch;
    private final boolean loop;

    public SPlayFollowSoundPacket(Entity entity, SoundEvent soundEvent, float volume, float pitch, boolean loop) {
        this.entity = entity.m_19879_();
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
        this.loop = loop;
    }

    public SPlayFollowSoundPacket(int entity, SoundEvent soundEvent, float volume, float pitch, boolean loop) {
        this.entity = entity;
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
        this.loop = loop;
    }

    public static void encode(SPlayFollowSoundPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entity);
        buffer.m_130085_(packet.soundEvent.m_11660_());
        buffer.writeFloat(packet.volume);
        buffer.writeFloat(packet.pitch);
        buffer.writeBoolean(packet.loop);
    }

    public static SPlayFollowSoundPacket decode(FriendlyByteBuf buffer) {
        return new SPlayFollowSoundPacket(buffer.readInt(), SoundEvent.m_262824_((ResourceLocation)buffer.m_130281_()), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
    }

    public static void consume(SPlayFollowSoundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = Goety.PROXY.getLevel()) instanceof ClientLevel) {
                Entity entity;
                ClientLevel clientWorld = (ClientLevel)level;
                if (packet.entity >= 0 && (entity = clientWorld.m_6815_(packet.entity)) != null) {
                    LoopSoundPlayer.playFollowSound(entity, packet.soundEvent, packet.volume, packet.pitch, packet.loop);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

