/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.Goety;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SPurifyEffectPacket {
    private final int mob;
    private final boolean removeDebuff;

    public SPurifyEffectPacket(int mob, boolean removeDebuff) {
        this.mob = mob;
        this.removeDebuff = removeDebuff;
    }

    public static void encode(SPurifyEffectPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.mob);
        buffer.writeBoolean(packet.removeDebuff);
    }

    public static SPurifyEffectPacket decode(FriendlyByteBuf buffer) {
        return new SPurifyEffectPacket(buffer.readInt(), buffer.readBoolean());
    }

    public static void consume(SPurifyEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel clientWorld;
            Entity entity;
            Level level = Goety.PROXY.getLevel();
            if (level instanceof ClientLevel && (entity = (clientWorld = (ClientLevel)level).m_6815_(packet.mob)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (MobEffect mobEffect : ForgeRegistries.MOB_EFFECTS) {
                    boolean flag = packet.removeDebuff ? !mobEffect.m_19486_() : mobEffect.m_19486_();
                    if (!flag || mobEffect.getCurativeItems().isEmpty()) continue;
                    livingEntity.m_21195_(mobEffect);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

