/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.patchouli;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class BrewingSacrificeProcessor
implements IComponentProcessor {
    protected BrewEffect brewEffect;
    private String extraText = "";

    public void setup(Level level, IVariableProvider variables) {
        String effectId = variables.get("recipe").asString();
        this.brewEffect = new BrewEffects().getBrewEffect(effectId);
        if (variables.has("text")) {
            this.extraText = variables.get("text").asString();
        }
    }

    public IVariable process(Level level, String key) {
        if (this.brewEffect == null) {
            return IVariable.empty();
        }
        if (key.startsWith("input")) {
            ItemStack itemStack = ItemStack.f_41583_;
            EntityType<?> entityType = new BrewEffects().getSacrificeFromEffect(this.brewEffect.getEffectID());
            SpawnEggItem item = ForgeSpawnEggItem.fromEntityType(entityType);
            if (item != null) {
                itemStack = new ItemStack((ItemLike)item);
            }
            return IVariable.from((Object)itemStack);
        }
        if (key.startsWith("capacityExtra") && this.brewEffect.getCapacityExtra() > 0) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.capacityUse", (Object[])new Object[]{this.brewEffect.getCapacityExtra()}));
        }
        if (key.startsWith("soulCost")) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.single.soulcost", (Object[])new Object[]{this.brewEffect.getSoulCost()}));
        }
        if (key.startsWith("duration")) {
            if (this.brewEffect.getDuration() > 40) {
                return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.single.duration", (Object[])new Object[]{StringUtil.m_14404_((int)this.brewEffect.getDuration())}));
            }
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.instant.duration", (Object[])new Object[0]));
        }
        if (key.startsWith("linger") && !this.brewEffect.canLinger()) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.goety.linger", (Object[])new Object[0]));
        }
        if (key.startsWith("output")) {
            return IVariable.wrap((String)this.brewEffect.getDescriptionId());
        }
        if (key.startsWith("text")) {
            return IVariable.wrap((String)this.extraText);
        }
        return IVariable.empty();
    }
}

