/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.mixin;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.neutral.AbstractVine;
import com.Polarice3.Goety.init.ModSoundTypes;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.SEHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @ModifyVariable(at=@At(value="HEAD"), method={"turn"}, ordinal=0, argsOnly=true)
    private double I$XRotate(double value) {
        return this.goety2$playerPerspectiveValue(value);
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"turn"}, ordinal=1, argsOnly=true)
    private double I$YRotate(double value) {
        return this.goety2$playerPerspectiveValue(value);
    }

    @Unique
    private double goety2$playerPerspectiveValue(double value) {
        Player player;
        Entity entity = (Entity)this;
        boolean flag = entity instanceof Player && SEHelper.hasCamera(player = (Player)entity);
        return flag ? 0.0 : value;
    }

    @Inject(method={"canCollideWith(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canCollideWith(Entity other, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        Entity entity;
        AbstractVine vine;
        if (other instanceof AbstractVine && (vine = (AbstractVine)other).passableEntities((Entity)this)) {
            cir.setReturnValue((Object)false);
        }
        if ((entity = (Entity)this) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.TANGLED.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"push(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void push(double p_20286_, double p_20287_, double p_20288_, CallbackInfo callbackInfo) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.TANGLED.get())) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"isSwimming"}, at={@At(value="HEAD")}, cancellable=true)
    public void isSwimming(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.PLUNGE.get())) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"playStepSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="TAIL")})
    protected void playStepSound(BlockPos blockPos, BlockState blockState, CallbackInfo callbackInfo) {
        Entity entity = (Entity)this;
        SoundType soundtype = blockState.getSoundType((LevelReader)entity.f_19853_, blockPos, entity);
        if (soundtype == ModSoundTypes.MOD_METAL) {
            entity.m_5496_(SoundEvents.f_12450_, soundtype.m_56773_() * 0.15f * Mth.m_216283_((RandomSource)entity.f_19853_.f_46441_, (float)0.8f, (float)1.0f), Mth.m_216283_((RandomSource)entity.f_19853_.f_46441_, (float)0.8f, (float)1.0f));
            entity.m_5496_(SoundEvents.f_12600_, soundtype.m_56773_() * 0.15f * Mth.m_216283_((RandomSource)entity.f_19853_.f_46441_, (float)0.8f, (float)1.0f), Mth.m_216283_((RandomSource)entity.f_19853_.f_46441_, (float)0.8f, (float)1.0f));
        }
    }

    @Inject(method={"makeStuckInBlock(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void makeStuckInBlock(BlockState blockState, Vec3 vec3, CallbackInfo callbackInfo) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (blockState.m_60734_() instanceof WebBlock && livingEntity.m_21023_((MobEffect)GoetyEffects.CLIMBING.get())) {
                callbackInfo.cancel();
            }
            if (blockState.m_60734_() instanceof PowderSnowBlock && CuriosFinder.hasFrostRobes(livingEntity)) {
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    public void fireImmune(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (CuriosFinder.hasUnholyHat(livingEntity = (LivingEntity)entity) || CuriosFinder.hasUnholyRobe(livingEntity))) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }
}

