/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.util.BrewEffectCloud;
import com.Polarice3.Goety.common.entities.util.BrewGas;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SAddBrewParticlesPacket;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BrewUtils {
    public static String AOE_ID = "AreaOfEffect";
    public static String LINGERING_ID = "Lingering";
    public static String QUAFF_ID = "Quaff";
    public static String VELOCITY_ID = "Velocity";
    public static String AQUATIC_ID = "Aquatic";
    public static String FIRE_PROOF_ID = "FireProof";
    private static final Component NO_EFFECT = Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY);
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::m_6126_;

    public static int getAreaOfEffect(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(AOE_ID)) {
            return compoundtag.m_128451_(AOE_ID);
        }
        return 0;
    }

    public static void setAreaOfEffect(ItemStack pStack, int aoe) {
        pStack.m_41784_().m_128405_(AOE_ID, aoe);
    }

    public static float getLingering(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(LINGERING_ID)) {
            return compoundtag.m_128457_(LINGERING_ID);
        }
        return 0.0f;
    }

    public static void setLingering(ItemStack pStack, float lingering) {
        pStack.m_41784_().m_128350_(LINGERING_ID, lingering);
    }

    public static int getQuaff(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(QUAFF_ID)) {
            return compoundtag.m_128451_(QUAFF_ID);
        }
        return 0;
    }

    public static int getQuaffLevel(ItemStack itemStack) {
        int quaff = BrewUtils.getQuaff(itemStack);
        if (quaff == 4) {
            return 1;
        }
        if (quaff == 8) {
            return 2;
        }
        if (quaff >= 16) {
            return 3;
        }
        return 0;
    }

    public static void setQuaff(ItemStack pStack, int quaff) {
        pStack.m_41784_().m_128405_(QUAFF_ID, quaff);
    }

    public static float getVelocity(@NotNull ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(VELOCITY_ID)) {
            return compoundtag.m_128457_(VELOCITY_ID);
        }
        return 0.0f;
    }

    public static int getVelocityLevel(ItemStack itemStack) {
        float velocity = BrewUtils.getVelocity(itemStack);
        if (velocity == 0.1f) {
            return 1;
        }
        if (velocity == 0.3f) {
            return 2;
        }
        if (velocity >= 0.5f) {
            return 3;
        }
        return 0;
    }

    public static void setVelocity(ItemStack pStack, float velocity) {
        pStack.m_41784_().m_128350_(VELOCITY_ID, velocity);
    }

    public static boolean getAquatic(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(AQUATIC_ID)) {
            return compoundtag.m_128471_(AQUATIC_ID);
        }
        return false;
    }

    public static void setAquatic(ItemStack pStack, boolean aquatic) {
        pStack.m_41784_().m_128379_(AQUATIC_ID, aquatic);
    }

    public static boolean getFireProof(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_(FIRE_PROOF_ID)) {
            return compoundtag.m_128471_(FIRE_PROOF_ID);
        }
        return false;
    }

    public static void setFireProof(ItemStack pStack, boolean fireProof) {
        pStack.m_41784_().m_128379_(FIRE_PROOF_ID, fireProof);
    }

    public static List<BrewEffectInstance> getBrewEffects(ItemStack p_43548_) {
        return BrewUtils.getAllEffects(p_43548_.m_41783_());
    }

    public static List<BrewEffectInstance> getAllEffects(Collection<BrewEffectInstance> p_43563_) {
        ArrayList list = Lists.newArrayList();
        list.addAll(p_43563_);
        return list;
    }

    public static List<MobEffectInstance> getAllMobEffects(Collection<MobEffectInstance> p_43563_) {
        ArrayList list = Lists.newArrayList();
        list.addAll(p_43563_);
        return list;
    }

    public static List<BrewEffectInstance> getAllEffects(@Nullable CompoundTag p_43567_) {
        ArrayList list = Lists.newArrayList();
        BrewUtils.getCustomEffects(p_43567_, list);
        return list;
    }

    public static List<BrewEffectInstance> getCustomEffects(ItemStack p_43572_) {
        return BrewUtils.getCustomEffects(p_43572_.m_41783_());
    }

    public static List<BrewEffectInstance> getCustomEffects(@Nullable CompoundTag p_43574_) {
        ArrayList list = Lists.newArrayList();
        BrewUtils.getCustomEffects(p_43574_, list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag p_43569_, List<BrewEffectInstance> p_43570_) {
        if (p_43569_ != null && p_43569_.m_128425_("CustomBrewEffects", 9)) {
            ListTag listtag = p_43569_.m_128437_("CustomBrewEffects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                BrewEffectInstance instance = BrewEffectInstance.load(compoundtag);
                if (instance == null) continue;
                p_43570_.add(instance);
            }
        }
    }

    public static ItemStack setCustomEffects(ItemStack stack, Collection<MobEffectInstance> instances1, Collection<BrewEffectInstance> instances) {
        ListTag listtag;
        CompoundTag compoundtag;
        if (!instances1.isEmpty()) {
            compoundtag = stack.m_41784_();
            listtag = compoundtag.m_128437_("CustomPotionEffects", 9);
            for (MobEffectInstance mobeffectinstance : instances1) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compoundtag.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
        if (!instances.isEmpty()) {
            compoundtag = stack.m_41784_();
            listtag = compoundtag.m_128437_("CustomBrewEffects", 9);
            for (BrewEffectInstance instance : instances) {
                listtag.add((Object)instance.save(new CompoundTag()));
            }
            compoundtag.m_128365_("CustomBrewEffects", (Tag)listtag);
        }
        return stack;
    }

    public static void addBrewTooltip(ItemStack itemStack, List<Component> p_43557_, float p_43558_) {
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        ArrayList list1 = Lists.newArrayList();
        List<BrewEffectInstance> list2 = BrewUtils.getBrewEffects(itemStack);
        if (list.isEmpty() && list2.isEmpty()) {
            p_43557_.add(NO_EFFECT);
        } else {
            BrewEffect mobeffect;
            MutableComponent mutablecomponent;
            if (!list2.isEmpty()) {
                for (BrewEffectInstance brewEffectInstance : list2) {
                    mutablecomponent = brewEffectInstance.getName();
                    mobeffect = brewEffectInstance.getEffect();
                    if (brewEffectInstance.getAmplifier() > 0) {
                        mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + brewEffectInstance.getAmplifier()))});
                    }
                    if (brewEffectInstance.getDuration() > 20) {
                        mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, BrewUtils.formatDuration(brewEffectInstance, p_43558_)});
                    }
                    p_43557_.add((Component)mutablecomponent.m_130940_(mobeffect.getCategory().m_19497_()));
                }
            }
            if (!list.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : list) {
                    mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                    mobeffect = mobeffectinstance.m_19544_();
                    Map map = mobeffect.m_19485_();
                    if (!map.isEmpty()) {
                        for (Map.Entry entry : map.entrySet()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                            list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                        }
                    }
                    if (mobeffectinstance.m_19564_() > 0) {
                        mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                    }
                    if (mobeffectinstance.m_19557_() > 20) {
                        mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)p_43558_)});
                    }
                    p_43557_.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
                }
            }
            if (BrewUtils.getAreaOfEffect(itemStack) > 0) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.area", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + BrewUtils.getAreaOfEffect(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getLingering(itemStack) > 0.0f) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.lingering", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + (int)BrewUtils.getLingering(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getQuaffLevel(itemStack) > 0) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.quaff", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + BrewUtils.getQuaffLevel(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getVelocityLevel(itemStack) > 0) {
                p_43557_.add((Component)Component.m_237110_((String)"tooltip.goety.brew.velocity", (Object[])new Object[]{Component.m_237115_((String)("potion.potency." + BrewUtils.getVelocityLevel(itemStack)))}).m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getAquatic(itemStack)) {
                p_43557_.add((Component)Component.m_237115_((String)"tooltip.goety.brew.aquatic").m_130940_(ChatFormatting.BLUE));
            }
            if (BrewUtils.getFireProof(itemStack)) {
                p_43557_.add((Component)Component.m_237115_((String)"tooltip.goety.brew.fireProof").m_130940_(ChatFormatting.BLUE));
            }
            if (!list1.isEmpty()) {
                p_43557_.add(CommonComponents.f_237098_);
                p_43557_.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
                for (Pair pair : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                    double d0 = attributemodifier2.m_22218_();
                    double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                    if (d0 > 0.0) {
                        p_43557_.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    p_43557_.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    public static String formatDuration(BrewEffectInstance p_19582_, float p_19583_) {
        int i = Mth.m_14143_((float)((float)p_19582_.getDuration() * p_19583_));
        return StringUtil.m_14404_((int)i);
    }

    public static boolean hasBrewEffect(ItemStack itemStack) {
        return !BrewUtils.getBrewEffects(itemStack).isEmpty();
    }

    public static boolean hasEffect(ItemStack itemStack) {
        return !PotionUtils.m_43571_((ItemStack)itemStack).isEmpty() || !BrewUtils.getBrewEffects(itemStack).isEmpty();
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return PotionUtils.m_43571_((ItemStack)itemStack).isEmpty() && BrewUtils.getBrewEffects(itemStack).isEmpty();
    }

    public static boolean brewableFood(ItemStack itemStack) {
        return itemStack.m_204117_(ModTags.Items.BREWABLE_FOOD) && !BrewUtils.hasEffect(itemStack);
    }

    public static int getColor(ItemStack p_43576_) {
        CompoundTag compoundtag = p_43576_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            return compoundtag.m_128451_("CustomPotionColor");
        }
        return BrewUtils.getColor(PotionUtils.m_43547_((ItemStack)p_43576_), BrewUtils.getBrewEffects(p_43576_));
    }

    public static int getColor(Collection<MobEffectInstance> instance1, Collection<BrewEffectInstance> instance2) {
        int l;
        int k;
        if (instance1.isEmpty() && instance2.isEmpty()) {
            return 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (MobEffectInstance mobeffectinstance : instance1) {
            if (!mobeffectinstance.m_19572_()) continue;
            k = mobeffectinstance.m_19544_().m_19484_();
            l = mobeffectinstance.m_19564_() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        for (BrewEffectInstance brewEffectInstance : instance2) {
            k = brewEffectInstance.getEffect().getColor();
            l = brewEffectInstance.getAmplifier() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static boolean isLingering(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ModItems.LINGERING_BREW.get());
    }

    public static boolean isGas(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ModItems.GAS_BREW.get());
    }

    public static void onHit(LivingEntity livingEntity, ItemStack itemStack, @Nullable Entity target, BlockPos blockPos, Direction direction) {
        if (!livingEntity.f_19853_.f_46443_) {
            boolean flag;
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            List list = PotionUtils.m_43547_((ItemStack)itemStack);
            List<BrewEffectInstance> list1 = BrewUtils.getBrewEffects(itemStack);
            boolean bl = flag = potion == Potions.f_43599_ && list.isEmpty();
            if (flag) {
                BrewUtils.applyWater(livingEntity, itemStack, target, blockPos);
            } else if (!list.isEmpty() || !list1.isEmpty()) {
                if (BrewUtils.isGas(itemStack)) {
                    BrewUtils.makeBrewGas(livingEntity, itemStack, target, blockPos);
                } else if (BrewUtils.isLingering(itemStack)) {
                    BrewUtils.makeAreaOfEffectCloud(livingEntity, itemStack, target, blockPos);
                } else {
                    BrewUtils.applySplash(livingEntity, itemStack, target, blockPos, list, list1);
                }
            }
            ModNetwork.sendToALL(new SAddBrewParticlesPacket(itemStack, blockPos, potion.m_43491_(), BrewUtils.getColor(itemStack)));
            if (target != null) {
                BrewUtils.onHitBlock(livingEntity, itemStack, target.m_20183_(), direction);
                BrewUtils.onHitEntity(livingEntity, itemStack, target);
            }
        }
    }

    public static void onHitEntity(LivingEntity livingEntity, ItemStack itemStack, Entity target) {
        if (!livingEntity.f_19853_.f_46443_ && !BrewUtils.isGas(itemStack)) {
            List<BrewEffectInstance> list = BrewUtils.getBrewEffects(itemStack);
            for (BrewEffectInstance brewEffectInstance : list) {
                brewEffectInstance.getEffect().applyBlockEffect(livingEntity.f_19853_, target.m_20183_(), livingEntity, brewEffectInstance.getDuration(), brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemStack));
            }
        }
    }

    public static void onHitBlock(LivingEntity livingEntity, ItemStack itemStack, BlockPos blockPos, Direction direction) {
        if (!livingEntity.f_19853_.f_46443_ && !BrewUtils.isGas(itemStack)) {
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            List<BrewEffectInstance> list = BrewUtils.getBrewEffects(itemStack);
            boolean flag = potion == Potions.f_43599_ && list.isEmpty();
            BlockPos blockpos1 = blockPos.m_121945_(direction);
            if (flag) {
                BrewUtils.dowseFire(livingEntity, blockpos1);
                BrewUtils.dowseFire(livingEntity, blockpos1.m_121945_(direction.m_122424_()));
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    BrewUtils.dowseFire(livingEntity, blockpos1.m_121945_(direction1));
                }
            }
            for (BrewEffectInstance brewEffectInstance : list) {
                brewEffectInstance.getEffect().applyDirectionalBlockEffect(livingEntity.f_19853_, blockPos, direction, livingEntity, brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemStack));
                brewEffectInstance.getEffect().applyBlockEffect(livingEntity.f_19853_, blockPos, livingEntity, brewEffectInstance.getDuration(), brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemStack));
            }
        }
    }

    public static AABB makeBoundingBox(double p_20385_, double p_20386_, double p_20387_) {
        float f = 0.125f;
        float f1 = 0.25f;
        return new AABB(p_20385_ - (double)f, p_20386_, p_20387_ - (double)f, p_20385_ + (double)f, p_20386_ + (double)f1, p_20387_ + (double)f);
    }

    public static void applyWater(LivingEntity livingEntity, ItemStack itemStack, @Nullable Entity target, BlockPos blockPos) {
        AABB aabb;
        List list;
        int area = BrewUtils.getAreaOfEffect(itemStack) + 4;
        int areaSqr = Mth.m_144944_((int)area);
        Vec3 vec3 = blockPos.m_252807_();
        if (target != null) {
            vec3 = target.m_20182_();
        }
        if (!(list = livingEntity.f_19853_.m_6443_(LivingEntity.class, aabb = BrewUtils.makeBoundingBox(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_).m_82377_((double)area, (double)area / 2.0, (double)area), WATER_SENSITIVE)).isEmpty()) {
            for (LivingEntity livingTarget : list) {
                double d0 = vec3.m_82557_(livingTarget.m_20182_());
                if (!(d0 < (double)areaSqr) || !livingTarget.m_6126_()) continue;
                livingTarget.m_6469_(livingTarget.m_269291_().m_269104_((Entity)livingEntity, (Entity)livingEntity), 1.0f);
            }
        }
        for (Axolotl axolotl : livingEntity.f_19853_.m_45976_(Axolotl.class, aabb)) {
            axolotl.m_149177_();
        }
    }

    public static void applySplash(LivingEntity livingEntity, ItemStack itemStack, @Nullable Entity target, BlockPos blockPos, List<MobEffectInstance> mobEffectInstances, List<BrewEffectInstance> brewEffectInstances) {
        AABB aabb;
        List list;
        int area = BrewUtils.getAreaOfEffect(itemStack) + 4;
        int areaSqr = Mth.m_144944_((int)area);
        Vec3 vec3 = blockPos.m_252807_();
        if (target != null) {
            vec3 = target.m_20182_();
        }
        if (!(list = livingEntity.f_19853_.m_45976_(LivingEntity.class, aabb = BrewUtils.makeBoundingBox(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_).m_82377_((double)area, (double)area / 2.0, (double)area))).isEmpty()) {
            for (LivingEntity livingTarget : list) {
                double d0;
                if (!livingTarget.m_5801_() || !((d0 = vec3.m_82557_(livingTarget.m_20182_())) < (double)areaSqr)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / (double)areaSqr;
                if (livingTarget == target) {
                    d1 = 1.0;
                }
                if (!mobEffectInstances.isEmpty()) {
                    for (MobEffectInstance mobeffectinstance : mobEffectInstances) {
                        MobEffect mobeffect = mobeffectinstance.m_19544_();
                        if (mobeffect.m_8093_()) {
                            mobeffect.m_19461_((Entity)livingEntity, (Entity)livingEntity, livingTarget, mobeffectinstance.m_19564_(), d1);
                            continue;
                        }
                        int i = (int)(d1 * (double)mobeffectinstance.m_19557_() + 0.5);
                        if (i <= 20) continue;
                        livingTarget.m_147207_(new MobEffectInstance(mobeffect, i, mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), (Entity)livingEntity);
                    }
                }
                if (brewEffectInstances.isEmpty()) continue;
                for (BrewEffectInstance brewEffectInstance : brewEffectInstances) {
                    BrewEffect brewEffect = brewEffectInstance.getEffect();
                    if (!brewEffect.isInstantenous()) continue;
                    brewEffect.applyInstantenousEffect((Entity)livingEntity, (Entity)livingEntity, livingTarget, brewEffectInstance.getAmplifier(), d1);
                }
            }
        }
    }

    public static void makeAreaOfEffectCloud(LivingEntity livingEntity, ItemStack itemStack, @Nullable Entity target, BlockPos blockPos) {
        int h = BrewUtils.getAreaOfEffect(itemStack);
        float i = BrewUtils.getLingering(itemStack);
        Vec3 vec3 = blockPos.m_252807_();
        if (target != null) {
            vec3 = target.m_20182_();
        }
        BrewEffectCloud brewEffectCloud = new BrewEffectCloud(livingEntity.f_19853_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
        brewEffectCloud.setOwner(livingEntity);
        brewEffectCloud.setRadius(3.0f + (float)h);
        if ((double)i < 0.3) {
            brewEffectCloud.setRadiusOnUse(-(0.5f - Mth.m_14207_((float)i)));
        }
        brewEffectCloud.setWaitTime(10);
        brewEffectCloud.setRadiusPerTick(-brewEffectCloud.getRadius() / (float)brewEffectCloud.getDuration());
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43571_((ItemStack)itemStack)) {
            brewEffectCloud.addEffect(new MobEffectInstance(mobeffectinstance));
        }
        for (BrewEffectInstance brewEffectInstance : BrewUtils.getCustomEffects(itemStack)) {
            if (!brewEffectInstance.getEffect().canLinger()) continue;
            brewEffectCloud.addBrewEffect(new BrewEffectInstance(brewEffectInstance));
        }
        CompoundTag compoundtag = itemStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            brewEffectCloud.setFixedColor(compoundtag.m_128451_("CustomPotionColor"));
        }
        livingEntity.f_19853_.m_7967_((Entity)brewEffectCloud);
    }

    public static void makeBrewGas(LivingEntity livingEntity, ItemStack itemStack, @Nullable Entity target, BlockPos blockPos) {
        int h = BrewUtils.getAreaOfEffect(itemStack);
        int i = (int)BrewUtils.getLingering(itemStack);
        if (target != null) {
            blockPos = target.m_20183_();
        }
        BrewGas brewGas = new BrewGas(livingEntity.f_19853_, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        brewGas.setGas(PotionUtils.m_43571_((ItemStack)itemStack), BrewUtils.getCustomEffects(itemStack), 120 * (i + 1), 3 * (h + 1), livingEntity);
        livingEntity.f_19853_.m_7967_((Entity)brewGas);
        if (!livingEntity.f_19853_.f_46443_) {
            ModNetwork.sendToALL(new SPlayWorldSoundPacket(blockPos, (SoundEvent)ModSounds.BREW_GAS.get(), 1.0f, livingEntity.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f));
        }
    }

    public static void dowseFire(LivingEntity livingEntity, BlockPos p_150193_) {
        BlockState blockstate = livingEntity.f_19853_.m_8055_(p_150193_);
        if (blockstate.m_204336_(BlockTags.f_13076_)) {
            livingEntity.f_19853_.m_7471_(p_150193_, false);
        } else if (AbstractCandleBlock.m_151933_((BlockState)blockstate)) {
            AbstractCandleBlock.m_151899_((Player)null, (BlockState)blockstate, (LevelAccessor)livingEntity.f_19853_, (BlockPos)p_150193_);
        } else if (CampfireBlock.m_51319_((BlockState)blockstate)) {
            livingEntity.f_19853_.m_5898_((Player)null, 1009, p_150193_, 0);
            CampfireBlock.m_152749_((Entity)livingEntity, (LevelAccessor)livingEntity.f_19853_, (BlockPos)p_150193_, (BlockState)blockstate);
            livingEntity.f_19853_.m_46597_(p_150193_, (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }
}

