/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.utils.ColorUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class MathHelper
extends Mth {
    public static int secondsToTicks(int pSeconds) {
        return pSeconds * 20;
    }

    public static int secondsToTicks(float pSeconds) {
        return (int)(pSeconds * 20.0f);
    }

    public static int minutesToTicks(int pMinutes) {
        return MathHelper.secondsToTicks(pMinutes * 60);
    }

    public static float minutesToTicks(float pMinutes) {
        return MathHelper.secondsToTicks(pMinutes * 60.0f);
    }

    public static int minecraftDayToTicks(int pDay) {
        return pDay * 24000;
    }

    public static float minecraftDayToTicks(float pDay) {
        return pDay * 24000.0f;
    }

    public static float modelDegrees(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }

    public static double rgbToSpeed(double colorCode) {
        return colorCode / 255.0;
    }

    public static double[] rgbParticle(int colorCode) {
        ColorUtil colorUtil = new ColorUtil(colorCode);
        return new double[]{colorUtil.red, colorUtil.green, colorUtil.blue};
    }

    public static float[] rgbFloat(int colorCode) {
        ColorUtil colorUtil = new ColorUtil(colorCode);
        return new float[]{colorUtil.red, colorUtil.green, colorUtil.blue};
    }

    public static long setDayNumberAndTime(long day, long time) {
        return day * 24000L + time;
    }

    public static long getNextDaysTime(Level world, long timeOfDay) {
        long dayTime = world.m_46468_();
        long newTime = dayTime + 24000L;
        newTime -= newTime % 24000L;
        return newTime + timeOfDay;
    }

    public static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    public static float lerpAngleDegrees(float delta, float start, float end) {
        return start + delta * MathHelper.m_14177_((float)(end - start));
    }

    public static double lerpAngleDegrees(double delta, double start, double end) {
        return start + delta * MathHelper.m_14175_((double)(end - start));
    }

    public static double getLerpProgress(double value, double start, double end) {
        return (value - start) / (end - start);
    }

    public static float getLerpProgress(float value, float start, float end) {
        return (value - start) / (end - start);
    }

    public static boolean approximatelyEquals(float a, float b) {
        return Math.abs(b - a) < 1.0E-5f;
    }

    public static boolean approximatelyEquals(double a, double b) {
        return Math.abs(b - a) < (double)1.0E-5f;
    }
}

