/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.client.particles.WindParticleOption;
import com.Polarice3.Goety.client.particles.WindShockwaveParticle;
import com.Polarice3.Goety.utils.ColorUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ServerParticleUtil {
    public static void smokeParticles(ParticleOptions pParticleData, double x, double y, double z, Level world) {
        ServerLevel serverWorld = (ServerLevel)world;
        serverWorld.m_8767_(pParticleData, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void addParticles(ParticleOptions pParticleData, double x, double y, double z, double pXOffset, double pYOffset, double pZOffset, Level world) {
        ServerLevel serverWorld = (ServerLevel)world;
        serverWorld.m_8767_(pParticleData, x, y, z, 0, pXOffset, pYOffset, pZOffset, 0.5);
    }

    public static void spawnRedstoneParticles(ServerLevel pLevel, BlockPos pPos) {
        double d0 = 0.5625;
        RandomSource random = pLevel.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pPos.m_121945_(direction);
            if (pLevel.m_8055_(blockpos).m_60804_((BlockGetter)pLevel, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.m_188501_();
            ServerParticleUtil.smokeParticles((ParticleOptions)DustParticleOptions.f_123656_, (double)pPos.m_123341_() + d1, (double)pPos.m_123342_() + d2, (double)pPos.m_123343_() + d3, (Level)pLevel);
        }
    }

    public static void emitterParticles(ServerLevel serverWorld, Entity entity, ParticleOptions particleData) {
        for (int i = 0; i < 16; ++i) {
            double d2;
            double d1;
            double d0 = serverWorld.f_46441_.m_188501_() * 2.0f - 1.0f;
            if (d0 * d0 + (d1 = (double)(serverWorld.f_46441_.m_188501_() * 2.0f - 1.0f)) * d1 + (d2 = (double)(serverWorld.f_46441_.m_188501_() * 2.0f - 1.0f)) * d2 > 1.0) continue;
            double d3 = entity.m_20165_(d0 / 4.0);
            double d4 = entity.m_20227_(0.5 + d1 / 4.0);
            double d5 = entity.m_20246_(d2 / 4.0);
            serverWorld.m_8767_(particleData, d3, d4, d5, 0, d0, d1 + 0.2, d2, 0.5);
        }
    }

    public static void gatheringParticles(ParticleOptions pParticleData, Entity entity, ServerLevel serverWorld) {
        ServerParticleUtil.gatheringParticles(pParticleData, entity, serverWorld, 2);
    }

    public static void gatheringParticles(ParticleOptions pParticleData, Entity entity, ServerLevel serverWorld, int range) {
        ArrayList positions = Lists.newArrayList();
        if (serverWorld != null) {
            BlockPos blockpos1;
            for (int j1 = -range; j1 <= range; ++j1) {
                for (int k1 = -range; k1 <= range; ++k1) {
                    for (int l1 = -range; l1 <= range; ++l1) {
                        int i2 = Math.abs(j1);
                        int l = Math.abs(k1);
                        int i1 = Math.abs(l1);
                        if ((j1 != 0 || l != range && i1 != range) && (k1 != 0 || i2 != range && i1 != range) && (l1 != 0 || i2 != range && l != range)) continue;
                        blockpos1 = entity.m_20183_().m_7918_(j1, k1, l1);
                        positions.add(blockpos1);
                    }
                }
            }
            Vec3 vector3d = new Vec3(entity.m_20182_().f_82479_, entity.m_20188_(), entity.m_20182_().f_82481_);
            for (BlockPos blockpos : positions) {
                if (serverWorld.f_46441_.m_188503_(50) != 0) continue;
                float f = -0.5f + serverWorld.f_46441_.m_188501_();
                float f1 = -2.0f + serverWorld.f_46441_.m_188501_();
                float f2 = -0.5f + serverWorld.f_46441_.m_188501_();
                blockpos1 = blockpos.m_121996_((Vec3i)entity.m_20183_());
                Vec3 vector3d1 = new Vec3((double)f, (double)f1, (double)f2).m_82520_((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
                serverWorld.m_8767_(pParticleData, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1, vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, 0.5);
            }
        }
    }

    public static void gatheringBlockParticles(ParticleOptions pParticleData, BlockPos pBlockPos, ServerLevel serverWorld) {
        ArrayList positions = Lists.newArrayList();
        if (serverWorld != null) {
            BlockPos blockpos1;
            for (int j1 = -2; j1 <= 2; ++j1) {
                for (int k1 = -2; k1 <= 2; ++k1) {
                    for (int l1 = -2; l1 <= 2; ++l1) {
                        int i2 = Math.abs(j1);
                        int l = Math.abs(k1);
                        int i1 = Math.abs(l1);
                        if ((j1 != 0 || l != 2 && i1 != 2) && (k1 != 0 || i2 != 2 && i1 != 2) && (l1 != 0 || i2 != 2 && l != 2)) continue;
                        blockpos1 = pBlockPos.m_7918_(j1, k1, l1);
                        positions.add(blockpos1);
                    }
                }
            }
            Vec3 vector3d = new Vec3((double)((float)pBlockPos.m_123341_() + 0.5f), (double)((float)pBlockPos.m_123342_() + 1.0f), (double)((float)pBlockPos.m_123343_() + 0.5f));
            for (BlockPos blockpos : positions) {
                if (serverWorld.f_46441_.m_188503_(50) != 0) continue;
                float f = -0.5f + serverWorld.f_46441_.m_188501_();
                float f1 = -2.0f + serverWorld.f_46441_.m_188501_();
                float f2 = -0.5f + serverWorld.f_46441_.m_188501_();
                blockpos1 = blockpos.m_121996_((Vec3i)pBlockPos);
                Vec3 vector3d1 = new Vec3((double)f, (double)f1, (double)f2).m_82520_((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
                serverWorld.m_8767_(pParticleData, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 0, vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, 0.5);
            }
        }
    }

    public static void blockBreakParticles(ParticleOptions pParticleData, BlockPos pPos, BlockState pState, ServerLevel serverWorld) {
        if (serverWorld != null) {
            VoxelShape voxelshape = pState.m_60808_((BlockGetter)serverWorld, pPos);
            voxelshape.m_83286_((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
                double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
                double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
                double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
                int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_228348_3_;
                            double d8 = d5 * d2 + p_228348_5_;
                            double d9 = d6 * d3 + p_228348_7_;
                            serverWorld.m_8767_(pParticleData, (double)pPos.m_123341_() + d7, (double)pPos.m_123342_() + d8, (double)pPos.m_123343_() + d9, 0, d4 - 0.5, d5 - 0.5, d6 - 0.5, 0.5);
                        }
                    }
                }
            });
        }
    }

    public static void addParticlesAroundSelf(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity) {
        for (int i = 0; i < 5; ++i) {
            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
            serverLevel.m_8767_(particleOptions, entity.m_20208_(1.0), entity.m_20187_() + 1.0, entity.m_20262_(1.0), 0, d0, d1, d2, 0.5);
        }
    }

    public static void addParticlesAroundMiddleSelf(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity) {
        for (int i = 0; i < 5; ++i) {
            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
            serverLevel.m_8767_(particleOptions, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0, d0, d1, d2, 0.5);
        }
    }

    public static void addGroundAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity, float radius) {
        serverLevel.m_8767_(particleOptions, entity.m_20185_() + Math.cos((double)entity.f_19797_ * 0.25) * (double)radius, entity.m_20186_(), entity.m_20189_() + Math.sin((double)entity.f_19797_ * 0.25) * (double)radius, 0, 0.0, 0.0, 0.0, 0.5);
        serverLevel.m_8767_(particleOptions, entity.m_20185_() + Math.cos((double)entity.f_19797_ * 0.25 + Math.PI) * (double)radius, entity.m_20186_(), entity.m_20189_() + Math.sin((double)entity.f_19797_ * 0.25 + Math.PI) * (double)radius, 0, 0.0, 0.0, 0.0, 0.5);
    }

    public static void addAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity, float radius) {
        serverLevel.m_8767_(particleOptions, entity.m_20185_() + Math.cos((double)entity.f_19797_ * 0.25) * (double)radius, entity.m_20186_() + 0.5, entity.m_20189_() + Math.sin((double)entity.f_19797_ * 0.25) * (double)radius, 0, 0.0, 0.0, 0.0, 0.5);
        serverLevel.m_8767_(particleOptions, entity.m_20185_() + Math.cos((double)entity.f_19797_ * 0.25 + Math.PI) * (double)radius, entity.m_20186_() + 0.5, entity.m_20189_() + Math.sin((double)entity.f_19797_ * 0.25 + Math.PI) * (double)radius, 0, 0.0, 0.0, 0.0, 0.5);
    }

    public static void addAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Vec3 vec3, float radius) {
        ServerParticleUtil.addAuraParticles(serverLevel, particleOptions, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0, radius);
    }

    public static void addAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, float radius) {
        ServerParticleUtil.addAuraParticles(serverLevel, particleOptions, x, y, z, 0.0, 0.0, 0.0, radius);
    }

    public static void addAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float radius) {
        serverLevel.m_8767_(particleOptions, x + Math.cos((double)serverLevel.m_46467_() * 0.25) * (double)radius, y, z + Math.sin((double)serverLevel.m_46467_() * 0.25) * (double)radius, 0, xSpeed, ySpeed, zSpeed, 0.5);
        serverLevel.m_8767_(particleOptions, x + Math.cos((double)serverLevel.m_46467_() * 0.25 + Math.PI) * (double)radius, y, z + Math.sin((double)serverLevel.m_46467_() * 0.25 + Math.PI) * (double)radius, 0, xSpeed, ySpeed, zSpeed, 0.5);
    }

    public static void addReverseAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Vec3 vec3, float radius) {
        ServerParticleUtil.addReverseAuraParticles(serverLevel, particleOptions, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0, radius);
    }

    public static void addReverseAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, float radius) {
        ServerParticleUtil.addReverseAuraParticles(serverLevel, particleOptions, x, y, z, 0.0, 0.0, 0.0, radius);
    }

    public static void addReverseAuraParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float radius) {
        serverLevel.m_8767_(particleOptions, x + Math.sin((double)serverLevel.m_46467_() * 0.25) * (double)radius, y, z + Math.cos((double)serverLevel.m_46467_() * 0.25) * (double)radius, 0, xSpeed, ySpeed, zSpeed, 0.5);
        serverLevel.m_8767_(particleOptions, x + Math.sin((double)serverLevel.m_46467_() * 0.25 + Math.PI) * (double)radius, y, z + Math.cos((double)serverLevel.m_46467_() * 0.25 + Math.PI) * (double)radius, 0, xSpeed, ySpeed, zSpeed, 0.5);
    }

    public static void circularParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity, float radius) {
        ServerParticleUtil.circularParticles(serverLevel, particleOptions, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius);
    }

    public static void circularParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity, double xSpeed, double ySpeed, double zSpeed, float radius) {
        ServerParticleUtil.circularParticles(serverLevel, particleOptions, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), xSpeed, ySpeed, zSpeed, radius);
    }

    public static void circularParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, float radius) {
        ServerParticleUtil.circularParticles(serverLevel, particleOptions, x, y, z, 0.0, 0.0, 0.0, radius);
    }

    public static void circularParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float radius) {
        float f5 = (float)Math.PI * radius * radius;
        int k1 = 0;
        while ((float)k1 < f5) {
            float f6 = serverLevel.f_46441_.m_188501_() * ((float)Math.PI * 2);
            float f7 = Mth.m_14116_((float)serverLevel.f_46441_.m_188501_()) * radius;
            float f8 = Mth.m_14089_((float)f6) * f7;
            float f9 = Mth.m_14031_((float)f6) * f7;
            serverLevel.m_8767_(particleOptions, x + (double)f8, y, z + (double)f9, 0, xSpeed, ySpeed, zSpeed, 0.5);
            ++k1;
        }
    }

    public static void circularColoredParticles(ServerLevel serverLevel, ParticleOptions particleOptions, Entity entity, float radius, ColorUtil colorUtil) {
        ServerParticleUtil.circularColoredParticles(serverLevel, particleOptions, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, colorUtil);
    }

    public static void circularColoredParticles(ServerLevel serverLevel, ParticleOptions particleOptions, double x, double y, double z, float radius, ColorUtil colorUtil) {
        float f5 = (float)Math.PI * radius * radius;
        int k1 = 0;
        while ((float)k1 < f5) {
            float f6 = serverLevel.f_46441_.m_188501_() * ((float)Math.PI * 2);
            float f7 = Mth.m_14116_((float)serverLevel.f_46441_.m_188501_()) * radius;
            float f8 = Mth.m_14089_((float)f6) * f7;
            float f9 = Mth.m_14031_((float)f6) * f7;
            serverLevel.m_8767_(particleOptions, x + (double)f8, y, z + (double)f9, 1, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 0.0);
            ++k1;
        }
    }

    public static void createParticleBall(ParticleOptions pParticleData, Entity entity, ServerLevel serverLevel, int radius) {
        ServerParticleUtil.createParticleBall(pParticleData, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), serverLevel, radius);
    }

    public static void createParticleBall(ParticleOptions pParticleData, double x, double y, double z, ServerLevel serverLevel, int radius) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    double d3 = (double)j + (serverLevel.m_213780_().m_188500_() - serverLevel.m_213780_().m_188500_()) * 0.5;
                    double d4 = (double)i + (serverLevel.m_213780_().m_188500_() - serverLevel.m_213780_().m_188500_()) * 0.5;
                    double d5 = (double)k + (serverLevel.m_213780_().m_188500_() - serverLevel.m_213780_().m_188500_()) * 0.5;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5) / 0.5 + serverLevel.m_213780_().m_188583_() * 0.05;
                    serverLevel.m_8767_(pParticleData, x, y, z, 0, d3 / d6, d4 / d6, d5 / d6, 0.5);
                    if (i == -radius || i == radius || j == -radius || j == radius) continue;
                    k += radius * 2 - 1;
                }
            }
        }
    }

    public static void windParticle(ServerLevel serverLevel, ColorUtil color, float width, float height, int id, Vec3 vec3) {
        ServerParticleUtil.windParticle(serverLevel, color, width, height, 0, id, vec3);
    }

    public static void windParticle(ServerLevel serverLevel, ColorUtil color, float width, float height, int life, int id, Vec3 vec3) {
        serverLevel.m_8767_((ParticleOptions)new WindParticleOption(color, width, height, life, id), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void windShockwaveParticle(ServerLevel serverLevel, ColorUtil color, float width, float height, int id, Vec3 vec3) {
        ServerParticleUtil.windShockwaveParticle(serverLevel, color, width, height, 0.25f, id, vec3);
    }

    public static void windShockwaveParticle(ServerLevel serverLevel, ColorUtil color, float width, float height, int life, int id, Vec3 vec3) {
        ServerParticleUtil.windShockwaveParticle(serverLevel, color, width, height, 0.25f, life, id, vec3);
    }

    public static void windShockwaveParticle(ServerLevel serverLevel, ColorUtil color, float width, float height, float increase, int id, Vec3 vec3) {
        ServerParticleUtil.windShockwaveParticle(serverLevel, color, width, height, increase, 0, id, vec3);
    }

    public static void windShockwaveParticle(ServerLevel serverLevel, ColorUtil color, float width, float height, float increase, int life, int id, Vec3 vec3) {
        for (int i = 0; i < 8; ++i) {
            serverLevel.m_8767_((ParticleOptions)new WindShockwaveParticle.Option(color, width, height, increase, (float)i * 0.125f, life, id), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

