/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.api.items.magic.IFocus;
import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.items.handler.FocusBagItemHandler;
import com.Polarice3.Goety.common.items.magic.FocusBag;
import com.Polarice3.Goety.compat.curios.CuriosLoaded;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class TotemFinder {
    private static boolean isFocusBag(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof FocusBag;
    }

    public static ItemStack findBag(Player playerEntity) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).map(inv -> inv.findFirstCurio(TotemFinder::isFocusBag)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        for (int i = 0; i < playerEntity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
            if (itemStack.m_41619_() || !TotemFinder.isFocusBag(itemStack)) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }

    public static ItemStack findFocusInBag(Player player) {
        ItemStack foundStack = ItemStack.f_41583_;
        if (!TotemFinder.findBag(player).m_41619_()) {
            FocusBagItemHandler focusBagItemHandler = FocusBagItemHandler.get(TotemFinder.findBag(player));
            for (int i = 1; i < focusBagItemHandler.getSlots(); ++i) {
                ItemStack itemStack = focusBagItemHandler.getStackInSlot(i);
                if (!(itemStack.m_41720_() instanceof IFocus)) continue;
                foundStack = itemStack;
            }
        }
        return foundStack;
    }

    public static int getFocusBagTotal(Player player) {
        int num = 0;
        if (!TotemFinder.findBag(player).m_41619_()) {
            FocusBagItemHandler focusBagItemHandler = FocusBagItemHandler.get(TotemFinder.findBag(player));
            for (int i = 1; i < focusBagItemHandler.getSlots(); ++i) {
                ItemStack itemStack = focusBagItemHandler.getStackInSlot(i);
                if (!(itemStack.m_41720_() instanceof IFocus)) continue;
                ++num;
            }
        }
        return num;
    }

    public static boolean hasEmptyBagSpace(Player player) {
        int total = 10;
        if (!TotemFinder.findBag(player).m_41619_()) {
            FocusBagItemHandler focusBagItemHandler = FocusBagItemHandler.get(TotemFinder.findBag(player));
            total = focusBagItemHandler.getSlots();
        }
        return TotemFinder.getFocusBagTotal(player) < total;
    }

    public static boolean hasFocusInBag(Player player) {
        return !TotemFinder.findFocusInBag(player).m_41619_();
    }

    public static boolean canOpenWandCircle(Player player) {
        return TotemFinder.hasFocusInBag(player) || WandUtil.hasFocusInInv(player) || !WandUtil.findFocus((LivingEntity)player).m_41619_();
    }

    private static boolean isTotem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ITotem;
    }

    public static ItemStack FindTotem(Player playerEntity) {
        Optional slotResult;
        ItemStack foundStack = ItemStack.f_41583_;
        if (CuriosLoaded.CURIOS.isLoaded() && (slotResult = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).map(inv -> inv.findFirstCurio(TotemFinder::isTotem)).orElse(Optional.empty())).isPresent()) {
            foundStack = ((SlotResult)slotResult.get()).stack();
        }
        if (TotemFinder.isTotem(playerEntity.m_21206_())) {
            foundStack = playerEntity.m_21206_();
        } else {
            for (int i = 0; i <= 9; ++i) {
                ItemStack itemStack = playerEntity.m_150109_().m_8020_(i);
                if (itemStack.m_41619_() || !TotemFinder.isTotem(itemStack)) continue;
                foundStack = itemStack;
                break;
            }
        }
        return foundStack;
    }
}

