/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.merrysnow;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="merrysnow", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.ConfigValue<Boolean> MERRY_SNOW_LAYER;
    public static ForgeConfigSpec.ConfigValue<Boolean> MERRY_POWDER_SNOW;
    public static ForgeConfigSpec.ConfigValue<Boolean> MERRY_SNOW_WEATHER;
    public static ForgeConfigSpec.DoubleValue SUNNY_SNOW;
    public static ForgeConfigSpec.ConfigValue<Boolean> RANDOM_SUNNY_SNOW;
    public static ForgeConfigSpec.ConfigValue<String> ENFORCE_SNOW_WEATHER;
    public static ForgeConfigSpec.ConfigValue<String> ENFORCE_SNOW_COVER;
    public static ForgeConfigSpec.ConfigValue<String> ENFORCE_ICE_FREEZE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> WEATHER_MODIFY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SNOW_MODIFY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> FREEZE_MODIFY;
    static final ForgeConfigSpec SPEC;

    public static String getWeatherModify(String id) {
        for (String b : (List)WEATHER_MODIFY.get()) {
            String[] entry = b.split("=");
            if (!entry[0].equals(id)) continue;
            return entry[1];
        }
        return "default";
    }

    public static String getSnowModify(String id) {
        for (String b : (List)SNOW_MODIFY.get()) {
            String[] entry = b.split("=");
            if (!entry[0].equals(id)) continue;
            return entry[1];
        }
        return "default";
    }

    public static String getFreezeModify(String id) {
        for (String b : (List)FREEZE_MODIFY.get()) {
            String[] entry = b.split("=");
            if (!entry[0].equals(id)) continue;
            return entry[1];
        }
        return "default";
    }

    static {
        BUILDER.push("Merry Snow");
        MERRY_SNOW_LAYER = BUILDER.comment("\u96ea\u7247\u65e0\u78b0\u649e\u3002").define("merrySnowLayer", true);
        MERRY_POWDER_SNOW = BUILDER.comment("\u7ec6\u96ea\u6709\u53f0\u9636\u78b0\u649e\u7bb1\u4e14\u65e0\u51b7\u51bb\u4f24\u5bb3\u3002").define("merryPowderSnow", true);
        MERRY_SNOW_WEATHER = BUILDER.comment("\u4e0b\u96ea\u533a\u5757\u4e0d\u5237\u602a\u3002").define("merrySnowWeather", true);
        BUILDER.pop();
        BUILDER.push("Sunny Snow");
        SUNNY_SNOW = BUILDER.comment("\u6674\u96ea\u6548\u679c\u7cfb\u6570\u3002").defineInRange("sunnySnow", 0.5, 0.1, 1.0);
        RANDOM_SUNNY_SNOW = BUILDER.comment("\u968f\u673a\u6674\u96ea\u6548\u679c\u3002").define("randomSunnySnow", false);
        BUILDER.pop();
        BUILDER.push("Biome Snow");
        ENFORCE_SNOW_WEATHER = BUILDER.comment("\u662f\u5426\u5168\u7fa4\u7cfb\u4e0b\u96ea\uff1atrue\u3001false\u3001default").define("enforceSnowWeather", (Object)"true");
        ENFORCE_SNOW_COVER = BUILDER.comment("\u662f\u5426\u5168\u7fa4\u7cfb\u79ef\u96ea\uff1atrue\u3001false\u3001default").define("enforceSnowCover", (Object)"false");
        ENFORCE_ICE_FREEZE = BUILDER.comment("\u662f\u5426\u5168\u7fa4\u7cfb\u7ed3\u51b0\uff1atrue\u3001false\u3001default").define("enforceIceFreeze", (Object)"default");
        WEATHER_MODIFY = BUILDER.comment("\"minecraft:forest=snow\", \"minecraft:ocean=rain\", \"minecraft:jungle=none\"").defineList("weatherModify", List.of(), entry -> entry instanceof String);
        SNOW_MODIFY = BUILDER.comment("\"minecraft:forest=true\", \"minecraft:ocean=false\"").defineList("snowModify", List.of(), entry -> entry instanceof String);
        FREEZE_MODIFY = BUILDER.comment("\"minecraft:forest=true\", \"minecraft:ocean=false\"").defineList("iceModify", List.of(), entry -> entry instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

