/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.merrysnow.init;

import com.sighs.merrysnow.Config;
import com.sighs.merrysnow.init.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static float redirectRainLevel(Level level, float value) {
        float origin = level.m_46722_(value);
        if (((Boolean)Config.RANDOM_SUNNY_SNOW.get()).booleanValue()) {
            return origin * ClientUtils.randomSunnySnow;
        }
        return origin * ((Double)Config.SUNNY_SNOW.get()).floatValue();
    }

    public static String getBiomeId(Biome biome) {
        ResourceLocation rl = ForgeRegistries.BIOMES.getKey((Object)biome);
        if (rl != null) {
            return rl.toString();
        }
        return null;
    }

    public static String getBiomeId(LevelReader level, Biome biome) {
        try {
            ResourceLocation rl = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
            return rl.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getBiomeId(Player player) {
        return Utils.getBiomeId((LevelReader)player.m_9236_(), (Biome)player.m_9236_().m_204166_(player.m_20183_()).get());
    }

    public static String getAlBiomeId(Player player) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            player.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_6566_().forEach(r -> result.add(r.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Utils.toJsonArray(result);
    }

    public static String toJsonArray(List<String> items) {
        if (items == null || items.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < items.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(items.get(i)).append("\"");
        }
        sb.append("]");
        return sb.toString();
    }
}

