/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms.registry.helper;

import com.khazoda.heirlooms.Constants;
import com.khazoda.heirlooms.registry.helper.Reggie;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;

public class Reginald {
    private final Map<ResourceKey<? extends Registry<?>>, Reggie<?>> registrars = new Object2ObjectLinkedOpenHashMap();

    public <T> Reggie<T> get(ResourceKey<? extends Registry<? super T>> key) {
        return this.registrars.computeIfAbsent(key, Reggie::new);
    }

    public void register(Registry<?> registry) {
        Reggie<?> registrar = this.registrars.get(registry.key());
        if (registrar == null) {
            return;
        }
        registrar.registerAll(registry);
    }

    public void registerAll() {
        for (Map.Entry<ResourceKey<Registry<?>>, Reggie<?>> entry : this.registrars.entrySet()) {
            Optional registry = BuiltInRegistries.REGISTRY.get(entry.getKey());
            if (!registry.isPresent()) {
                Constants.LOG.error("No registry found with the key {}", entry.getKey());
                continue;
            }
            entry.getValue().registerAll((Registry)((Holder.Reference)registry.get()).value());
        }
    }
}

