/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.InvMoveNoOp;
import me.pieking1215.invmove.module.CVComponent;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.VanillaModule;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4666;
import net.minecraft.class_5250;
import net.minecraft.class_743;
import net.minecraft.class_744;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InvMove {
    public static final String MOD_ID = "invmove";
    public static final Logger LOGGER = LogManager.getLogger();
    private static InvMove instance;
    private static final class_304 TOGGLE_MOVEMENT_KEY;
    private static final List<Module> addonModules;
    private final HashMap<Class<?>, Optional<String>> modidFromClassCache = new HashMap();
    protected boolean wasSneaking = false;
    protected boolean wasMovementDisallowed = false;
    protected boolean wasToggleMovementPressed = false;
    protected Map<class_4666, Boolean> wasToggleKeyDown = new HashMap<class_4666, Boolean>();
    protected boolean forceRawKeyDown = false;
    public final List<Module> modules = new ArrayList<Module>();

    public static InvMove instance() {
        if (instance == null) {
            instance = new InvMoveNoOp();
        }
        return instance;
    }

    public static void setInstance(InvMove newInstance) {
        instance = newInstance;
    }

    public static void registerModule(Module module) {
        LOGGER.info("Registered Module: {}", (Object)module);
        (instance != null ? InvMove.instance.modules : addonModules).add(module);
    }

    protected abstract Optional<String> modidFromClassInternal(Class<?> var1);

    public Optional<String> modidFromClass(Class<?> c) {
        return this.modidFromClassCache.computeIfAbsent(c, this::modidFromClassInternal);
    }

    public abstract String modNameFromModid(String var1);

    public abstract boolean hasMod(String var1);

    public abstract File configDir();

    protected abstract void registerKeybind(class_304 var1);

    public class_5250 translatableComponent(String key) {
        return new class_2588(key);
    }

    public class_5250 literalComponent(String text) {
        return new class_2585(text);
    }

    public class_5250 fromCV(CVComponent c) {
        if (c.translate) {
            return this.translatableComponent(c.text);
        }
        return this.literalComponent(c.text);
    }

    public boolean optionToggleCrouch() {
        return class_310.method_1551().field_1690.field_21332;
    }

    public void setOptionToggleCrouch(boolean toggleCrouch) {
        class_310.method_1551().field_1690.field_21332 = toggleCrouch;
    }

    protected void drawShadow(class_327 font, class_4587 poseStack, String string, float x, float y, int col) {
        font.method_1729(poseStack, string, x, y, col);
    }

    public class_2960 parseResource(String path) {
        return new class_2960(path);
    }

    public InvMove() {
        this.modules.addAll(addonModules);
        addonModules.clear();
        this.modules.add(0, this.getVanillaModule());
        this.registerKeybind(TOGGLE_MOVEMENT_KEY);
    }

    public Module getVanillaModule() {
        return new VanillaModule();
    }

    public void finishInit() {
        InvMoveConfig.load();
    }

    private boolean handleToggleMovementKey(class_437 screen, boolean couldMove) {
        if (TOGGLE_MOVEMENT_KEY.method_1415()) {
            return couldMove;
        }
        TOGGLE_MOVEMENT_KEY.method_23481(class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)InvMove.TOGGLE_MOVEMENT_KEY.field_1655.method_1444()));
        boolean before = this.wasToggleMovementPressed;
        this.wasToggleMovementPressed = InvMove.TOGGLE_MOVEMENT_KEY.field_1653;
        if (InvMove.TOGGLE_MOVEMENT_KEY.field_1653 && !before) {
            if (screen == null) {
                InvMoveConfig.MOVEMENT.ENABLED.set((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get() == false);
                return couldMove;
            }
            if (couldMove && ((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
            if (!couldMove && !((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(true);
                if (this.allowMovementInScreen(screen)) {
                    return true;
                }
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
        }
        return couldMove;
    }

    private boolean shouldSneak(InvMoveConfig.Movement.SneakMode sneakMode, boolean shiftIsDown) {
        switch (sneakMode) {
            case Off: {
                return false;
            }
            case MaintainWhilePressed: {
                if (!shiftIsDown) {
                    this.wasSneaking = false;
                }
            }
            case Maintain: {
                return this.wasSneaking;
            }
            case Pressed: {
                return shiftIsDown;
            }
        }
        return false;
    }

    public void onInputUpdate(class_744 input, boolean sneaking) {
        if (class_310.method_1551().field_1724 == null) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (input.getClass() != class_743.class || input != class_310.method_1551().field_1724.field_3913) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (class_310.method_1551().field_1755 == null) {
            this.wasSneaking = input.field_3903;
        }
        boolean canMove = this.allowMovementInScreen(class_310.method_1551().field_1755);
        if (canMove = this.handleToggleMovementKey(class_310.method_1551().field_1755, canMove)) {
            this.wasMovementDisallowed = false;
            this.tickKeybinds();
            boolean shiftIsDown = class_310.method_1551().field_1690.field_1832.field_1653;
            class_310.method_1551().field_1690.field_1869.method_23481(false);
            if (!this.optionToggleCrouch()) {
                if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5765()) {
                    class_310.method_1551().field_1690.field_1832.method_23481((Boolean)InvMoveConfig.MOVEMENT.DISMOUNT.get() != false && class_310.method_1551().field_1690.field_1832.field_1653);
                } else {
                    boolean isCreativeFlying = class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_31549().field_7479;
                    InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_FLYING.get()) : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get());
                    boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                    class_310.method_1551().field_1690.field_1832.method_23481(sneakKey);
                }
            }
            this.inputTickRaw(input, sneaking);
        } else if (class_310.method_1551().field_1755 != null) {
            if (!this.wasMovementDisallowed) {
                for (class_304 key : class_304.field_1657.values()) {
                    if (!this.allowKey(key)) continue;
                    key.method_1425();
                }
            }
            this.wasMovementDisallowed = true;
            if (!(!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue() || this.optionToggleCrouch() || class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5765())) {
                this.tickKeybind(class_310.method_1551().field_1690.field_1832);
                boolean shiftIsDown = class_310.method_1551().field_1690.field_1832.field_1653;
                boolean isCreativeFlying = class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_31549().field_7479;
                InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? InvMoveConfig.Movement.SneakMode.Off : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_DISALLOWED.get());
                boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                class_310.method_1551().field_1690.field_1832.method_23481(sneakKey);
                input.field_3903 = sneakKey;
            }
        } else {
            this.wasMovementDisallowed = false;
        }
    }

    private void tickKeybinds() {
        for (class_304 k : class_304.field_1657.values()) {
            if (!this.allowKey(k)) continue;
            this.tickKeybind(k);
        }
    }

    private void tickKeybind(class_304 k) {
        if (k.field_1655.method_1442() == class_3675.class_307.field_1668 && k.field_1655.method_1444() != class_3675.field_16237.method_1444()) {
            boolean raw = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)k.field_1655.method_1444());
            if (k instanceof class_4666 && ((class_4666)k).field_21334.getAsBoolean()) {
                if (this.wasToggleKeyDown.containsKey(k) && !this.wasToggleKeyDown.get(k).booleanValue() && raw) {
                    if (k == class_310.method_1551().field_1690.field_1832) {
                        if (InvMoveConfig.MOVEMENT.SNEAK.get() == InvMoveConfig.Movement.SneakMode.Pressed) {
                            k.method_23481(true);
                        }
                    } else {
                        k.method_23481(true);
                    }
                }
                this.wasToggleKeyDown.put((class_4666)k, raw);
            } else {
                k.method_23481(raw);
            }
        }
    }

    public boolean allowKey(class_304 key) {
        String k = key.method_1431();
        if (InvMoveConfig.MOVEMENT.allowedKeys.containsKey(k)) {
            return InvMoveConfig.MOVEMENT.allowedKeys.get(k);
        }
        boolean allow = this.allowKeyDefault(key);
        InvMoveConfig.MOVEMENT.allowedKeys.put(k, allow);
        return allow;
    }

    public boolean allowKeyDefault(class_304 key) {
        for (Module module : this.modules) {
            Optional<Boolean> def = module.allowKeyDefault(key);
            if (!def.isPresent()) continue;
            return def.get();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean allowMovementInScreen(class_437 screen) {
        void var2_8;
        if (screen == null) {
            return false;
        }
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (class_310.method_1551().method_1493()) {
            return false;
        }
        Optional optional = Optional.empty();
        block7: for (Module mod : this.modules) {
            Module.Movement res = mod.shouldAllowMovement(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_ENABLE: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block7;
                }
                case FORCE_DISABLE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block7;
                }
                case SUGGEST_ENABLE: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_DISABLE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (var2_8.isPresent()) {
            return (Boolean)var2_8.get();
        }
        Class<?> cl = screen.getClass();
        String modid = this.modidFromClass(cl).orElse("?unknown");
        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
        HashMap<Class<? extends class_437>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
        if (!hm.containsKey(cl)) {
            hm.put(cl, (Boolean)InvMoveConfig.MOVEMENT.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
        }
        return hm.get(cl);
    }

    public static Field[] getDeclaredFieldsSuper(Class<?> aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    public void inputTickRaw(class_744 input, boolean sneaking) {
        this.forceRawKeyDown = true;
        input.method_3129(sneaking);
        this.forceRawKeyDown = false;
    }

    public boolean shouldForceRawKeyDown() {
        return this.forceRawKeyDown;
    }

    public <T> T withRawKeyDown(Supplier<T> r) {
        boolean was = this.forceRawKeyDown;
        this.forceRawKeyDown = true;
        T v = r.get();
        this.forceRawKeyDown = was;
        return v;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean shouldDisableScreenBackground(class_437 screen) {
        void var2_8;
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.BACKGROUND.BACKGROUND_HIDE.get()).booleanValue()) {
            return false;
        }
        if (screen == null) {
            return false;
        }
        if (screen.method_25421()) {
            switch ((InvMoveConfig.Background.PauseScreenMode)((Object)InvMoveConfig.BACKGROUND.HIDE_ON_PAUSE.get())) {
                case Show: {
                    return false;
                }
                case AllowHide: {
                    break;
                }
                case ShowSP: {
                    if (!class_310.method_1551().method_1496()) break;
                    if (class_310.method_1551().method_1576() == null) return false;
                    if (class_310.method_1551().method_1576().method_3860()) break;
                    return false;
                }
            }
        }
        Optional optional = Optional.empty();
        block12: for (Module mod : this.modules) {
            Module.Background res = mod.shouldHideBackground(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_SHOW: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block12;
                }
                case FORCE_HIDE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block12;
                }
                case SUGGEST_SHOW: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_HIDE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (!var2_8.isPresent()) {
            Class<?> cl = screen.getClass();
            String modid = this.modidFromClass(cl).orElse("?unknown");
            InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
            HashMap<Class<? extends class_437>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            if (hm.containsKey(cl)) return hm.get(cl);
            hm.put(cl, (Boolean)InvMoveConfig.BACKGROUND.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
            return hm.get(cl);
        }
        if ((Boolean)var2_8.get() != false) return false;
        return true;
    }

    public void drawDebugOverlay() {
        if (((Boolean)InvMoveConfig.GENERAL.DEBUG_DISPLAY.get()).booleanValue()) {
            class_437 screen = class_310.method_1551().field_1755;
            if (screen == null) {
                return;
            }
            int i = 0;
            Class<?> cl = screen.getClass();
            while (cl.getSuperclass() != null) {
                Optional<String> modid;
                Object className = cl.getName();
                if (((String)className).startsWith("net.minecraft.")) {
                    className = ((String)className).substring("net.minecraft.".length());
                }
                if ((modid = this.modidFromClass(cl)).isPresent()) {
                    className = "[" + modid.get() + "] " + (String)className;
                }
                if (this.shouldDisableScreenBackground(screen)) {
                    className = "B" + (String)className;
                }
                if (this.allowMovementInScreen(screen)) {
                    className = "M" + (String)className;
                }
                this.drawShadow(class_310.method_1551().field_1772, new class_4587(), (String)className, 4.0f, 4 + 10 * i, -1);
                ++i;
                cl = cl.getSuperclass();
            }
        }
    }

    static {
        TOGGLE_MOVEMENT_KEY = new class_304("keybind.invmove.toggleMove", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "key.category.invmove.main");
        addonModules = new ArrayList<Module>();
    }
}

