/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove.forge;

import java.io.File;
import java.security.CodeSource;
import java.util.Optional;
import me.pieking1215.invmove.InvMove;
import me.pieking1215.invmove.InvMoveConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvMoveForgeClient {
    static void finishInit() {
        InvMove.instance().finishInit();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGUIDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        InvMove.instance().drawDebugOverlay();
    }

    static void clientSetup(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "", (a, b) -> true));
        MinecraftForge.EVENT_BUS.register((Object)new InvMoveForgeClient());
        InvMove.setInstance(new InvMove(){

            @Override
            protected Optional<String> modidFromClassInternal(Class<?> c) {
                if (c.getPackage().getName().startsWith("net.minecraft.")) {
                    return Optional.of("minecraft");
                }
                return ModList.get().applyForEachModContainer(mod -> {
                    boolean eq;
                    CodeSource src1 = c.getProtectionDomain().getCodeSource();
                    CodeSource src2 = mod.getMod().getClass().getProtectionDomain().getCodeSource();
                    boolean bl = eq = src1 != null && src2 != null && src1.getLocation().equals(src2.getLocation());
                    if (eq) {
                        return Optional.of(mod.getModId());
                    }
                    return Optional.empty();
                }).filter(Optional::isPresent).map(Optional::get).findFirst();
            }

            @Override
            public String modNameFromModid(String modid) {
                return ModList.get().getModContainerById(modid).map(con -> con.getModInfo().getDisplayName()).orElse(modid);
            }

            @Override
            public boolean hasMod(String modid) {
                return ModList.get().isLoaded(modid);
            }

            @Override
            public File configDir() {
                return FMLPaths.CONFIGDIR.get().toFile();
            }

            @Override
            protected void registerKeybind(KeyBinding key) {
                key.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.UNIVERSAL);
                Minecraft.func_71410_x().field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])Minecraft.func_71410_x().field_71474_y.field_74324_K, (Object)key);
            }
        });
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> InvMoveConfig.setupCloth(screen));
    }
}

