/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove.module.config;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import me.pieking1215.invmove.InvMove;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.module.config.ConfigBool;
import me.pieking1215.invmove.module.config.ConfigEntry;
import me.pieking1215.invmove.module.config.ConfigEnum;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ModuleConfig {
    final String id;
    final List<Pair<ConfigEntry<?>, ConfigEntryMeta>> entries;

    public ModuleConfig(String id) {
        this.id = id;
        this.entries = new ArrayList();
    }

    public ConfigBool bool(String display, String id, boolean defaultVal) {
        ConfigBool bool = new ConfigBool(defaultVal);
        this.entries.add(Pair.of((Object)bool, (Object)new ConfigEntryMeta(id, display)));
        return bool;
    }

    public ConfigBool bool(String id, boolean defaultVal) {
        ConfigBool bool = new ConfigBool(defaultVal);
        this.entries.add(Pair.of((Object)bool, (Object)new ConfigEntryMeta(id, null)));
        return bool;
    }

    public <T extends Enum<T>> ConfigEnum<T> addEnum(String display, String id, T defaultVal) {
        ConfigEnum<T> entry = new ConfigEnum<T>(defaultVal);
        this.entries.add(Pair.of(entry, (Object)new ConfigEntryMeta(id, display)));
        return entry;
    }

    public <T extends Enum<T>> ConfigEnum<T> addEnum(String id, T defaultVal) {
        ConfigEnum<T> entry = new ConfigEnum<T>(defaultVal);
        this.entries.add(Pair.of(entry, (Object)new ConfigEntryMeta(id, null)));
        return entry;
    }

    public void label(String id) {
        class None {
            None() {
            }
        }
        this.entries.add(Pair.of((Object)new ConfigEntry<None>(new None()){
            {
                super(defaultValue);
            }

            @Override
            void addTo(ConfigCategory category, ConfigEntryBuilder eb, String id) {
                category.addEntry((AbstractConfigListEntry)eb.startTextDescription((ITextComponent)InvMove.instance().translatableComponent(id)).build());
            }

            @Override
            void addTo(SubCategoryBuilder category, ConfigEntryBuilder eb, String id) {
                category.add((AbstractConfigListEntry)eb.startTextDescription((ITextComponent)InvMove.instance().translatableComponent(id)).build());
            }

            @Override
            void write(JsonObject json, String id) {
            }

            @Override
            void read(JsonObject json, String id) {
            }
        }, (Object)new ConfigEntryMeta(id, null)));
    }

    public void addTo(ConfigCategory category, ConfigEntryBuilder eb, String id) {
        for (Pair<ConfigEntry<?>, ConfigEntryMeta> pair : this.entries) {
            ConfigEntry entry = (ConfigEntry)pair.getFirst();
            ConfigEntryMeta meta = (ConfigEntryMeta)pair.getSecond();
            entry.addTo(category, eb, (id.isEmpty() ? "" : id + ".") + this.id + "." + meta.id);
        }
        if (this.entries.isEmpty()) {
            category.addEntry((AbstractConfigListEntry)eb.startTextDescription((ITextComponent)InvMove.instance().translatableComponent("key.invmove.module.nooptions").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC})).build());
        }
    }

    public void addTo(ConfigCategory category, ConfigEntryBuilder eb) {
        this.addTo(category, eb, "");
    }

    public void addTo(SubCategoryBuilder category, ConfigEntryBuilder eb, String id) {
        for (Pair<ConfigEntry<?>, ConfigEntryMeta> pair : this.entries) {
            ConfigEntry entry = (ConfigEntry)pair.getFirst();
            ConfigEntryMeta meta = (ConfigEntryMeta)pair.getSecond();
            entry.addTo(category, eb, meta.display == null ? (id.isEmpty() ? "" : id + ".") + this.id + "." + meta.id : meta.display);
        }
        if (this.entries.isEmpty()) {
            category.add((AbstractConfigListEntry)eb.startTextDescription((ITextComponent)InvMove.instance().translatableComponent("key.invmove.module.nooptions").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC})).build());
        }
    }

    public void addTo(SubCategoryBuilder category, ConfigEntryBuilder eb) {
        this.addTo(category, eb, "");
    }

    public void write(JsonObject json) {
        JsonObject myObj = InvMoveConfig.getOrPutJsonObject(json, this.id);
        for (Pair<ConfigEntry<?>, ConfigEntryMeta> p : this.entries) {
            ((ConfigEntry)p.getFirst()).write(myObj, ((ConfigEntryMeta)p.getSecond()).id);
        }
    }

    public void read(JsonObject json) {
        JsonObject myObj = json.getAsJsonObject(this.id);
        if (myObj != null) {
            for (Pair<ConfigEntry<?>, ConfigEntryMeta> p : this.entries) {
                ((ConfigEntry)p.getFirst()).read(myObj, ((ConfigEntryMeta)p.getSecond()).id);
            }
        }
    }

    public static class ConfigEntryMeta {
        public final String id;
        public final String display;

        public ConfigEntryMeta(String id, String display) {
            this.id = id;
            this.display = display;
        }
    }
}

