/*
 * Decompiled with CFR 0.152.
 */
package com.example.pilebunker;

import com.example.pilebunker.PileBunkerMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class PileBunkerItem
extends class_1764 {
    private static final float BASE_DAMAGE = 3.0f;
    private static final Map<class_2338, Float> blockDamageMap = new HashMap<class_2338, Float>();

    public PileBunkerItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public Predicate<class_1799> method_20310() {
        return stack -> false;
    }

    public Predicate<class_1799> method_19268() {
        return stack -> false;
    }

    public boolean method_58405(class_1799 stack, class_2680 state) {
        return state.method_26164(class_3481.field_33715) || state.method_26164(class_3481.field_33716);
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        return state.method_26164(class_3481.field_33715) || state.method_26164(class_3481.field_33716) ? 8.0f : 1.0f;
    }

    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 mainHand = player.method_5998(class_1268.field_5808);
        class_1799 offHand = player.method_5998(class_1268.field_5810);
        if (hand == class_1268.field_5810 && mainHand.method_7909() instanceof PileBunkerItem && offHand.method_7909() instanceof PileBunkerItem) {
            return class_1269.field_5811;
        }
        class_1799 itemStack = player.method_5998(hand);
        if (this.isChargedInternal(itemStack)) {
            this.performShooting(level, (class_1309)player, hand, itemStack, 3.15f, 1.0f);
            this.setChargedInternal(itemStack, false);
            return class_1269.field_21466;
        }
        player.method_6019(hand);
        return class_1269.field_21466;
    }

    public boolean method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeLeft) {
        int i = this.method_7881(stack, entity) - timeLeft;
        float f = this.getPowerForTime(i, stack, entity);
        if (f >= 1.0f && !this.isChargedInternal(stack)) {
            this.setChargedInternal(stack, true);
            class_3419 soundSource = entity instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            level.method_60511(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14626, soundSource, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                class_1799 mainHand = player.method_5998(class_1268.field_5808);
                class_1799 offHand = player.method_5998(class_1268.field_5810);
                if (stack == mainHand && offHand.method_7909() instanceof PileBunkerItem && !this.isChargedInternal(offHand)) {
                    player.method_6019(class_1268.field_5810);
                }
            }
            return true;
        }
        return false;
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        int i;
        float f;
        if (level.method_8608() || (f = this.getPowerForTime(i = this.method_7881(stack, livingEntity) - remainingUseDuration, stack, livingEntity)) < 1.0f || !(f >= 1.0f) || !this.isChargedInternal(stack)) {
            // empty if block
        }
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entity) {
        this.method_7840(stack, level, entity, 0);
        return stack;
    }

    private float getPowerForTime(int useTime, class_1799 stack, class_1309 entity) {
        float f = (float)useTime / (float)(class_1764.method_7775((class_1799)stack, (class_1309)entity) + 3);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private boolean isChargedInternal(class_1799 stack) {
        class_9278 chargedProjectiles = (class_9278)stack.method_58694(class_9334.field_49649);
        return chargedProjectiles != null && !chargedProjectiles.method_57442();
    }

    private void setChargedInternal(class_1799 stack, boolean charged) {
        if (charged) {
            stack.method_57379(class_9334.field_49649, (Object)class_9278.method_57439((class_1799)new class_1799((class_1935)PileBunkerMod.IRON_PILE)));
        } else {
            stack.method_57379(class_9334.field_49649, (Object)class_9278.field_49298);
        }
    }

    private int getEnchantmentLevel(class_1799 stack, class_5321<class_1887> enchantmentKey, class_1937 level) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41265);
        Optional holder = registry.method_46746(enchantmentKey);
        return holder.map(enchantmentHolder -> class_1890.method_8225((class_6880)enchantmentHolder, (class_1799)stack)).orElse(0);
    }

    public void performShooting(class_1937 level, class_1309 shooter, class_1268 hand, class_1799 stack, float velocity, float divergence) {
        if (level.method_8608()) {
            return;
        }
        int piercingLevel = this.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9132, level);
        int multishotLevel = this.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9108, level);
        int range = 3 + piercingLevel * 1;
        int height = 1 + (multishotLevel > 0 ? 1 : 0);
        class_243 eyePos = shooter.method_33571();
        class_243 lookVec = shooter.method_5720();
        int minedCount = 0;
        for (int r = 1; r <= range; ++r) {
            class_243 targetPos = eyePos.method_1019(lookVec.method_1021((double)r));
            class_2338 blockPos = class_2338.method_49638((class_2374)targetPos);
            for (int h = 0; h < height; ++h) {
                class_2338 currentPos = blockPos.method_10087(h);
                if (!this.mineBlock(level, shooter, currentPos, stack)) continue;
                ++minedCount;
            }
        }
        int maxTargets = 1 + piercingLevel;
        ArrayList<class_1297> hitEntities = new ArrayList<class_1297>();
        class_243 endPos = eyePos.method_1019(lookVec.method_1021((double)range));
        class_238 aabb = shooter.method_5829().method_18804(lookVec.method_1021((double)range)).method_1014(1.0);
        List entities = level.method_8333((class_1297)shooter, aabb, e -> e instanceof class_1309 && !e.method_7325() && e.method_5863());
        for (class_1297 entity : entities) {
            if (hitEntities.size() >= maxTargets) break;
            class_238 entityBox = entity.method_5829().method_1014(0.3);
            if (!entityBox.method_992(eyePos, endPos).isPresent()) continue;
            hitEntities.add(entity);
            float damage = 12.0f;
            entity.method_64419(level.method_48963().method_48802((class_1657)shooter), damage);
            if (!(entity instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity;
            living.method_6005(1.5, -lookVec.field_1352, -lookVec.field_1350);
        }
        if (shooter.method_5715()) {
            double recoilStrength = 0.5 + (double)minedCount * 0.2;
            class_243 recoilVec = lookVec.method_22882().method_1029().method_1021(recoilStrength);
            shooter.method_5762(recoilVec.field_1352, recoilVec.field_1351, recoilVec.field_1350);
            shooter.field_6037 = true;
        }
        level.method_60511(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 1.0f, 2.0f);
        class_1304 slot = hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171;
        stack.method_7970(1, shooter, slot);
    }

    private boolean mineBlock(class_1937 level, class_1309 shooter, class_2338 pos, class_1799 stack) {
        boolean shouldBreak;
        if (shooter.method_5715()) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        boolean isPickaxe = state.method_26164(class_3481.field_33715);
        boolean isShovel = state.method_26164(class_3481.field_33716);
        float hardness = state.method_26214((class_1922)level, pos);
        if (hardness < 0.0f) {
            return false;
        }
        boolean isObsidian = state.method_27852(class_2246.field_10540);
        boolean isAncientDebris = state.method_27852(class_2246.field_22109);
        if (isObsidian || isAncientDebris) {
            float damagePerHit = hardness / 3.0f + 0.5f;
            class_2338 immutablePos = pos.method_10062();
            float accumulatedDamage = blockDamageMap.getOrDefault(immutablePos, Float.valueOf(0.0f)).floatValue();
            if ((accumulatedDamage += damagePerHit) >= hardness) {
                blockDamageMap.remove(immutablePos);
                if (shooter instanceof class_3222) {
                    class_3222 player = (class_3222)shooter;
                    int silkTouchLevel = this.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9099, level);
                    class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)player, (class_1799)stack);
                    level.method_22352(pos, false);
                    return true;
                }
            } else {
                blockDamageMap.put(immutablePos, Float.valueOf(accumulatedDamage));
                level.method_8396(null, pos, class_3417.field_14658, class_3419.field_15245, 1.0f, 1.0f);
                return false;
            }
        }
        float damage = 3.0f;
        if (isPickaxe || isShovel) {
            damage *= 2.0f;
        }
        boolean bl = shouldBreak = damage >= hardness;
        if (shouldBreak && shooter instanceof class_3222) {
            class_3222 player = (class_3222)shooter;
            int silkTouchLevel = this.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9099, level);
            if (silkTouchLevel > 0) {
                class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)player, (class_1799)stack);
            } else {
                class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)player, (class_1799)stack);
            }
            level.method_22352(pos, false);
            return true;
        }
        return false;
    }
}

