/*
 * Decompiled with CFR 0.152.
 */
package com.example.markit;

import com.example.markit.ClientMarkerManager;
import com.example.markit.MarkItConfig;
import com.example.markit.PacketClearOldestMarker;
import com.example.markit.PacketHandler;
import com.example.markit.PacketMarkBlock;
import com.example.markit.PingType;
import com.example.markit.RadialWheelOverlay;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="markit", value={Dist.CLIENT})
public class ClientEvents {
    public static final KeyMapping MARK_KEY = new KeyMapping("key.markit.mark", 77, "key.categories.markit");
    public static final KeyMapping TOGGLE_KEY = new KeyMapping("key.markit.toggle", 88, "key.categories.markit");
    public static final KeyMapping CLEAR_KEY = new KeyMapping("key.markit.clear", 90, "key.categories.markit");
    private static boolean markersVisible = true;
    private static long lastMarkTime = 0L;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (TOGGLE_KEY.m_90859_()) {
                markersVisible = !markersVisible;
            }
            while (CLEAR_KEY.m_90859_()) {
                PacketHandler.INSTANCE.sendToServer((Object)new PacketClearOldestMarker());
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            if (MARK_KEY.m_90857_()) {
                if (!RadialWheelOverlay.isOpen()) {
                    RadialWheelOverlay.open();
                }
            } else if (RadialWheelOverlay.isOpen()) {
                HitResult result;
                long now;
                PingType selectedType = RadialWheelOverlay.getSelectedType();
                if (selectedType != null && (now = System.currentTimeMillis()) - lastMarkTime >= (long)((Integer)MarkItConfig.MARK_COOLDOWN.get()).intValue() && (result = mc.f_91074_.m_19907_((double)((Integer)MarkItConfig.MAX_MARK_DISTANCE.get()).intValue(), 0.0f, false)) != null && result.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult blockHit = (BlockHitResult)result;
                    BlockPos pos = blockHit.m_82425_();
                    PacketHandler.INSTANCE.sendToServer((Object)new PacketMarkBlock(pos, selectedType));
                    lastMarkTime = now;
                }
                RadialWheelOverlay.close();
            }
        }
    }

    @SubscribeEvent
    public static void onChatMessage(ClientChatReceivedEvent event) {
        String message;
        if (!markersVisible && (message = event.getMessage().getString()).contains(" marked ")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        double distSqr;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        if (!markersVisible) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = event.getCamera().m_90583_();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (ClientMarkerManager.Marker marker : ClientMarkerManager.getMarkers()) {
            long currentTime;
            long elapsed;
            long blinkCycle;
            distSqr = marker.pos.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
            if (marker.pingType == PingType.DANGER && (blinkCycle = (elapsed = (currentTime = System.currentTimeMillis()) - marker.creationTime) % 1000L) >= 500L || !(distSqr <= 2500.0)) continue;
            ClientEvents.renderMarkerCube(poseStack, buffer, marker, cameraPos);
        }
        tesselator.m_85914_();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (ClientMarkerManager.Marker marker : ClientMarkerManager.getMarkers()) {
            if (marker.pingType == PingType.DANGER || !((distSqr = marker.pos.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_)) > 2500.0)) continue;
            ClientEvents.renderMarkerOverlay(poseStack, buffer, marker, cameraPos);
        }
        tesselator.m_85914_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("markit", "textures/gui/danger.png"));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        for (ClientMarkerManager.Marker marker : ClientMarkerManager.getMarkers()) {
            double distSqr2;
            long currentTime;
            long elapsed;
            long blinkCycle;
            if (marker.pingType != PingType.DANGER || (blinkCycle = (elapsed = (currentTime = System.currentTimeMillis()) - marker.creationTime) % 1000L) >= 500L || !((distSqr2 = marker.pos.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_)) > 2500.0)) continue;
            ClientEvents.renderDangerOverlay(poseStack, buffer, marker, cameraPos);
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        for (ClientMarkerManager.Marker marker : ClientMarkerManager.getMarkers()) {
            long currentTime;
            long elapsed;
            long blinkCycle;
            if (marker.pingType == PingType.DANGER && (blinkCycle = (elapsed = (currentTime = System.currentTimeMillis()) - marker.creationTime) % 1000L) >= 500L) continue;
            ClientEvents.renderMarkerText(poseStack, marker, cameraPos, mc.f_91062_, (MultiBufferSource)bufferSource);
        }
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static void renderMarkerCube(PoseStack poseStack, BufferBuilder buffer, ClientMarkerManager.Marker marker, Vec3 cameraPos) {
        double x = (double)marker.pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)marker.pos.m_123342_() + 0.5 - cameraPos.f_82480_;
        double z = (double)marker.pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        float size = 0.6f;
        int color = marker.color;
        if (marker.pingType == PingType.DANGER) {
            color = 0xFF0000;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 0.6f;
        float s = size / 2.0f;
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y - (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y + (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y + (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y - (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y - (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y - (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y + (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y + (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y - (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y - (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y + (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y + (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y - (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y - (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y + (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y + (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y + (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y + (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y + (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y + (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y - (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y - (double)s), (float)(z - (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x + (double)s), (float)(y - (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)(x - (double)s), (float)(y - (double)s), (float)(z + (double)s)).m_85950_(r, g, b, a).m_5752_();
    }

    private static void renderDangerOverlay(PoseStack poseStack, BufferBuilder buffer, ClientMarkerManager.Marker marker, Vec3 cameraPos) {
        double x = (double)marker.pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)marker.pos.m_123342_() + 1.5 - cameraPos.f_82480_;
        double z = (double)marker.pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        double dist = Math.sqrt(marker.pos.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_));
        float scale = (float)dist * 0.02f;
        poseStack.m_85841_(scale, scale, scale);
        float size = 2.5f;
        float s = size / 2.0f;
        int color = marker.color;
        if (marker.pingType == PingType.DANGER) {
            color = 0xFF0000;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 1.0f;
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -s, -s, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), s, -s, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), s, s, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -s, s, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderMarkerOverlay(PoseStack poseStack, BufferBuilder buffer, ClientMarkerManager.Marker marker, Vec3 cameraPos) {
        double x = (double)marker.pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)marker.pos.m_123342_() + 1.5 - cameraPos.f_82480_;
        double z = (double)marker.pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        double dist = Math.sqrt(marker.pos.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_));
        float scale = (float)dist * 0.02f;
        poseStack.m_85841_(scale, scale, scale);
        float size = 0.5f;
        int color = marker.color;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 0.8f;
        float s = size / 2.0f;
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -s, -s, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), s, -s, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), s, s, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -s, s, 0.0f).m_85950_(r, g, b, a).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderMarkerText(PoseStack poseStack, ClientMarkerManager.Marker marker, Vec3 cameraPos, Font font, MultiBufferSource bufferSource) {
        int b;
        int g;
        int r;
        double dist = Math.sqrt(marker.pos.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_));
        double yOffset = 1.5;
        if (marker.pingType == PingType.DANGER && dist > 50.0) {
            yOffset = 0.0;
        }
        double x = (double)marker.pos.m_123341_() + 0.5 - cameraPos.f_82479_;
        double y = (double)marker.pos.m_123342_() + yOffset - cameraPos.f_82480_;
        double z = (double)marker.pos.m_123343_() + 0.5 - cameraPos.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        double scalingDist = dist;
        if (dist > 50.0) {
            scalingDist = 50.0 + (dist - 50.0) * 0.5;
        }
        float scale = (float)Math.max(1.0, scalingDist) * 0.005f;
        poseStack.m_85841_(-scale, -scale, scale);
        String text = String.format("%.1f m", dist);
        float offset = (float)(-font.m_92895_(text)) / 2.0f;
        int color = marker.color;
        if (marker.pingType == PingType.DANGER) {
            color = 0xFF0000;
        }
        if ((r = color >> 16 & 0xFF) + (g = color >> 8 & 0xFF) + (b = color & 0xFF) < 30) {
            r = 255;
            g = 255;
            b = 255;
        } else {
            r = (int)((float)r * 0.7f);
            g = (int)((float)g * 0.7f);
            b = (int)((float)b * 0.7f);
        }
        int darkenedColor = r << 16 | g << 8 | b;
        int colorWithAlpha = darkenedColor & 0xFFFFFF | 0xAA000000;
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_271703_(text, offset, 0.0f, colorWithAlpha, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        immediate.m_109911_();
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientMarkerManager.clear();
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ClientMarkerManager.clear();
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ClientMarkerManager.clear();
    }
}

