/*
 * Decompiled with CFR 0.152.
 */
package com.example.markit;

import com.example.markit.PingType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public class ClientMarkerManager {
    private static final List<Marker> markers = new ArrayList<Marker>();
    private static final long DURATION = 30000L;

    public static void addMarker(BlockPos pos, int color, PingType pingType) {
        markers.add(new Marker(pos, color, pingType));
    }

    public static List<Marker> getMarkers() {
        long now = System.currentTimeMillis();
        markers.removeIf(m -> now - m.creationTime > 30000L);
        return markers;
    }

    public static void removeMarker(BlockPos pos) {
        markers.removeIf(m -> m.pos.equals((Object)pos));
    }

    public static void clear() {
        markers.clear();
    }

    public static class Marker {
        public BlockPos pos;
        public int color;
        public PingType pingType;
        public long creationTime;

        public Marker(BlockPos pos, int color, PingType pingType) {
            this.pos = pos;
            this.color = color;
            this.pingType = pingType;
            this.creationTime = System.currentTimeMillis();
        }
    }
}

