/*
 * Decompiled with CFR 0.152.
 */
package com.example.markit;

import com.example.markit.PacketHandler;
import com.example.markit.PacketRemoveMarker;
import com.example.markit.PacketSyncMarker;
import com.example.markit.PingType;
import com.example.markit.ServerMarkerManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Team;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketMarkBlock {
    private final BlockPos pos;
    private final PingType pingType;

    public PacketMarkBlock(BlockPos pos, PingType pingType) {
        this.pos = pos;
        this.pingType = pingType;
    }

    public PacketMarkBlock(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.pingType = PingType.fromOrdinal(buf.readInt());
    }

    public static PacketMarkBlock decode(FriendlyByteBuf buf) {
        return new PacketMarkBlock(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.pingType.ordinal());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PacketRemoveMarker removePacket;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Team team = player.m_5647_();
            int color = team != null && team.m_7414_().m_126665_() != null ? team.m_7414_().m_126665_().intValue() : this.pingType.getDefaultColor();
            BlockPos removedPos = ServerMarkerManager.addMarker(player.m_20148_(), this.pos);
            PacketSyncMarker syncPacket = new PacketSyncMarker(this.pos, color, this.pingType);
            PacketRemoveMarker packetRemoveMarker = removePacket = removedPos != null ? new PacketRemoveMarker(removedPos) : null;
            if (team != null) {
                player.f_8924_.m_6846_().m_11314_().forEach(p -> {
                    if (p.m_5647_() != null && p.m_5647_().m_83536_(team)) {
                        if (removePacket != null) {
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)removePacket);
                        }
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)syncPacket);
                        String msgText = player.m_36316_().getName() + " marked " + this.pos.m_123344_();
                        p.m_213846_((Component)Component.m_237113_((String)msgText).m_130940_(team.m_7414_()));
                    }
                });
            } else {
                if (removePacket != null) {
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)removePacket);
                }
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncPacket);
                String msgText = player.m_36316_().getName() + " marked " + this.pos.m_123344_();
                player.m_213846_((Component)Component.m_237113_((String)msgText));
            }
        });
        return true;
    }
}

