/*
 * Decompiled with CFR 0.152.
 */
package com.example.markit;

import com.example.markit.ClientMarkerManager;
import com.example.markit.PingType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncMarker {
    private final BlockPos pos;
    private final int color;
    private final PingType pingType;

    public PacketSyncMarker(BlockPos pos, int color, PingType pingType) {
        this.pos = pos;
        this.color = color;
        this.pingType = pingType;
    }

    public PacketSyncMarker(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.color = buf.readInt();
        this.pingType = PingType.fromOrdinal(buf.readInt());
    }

    public static PacketSyncMarker decode(FriendlyByteBuf buf) {
        return new PacketSyncMarker(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.color);
        buf.writeInt(this.pingType.ordinal());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientMarkerManager.addMarker(this.pos, this.color, this.pingType));
        return true;
    }
}

