/*
 * Decompiled with CFR 0.152.
 */
package com.example.markit;

import com.example.markit.PingType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;

public class RadialWheelOverlay
implements IGuiOverlay {
    private static boolean isOpen = false;
    private static PingType selectedType = PingType.STANDARD;

    public static void open() {
        isOpen = true;
        Minecraft.m_91087_().f_91067_.m_91602_();
    }

    public static void close() {
        isOpen = false;
        Minecraft.m_91087_().f_91067_.m_91601_();
    }

    public static boolean isOpen() {
        return isOpen;
    }

    public static PingType getSelectedType() {
        return selectedType;
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        double mouseY;
        double dy;
        if (!isOpen) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        double mouseX = mc.f_91067_.m_91589_() * (double)screenWidth / (double)mc.m_91268_().m_85443_();
        double dx = mouseX - (double)centerX;
        double distance = Math.sqrt(dx * dx + (dy = (mouseY = mc.f_91067_.m_91594_() * (double)screenHeight / (double)mc.m_91268_().m_85444_()) - (double)centerY) * dy);
        boolean isValidSelection = distance > 40.0 && distance < 120.0;
        PingType hoveredType = null;
        if (isValidSelection) {
            double angle = Math.atan2(dy, dx);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (angle >= 1.5707963267948966 && angle < 4.71238898038469) {
                selectedType = PingType.DANGER;
                hoveredType = PingType.DANGER;
            } else {
                selectedType = PingType.STANDARD;
                hoveredType = PingType.STANDARD;
            }
        } else if (distance <= 40.0) {
            selectedType = null;
            hoveredType = null;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 128).m_5752_();
        buffer.m_252986_(matrix, (float)screenWidth, 0.0f, 0.0f).m_6122_(0, 0, 0, 128).m_5752_();
        buffer.m_252986_(matrix, (float)screenWidth, (float)screenHeight, 0.0f).m_6122_(0, 0, 0, 128).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)screenHeight, 0.0f).m_6122_(0, 0, 0, 128).m_5752_();
        tesselator.m_85914_();
        int segments = 64;
        float innerRadius = 40.0f;
        float outerRadius = 120.0f;
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= segments; ++i) {
            int b;
            int g;
            int r;
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float normalizedAngle = angle;
            if (normalizedAngle < 0.0f) {
                normalizedAngle = (float)((double)normalizedAngle + Math.PI * 2);
            }
            boolean isHovered = false;
            if ((double)normalizedAngle >= 1.5707963267948966 && (double)normalizedAngle < 4.71238898038469) {
                r = 80;
                g = 40;
                b = 40;
                isHovered = hoveredType == PingType.DANGER;
            } else {
                r = 70;
                g = 70;
                b = 70;
                boolean bl = isHovered = hoveredType == PingType.STANDARD;
            }
            if (isHovered) {
                r = Math.min(255, r + 50);
                g = Math.min(255, g + 120);
                b = Math.min(255, b + 50);
            }
            float outerX = (float)centerX + outerRadius * cos;
            float outerY = (float)centerY + outerRadius * sin;
            buffer.m_252986_(matrix, outerX, outerY, 0.0f).m_6122_(r, g, b, 220).m_5752_();
            float innerX = (float)centerX + innerRadius * cos;
            float innerY = (float)centerY + innerRadius * sin;
            buffer.m_252986_(matrix, innerX, innerY, 0.0f).m_6122_(Math.max(0, r - 20), Math.max(0, g - 20), Math.max(0, b - 20), 220).m_5752_();
        }
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float lineThickness = 2.0f;
        float dividerAngle1 = 1.5707964f;
        float cos1 = (float)Math.cos(dividerAngle1);
        float sin1 = (float)Math.sin(dividerAngle1);
        float innerX1 = (float)centerX + innerRadius * cos1;
        float innerY1 = (float)centerY + innerRadius * sin1;
        float outerX1 = (float)centerX + outerRadius * cos1;
        float outerY1 = (float)centerY + outerRadius * sin1;
        buffer.m_252986_(matrix, innerX1 - lineThickness, innerY1, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        buffer.m_252986_(matrix, innerX1 + lineThickness, innerY1, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        buffer.m_252986_(matrix, outerX1 + lineThickness, outerY1, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        buffer.m_252986_(matrix, outerX1 - lineThickness, outerY1, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        float dividerAngle2 = 4.712389f;
        float cos2 = (float)Math.cos(dividerAngle2);
        float sin2 = (float)Math.sin(dividerAngle2);
        float innerX2 = (float)centerX + innerRadius * cos2;
        float innerY2 = (float)centerY + innerRadius * sin2;
        float outerX2 = (float)centerX + outerRadius * cos2;
        float outerY2 = (float)centerY + outerRadius * sin2;
        buffer.m_252986_(matrix, innerX2 - lineThickness, innerY2, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        buffer.m_252986_(matrix, innerX2 + lineThickness, innerY2, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        buffer.m_252986_(matrix, outerX2 + lineThickness, outerY2, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        buffer.m_252986_(matrix, outerX2 - lineThickness, outerY2, 0.0f).m_6122_(255, 255, 255, 200).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        int cursorRadius = 4;
        int cursorX = (int)mouseX;
        int cursorY = (int)mouseY;
        guiGraphics.m_280509_(cursorX - cursorRadius, cursorY - cursorRadius, cursorX + cursorRadius, cursorY + cursorRadius, -1);
        String cancelText = "Cancel";
        int cancelWidth = mc.f_91062_.m_92895_(cancelText);
        guiGraphics.m_280488_(mc.f_91062_, cancelText, centerX - cancelWidth / 2, centerY - 4, distance <= 40.0 ? -16711936 : -3355444);
        float standardAngle = 0.0f;
        int standardTextX = (int)((double)centerX + 80.0 * Math.cos(standardAngle));
        int standardTextY = (int)((double)centerY + 80.0 * Math.sin(standardAngle));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("markit", "textures/gui/standard.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(new ResourceLocation("markit", "textures/gui/standard.png"), standardTextX - 8, standardTextY - 14, 0.0f, 0.0f, 16, 16, 16, 16);
        String standardText = "Standard";
        int standardWidth = mc.f_91062_.m_92895_(standardText);
        guiGraphics.m_280488_(mc.f_91062_, standardText, standardTextX - standardWidth / 2, standardTextY + 4, -1);
        float dangerAngle = (float)Math.PI;
        int dangerCenterX = (int)((double)centerX + 80.0 * Math.cos(dangerAngle));
        int dangerCenterY = (int)((double)centerY + 80.0 * Math.sin(dangerAngle));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("markit", "textures/gui/danger.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(new ResourceLocation("markit", "textures/gui/danger.png"), dangerCenterX - 8, dangerCenterY - 14, 0.0f, 0.0f, 16, 16, 16, 16);
        String dangerText = "Danger";
        int dangerWidth = mc.f_91062_.m_92895_(dangerText);
        guiGraphics.m_280488_(mc.f_91062_, dangerText, dangerCenterX - dangerWidth / 2, dangerCenterY + 4, -48060);
    }
}

