/*
 * Decompiled with CFR 0.152.
 */
package com.example.markit;

import com.example.markit.MarkItConfig;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;

public class ServerMarkerManager {
    private static final Map<UUID, LinkedList<MarkerInfo>> playerMarkers = new HashMap<UUID, LinkedList<MarkerInfo>>();

    public static BlockPos addMarker(UUID playerUUID, BlockPos pos) {
        playerMarkers.putIfAbsent(playerUUID, new LinkedList());
        LinkedList<MarkerInfo> markers = playerMarkers.get(playerUUID);
        long now = System.currentTimeMillis();
        markers.removeIf(m -> now - m.creationTime > (long)((Integer)MarkItConfig.MARKER_DURATION.get()).intValue());
        BlockPos removedPos = null;
        if (markers.size() >= (Integer)MarkItConfig.MAX_MARKERS_PER_PLAYER.get()) {
            MarkerInfo removed = markers.removeFirst();
            removedPos = removed.pos;
        }
        markers.add(new MarkerInfo(pos));
        return removedPos;
    }

    public static BlockPos removeOldest(UUID playerUUID) {
        LinkedList<MarkerInfo> markers = playerMarkers.get(playerUUID);
        if (markers == null || markers.isEmpty()) {
            return null;
        }
        MarkerInfo oldest = markers.removeFirst();
        return oldest.pos;
    }

    private static class MarkerInfo {
        BlockPos pos;
        long creationTime;

        public MarkerInfo(BlockPos pos) {
            this.pos = pos;
            this.creationTime = System.currentTimeMillis();
        }
    }
}

