/*
 * Decompiled with CFR 0.152.
 */
package io.github.yxmna.fancydooranim;

import io.github.yxmna.fancydooranim.DoorAnimationTracker;
import io.github.yxmna.fancydooranim.model.DoorHidingModel;
import io.github.yxmna.fancydooranim.render.DoorAnimatedOverlay;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FancyDoorAnimClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fancy-door-anim");
    private static boolean greeted = false;

    public void onInitializeClient() {
        LOGGER.info("Fancy Door Anim client initializing...");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                return;
            }
            DoorAnimationTracker.pruneExpired();
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> DoorAnimationTracker.clearAll());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> DoorAnimationTracker.clearAll());
        ModelLoadingPlugin.register(ctx -> ctx.modifyModelAfterBake().register((bakedModel, modCtx) -> {
            boolean isDoorModel;
            class_2960 id = modCtx.id();
            if (id == null) {
                return bakedModel;
            }
            String path = id.method_12832();
            boolean bl = isDoorModel = path.contains("_door") || path.contains("/door/") || path.endsWith("door_bottom") || path.endsWith("door_top");
            if (isDoorModel) {
                return new DoorHidingModel(bakedModel);
            }
            return bakedModel;
        }));
        DoorAnimatedOverlay.init();
    }
}

